/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.common;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import cyb0124.curvy_pipes.Mod;
import cyb0124.curvy_pipes.common.CauldronAdapter;
import cyb0124.curvy_pipes.common.ClientResources;
import cyb0124.curvy_pipes.common.SaveData;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLModIdMappingEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.io.IOUtils;

public class CommonHandler {
    private static final ITag.INamedTag<Item> WRENCH = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "tools/wrench"));

    private static native void loadConfig(String var0);

    private static native void registerItems(IForgeRegistry<Item> var0);

    private static native void idMapped();

    private static native void loadLevel(ServerWorld var0, String var1, byte[] var2, ChunkManager var3, WorldSavedData var4);

    private static native void unloadLevel(ServerWorld var0);

    static native byte[] saveLevel(ServerWorld var0);

    private static native void chunkLoaded(ServerWorld var0, int var1, int var2);

    private static native void chunkUnloaded(ServerWorld var0, int var1, int var2);

    private static native void watchChunk(ServerWorld var0, ServerPlayerEntity var1, int var2, int var3);

    private static native void unwatchChunk(ServerPlayerEntity var0, int var1, int var2);

    private static native void tick();

    private static native String[] getRecipes();

    static native String[] itemModelIDs();

    private static native int useItem(int var0, boolean var1, boolean var2);

    public static void loadResources(Map<String, FallbackResourceManager> out, ResourcePackType type) {
        if (type != ResourcePackType.CLIENT_RESOURCES) {
            return;
        }
        FallbackResourceManager mgr = out.get("curvy_pipes");
        if (mgr == null) {
            return;
        }
        mgr.func_199021_a((IResourcePack)new ClientResources());
    }

    public static void applyRecipes(Map<ResourceLocation, JsonElement> out) {
        Gson gson = new Gson();
        String[] recipes = CommonHandler.getRecipes();
        for (int i = 0; i != recipes.length; i += 2) {
            try {
                ResourceLocation name = new ResourceLocation("curvy_pipes", recipes[i]);
                JsonElement recipe = (JsonElement)gson.fromJson(recipes[i + 1], JsonElement.class);
                out.put(name, recipe);
                continue;
            }
            catch (Throwable e) {
                Mod.LOGGER.error("Failed to apply recipe " + recipes[i], e);
            }
        }
    }

    private static void queueWorker(Runnable task) {
        ForkJoinPool.commonPool().execute(task);
    }

    public static double[] getShapeBoxes(VoxelShape shape) {
        DoubleArrayList boxes = new DoubleArrayList();
        shape.func_197755_b((xn, yn, zn, xp, yp, zp) -> {
            boxes.add(xn);
            boxes.add(yn);
            boxes.add(zn);
            boxes.add(xp);
            boxes.add(yp);
            boxes.add(zp);
        });
        return boxes.toDoubleArray();
    }

    private static void offsetBoxes(BlockPos pos, double[] boxes) {
        int i = 0;
        while (i != boxes.length) {
            int n = i++;
            boxes[n] = boxes[n] + (double)pos.func_177958_n();
            int n2 = i++;
            boxes[n2] = boxes[n2] + (double)pos.func_177956_o();
            int n3 = i++;
            boxes[n3] = boxes[n3] + (double)pos.func_177952_p();
        }
    }

    public static double[] getCollisionBoxes(BlockPos pos, BlockState state, World level) {
        double[] boxes = CommonHandler.getShapeBoxes(state.func_196952_d((IBlockReader)level, pos));
        CommonHandler.offsetBoxes(pos, boxes);
        return boxes;
    }

    public static double[] getOutlineBoxes(BlockPos pos, BlockState state, World level) {
        double[] boxes = CommonHandler.getShapeBoxes(state.func_196954_c((IBlockReader)level, pos));
        CommonHandler.offsetBoxes(pos, boxes);
        return boxes;
    }

    private static double[] getCollisionBoxes(ServerWorld level, int cx, int cz, int x, int y, int z) {
        Chunk chunk = level.func_72863_F().func_225313_a(cx, cz);
        if (chunk == null) {
            return new double[0];
        }
        BlockPos pos = new BlockPos(x, y, z);
        return CommonHandler.getCollisionBoxes(pos, chunk.func_180495_p(pos), (World)level);
    }

    private static double[] getOutlineBoxes(ServerWorld level, int cx, int cz, int x, int y, int z) {
        Chunk chunk = level.func_72863_F().func_225313_a(cx, cz);
        if (chunk == null) {
            return new double[0];
        }
        BlockPos pos = new BlockPos(x, y, z);
        return CommonHandler.getOutlineBoxes(pos, chunk.func_180495_p(pos), (World)level);
    }

    public static boolean checkInstabuild(PlayerEntity player) {
        return player.field_71075_bZ.field_75098_d;
    }

    private static double playerReach(PlayerEntity player) {
        return player.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
    }

    private static boolean isHoldingWrench(PlayerEntity player) {
        return player.func_184614_ca().func_77973_b().func_206844_a(WRENCH) || player.func_184592_cb().func_77973_b().func_206844_a(WRENCH);
    }

    public static Stack<ItemStack> gatherStacks(PlayerEntity player, Item item) {
        PlayerInventory inv = player.field_71071_by;
        Stack<ItemStack> result = new Stack<ItemStack>();
        ItemStack selected = inv.func_70448_g();
        if (selected.func_77973_b() == item) {
            result.add(selected);
        }
        for (ItemStack stack : inv.field_70462_a) {
            if (stack == selected || stack.func_77973_b() != item) continue;
            result.add(stack);
        }
        for (ItemStack stack : inv.field_184439_c) {
            if (stack.func_77973_b() != item) continue;
            result.add(stack);
        }
        return result;
    }

    public static int countStacks(Stack<ItemStack> stacks) {
        return stacks.stream().mapToInt(ItemStack::func_190916_E).sum();
    }

    private static void consumeStacks(PlayerEntity player, Stack<ItemStack> stacks, int count) {
        while (count != 0) {
            ItemStack top = stacks.peek();
            int avail = Math.min(top.func_190916_E(), count);
            top.func_190918_g(avail);
            if (top.func_190926_b()) {
                stacks.pop();
            }
            count -= avail;
        }
        player.field_71070_bA.func_75142_b();
    }

    private static void giveStack(PlayerEntity player, Item item, int qty) {
        ItemStack stack = new ItemStack((IItemProvider)item, qty);
        if (player.func_191521_c(stack)) {
            player.field_71070_bA.func_75142_b();
        }
        if (!stack.func_190926_b()) {
            player.func_71019_a(stack, true);
        }
    }

    private static void spawnStack(ServerWorld level, Item item, int qty, double x, double y, double z) {
        ItemEntity entity = new ItemEntity((World)level, x, y, z, new ItemStack((IItemProvider)item, qty));
        entity.func_174869_p();
        level.func_217376_c((Entity)entity);
    }

    private static ItemStack copyItemWithQty(ItemStack stack, int qty) {
        stack = stack.func_77946_l();
        stack.func_190920_e(qty);
        return stack;
    }

    public static int itemId(ItemStack stack) {
        return Item.func_150891_b((Item)stack.func_77973_b());
    }

    private static String itemLoc(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString();
    }

    private static boolean isSameItemAndTag(ItemStack x, ItemStack y) {
        return x.func_77969_a(y) && ItemStack.func_77970_a((ItemStack)x, (ItemStack)y);
    }

    private static int itemTagHash(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
    }

    private static long fluidAndTagCatenatedHash(FluidStack stack) {
        long result = stack.getFluid().hashCode();
        return stack.hasTag() ? result << 32 | (long)stack.getTag().hashCode() : result;
    }

    private static FluidStack copyFluidWithQty(FluidStack stack, int qty) {
        stack = stack.copy();
        stack.setAmount(qty);
        return stack;
    }

    private static byte[] encodeItem(ItemStack stack) throws IOException {
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        CompressedStreamTools.func_74800_a((CompoundNBT)stack.serializeNBT(), (DataOutput)data);
        return data.toByteArray();
    }

    private static ItemStack decodeItem(byte[] data) throws IOException {
        return ItemStack.func_199557_a((CompoundNBT)CompressedStreamTools.func_74794_a((DataInput)ByteStreams.newDataInput((byte[])data)));
    }

    private static byte[] encodeFluid(FluidStack stack) throws IOException {
        CompoundNBT tag = new CompoundNBT();
        stack.writeToNBT(tag);
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        CompressedStreamTools.func_74800_a((CompoundNBT)tag, (DataOutput)data);
        return data.toByteArray();
    }

    private static FluidStack decodeFluid(byte[] data) throws IOException {
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)CompressedStreamTools.func_74794_a((DataInput)ByteStreams.newDataInput((byte[])data)));
    }

    private static FluidStack fluidOfItem(ItemStack stack) {
        Optional result = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve();
        if (result.isPresent()) {
            IFluidHandlerItem cap = (IFluidHandlerItem)result.get();
            int numTanks = cap.getTanks();
            for (int i = 0; i != numTanks; ++i) {
                FluidStack fluid = cap.getFluidInTank(i);
                if (fluid.isEmpty()) continue;
                return fluid;
            }
        }
        return null;
    }

    public static <T> T resolveCap(Capability<T> cap, ServerWorld level, int cx, int cz, int x, int y, int z, byte dir) {
        Chunk chunk = level.func_72863_F().func_225313_a(cx, cz);
        if (chunk == null) {
            return null;
        }
        TileEntity tile = chunk.func_175625_s(new BlockPos(x, y, z));
        if (tile == null) {
            return null;
        }
        return (T)tile.getCapability(cap, Direction.func_82600_a((int)dir)).orElse(null);
    }

    private static IItemHandler resolveItemCap(ServerWorld level, int cx, int cz, int x, int y, int z, byte dir) {
        return (IItemHandler)CommonHandler.resolveCap(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, level, cx, cz, x, y, z, dir);
    }

    private static IFluidHandler resolveFluidCap(ServerWorld level, int cx, int cz, int x, int y, int z, byte dir) {
        Chunk chunk = level.func_72863_F().func_225313_a(cx, cz);
        if (chunk == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = chunk.func_175625_s(pos);
        if (tile != null) {
            return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.func_82600_a((int)dir)).orElse(null);
        }
        if (chunk.func_180495_p(pos).func_203425_a(Blocks.field_150383_bp)) {
            return new CauldronAdapter(chunk, pos);
        }
        return null;
    }

    private static IEnergyStorage resolveEnergyCap(ServerWorld level, int cx, int cz, int x, int y, int z, byte dir) {
        return (IEnergyStorage)CommonHandler.resolveCap(CapabilityEnergy.ENERGY, level, cx, cz, x, y, z, dir);
    }

    private static ItemCapData readItemCap(IItemHandler cap) {
        ItemCapData result = new ItemCapData();
        int nSlots = cap.getSlots();
        ItemCapData.access$202(result, new int[nSlots * 2]);
        Object2IntLinkedOpenHashMap itemMap = new Object2IntLinkedOpenHashMap();
        for (int i = 0; i != nSlots; ++i) {
            ItemStack stack = cap.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            HashedStack hashed = new HashedStack(stack, CommonHandler.itemId(stack), CommonHandler.itemTagHash(stack));
            int oldSize = itemMap.size();
            ((ItemCapData)result).slots[i * 2] = (Integer)itemMap.computeIfAbsent((Object)hashed, ignored -> oldSize);
            ((ItemCapData)result).slots[i * 2 + 1] = stack.func_190916_E();
        }
        int size = itemMap.size();
        ItemCapData.access$402(result, new ItemStack[size]);
        ItemCapData.access$502(result, new int[size * 2]);
        int i = 0;
        for (HashedStack hashed : itemMap.keySet()) {
            ((ItemCapData)result).stacks[i] = CommonHandler.copyItemWithQty(hashed.stack, 1);
            ((ItemCapData)result).hashes[i * 2] = hashed.id;
            ((ItemCapData)result).hashes[i * 2 + 1] = hashed.tagHash;
            ++i;
        }
        return result;
    }

    private static FluidCapData readFluidCap(IFluidHandler cap) {
        FluidCapData result = new FluidCapData();
        int nTanks = cap.getTanks();
        FluidCapData.access$1002(result, new long[nTanks * 2]);
        FluidCapData.access$1102(result, new FluidStack[nTanks]);
        for (int i = 0; i != nTanks; ++i) {
            FluidStack stack = cap.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            ((FluidCapData)result).hashes[i * 2] = CommonHandler.fluidAndTagCatenatedHash(stack);
            ((FluidCapData)result).hashes[i * 2 + 1] = stack.getAmount();
            ((FluidCapData)result).stacks[i] = CommonHandler.copyFluidWithQty(stack, 1);
        }
        return result;
    }

    public static void onLevelLoad(WorldEvent.Load evt) {
        IWorld w = evt.getWorld();
        if (!(w instanceof ServerWorld)) {
            return;
        }
        ServerWorld level = (ServerWorld)w;
        SaveData data = (SaveData)level.func_217481_x().func_215752_a(SaveData::new, "curvy_pipes");
        data.level = level;
        CommonHandler.loadLevel(level, level.func_234923_W_().func_240901_a_().toString(), data.toLoad, level.func_72863_F().field_217237_a, data);
        data.toLoad = null;
    }

    public static void onChunkLoad(ChunkEvent.Load evt) {
        IWorld w = evt.getWorld();
        if (!(w instanceof ServerWorld)) {
            return;
        }
        ChunkPos pos = evt.getChunk().func_76632_l();
        CommonHandler.chunkLoaded((ServerWorld)w, pos.field_77276_a, pos.field_77275_b);
    }

    public static void onChunkUnload(ChunkEvent.Unload evt) {
        IWorld w = evt.getWorld();
        if (!(w instanceof ServerWorld)) {
            return;
        }
        ChunkPos pos = evt.getChunk().func_76632_l();
        CommonHandler.chunkUnloaded((ServerWorld)w, pos.field_77276_a, pos.field_77275_b);
    }

    public static void onLevelUnload(WorldEvent.Unload evt) {
        IWorld w = evt.getWorld();
        CommonHandler.unloadLevel(w instanceof ServerWorld ? (ServerWorld)w : null);
    }

    public static void onChunkWatch(ChunkWatchEvent.Watch evt) {
        ChunkPos pos = evt.getPos();
        CommonHandler.watchChunk(evt.getWorld(), evt.getPlayer(), pos.field_77276_a, pos.field_77275_b);
    }

    public static void onChunkUnwatch(ChunkWatchEvent.UnWatch evt) {
        ChunkPos pos = evt.getPos();
        CommonHandler.unwatchChunk(evt.getPlayer(), pos.field_77276_a, pos.field_77275_b);
    }

    public static void loadConfig() {
        String config;
        String defaultConfig;
        Path defaultPath = FMLPaths.CONFIGDIR.get().resolve("curvy_pipes_default.yaml");
        Path path = FMLPaths.CONFIGDIR.get().resolve("curvy_pipes.yaml");
        try (InputStream is = Mod.class.getResourceAsStream("/default.yaml");){
            defaultConfig = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            Files.write(defaultPath, defaultConfig.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            config = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            config = defaultConfig;
        }
        CommonHandler.loadConfig(config);
    }

    public static void onRegisterItems(RegistryEvent.Register<Item> evt) {
        CommonHandler.registerItems((IForgeRegistry<Item>)evt.getRegistry());
    }

    public static void onIdMap(FMLModIdMappingEvent ignored) {
        CommonHandler.idMapped();
    }

    public static void onCommonSetup(FMLCommonSetupEvent ignored) {
        CommonHandler.idMapped();
    }

    public static void onTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            CommonHandler.tick();
        }
    }

    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
        if (CommonHandler.useItem(CommonHandler.itemId(evt.getItemStack()), evt.getHand() == Hand.OFF_HAND, false) != 0) {
            evt.setUseItem(Event.Result.DENY);
        }
    }

    public static void onRightClickItem(PlayerInteractEvent.RightClickItem evt) {
        int result = CommonHandler.useItem(CommonHandler.itemId(evt.getItemStack()), evt.getHand() == Hand.OFF_HAND, evt.getWorld().field_72995_K);
        if (result != 0) {
            evt.setCanceled(true);
            evt.setCancellationResult(result == 1 ? ActionResultType.CONSUME : ActionResultType.FAIL);
        }
    }

    private static class FluidCapData {
        private long[] hashes;
        private FluidStack[] stacks;

        private FluidCapData() {
        }

        static /* synthetic */ long[] access$1002(FluidCapData x0, long[] x1) {
            x0.hashes = x1;
            return x1;
        }

        static /* synthetic */ FluidStack[] access$1102(FluidCapData x0, FluidStack[] x1) {
            x0.stacks = x1;
            return x1;
        }
    }

    private static class ItemCapData {
        private int[] slots;
        private int[] hashes;
        private ItemStack[] stacks;

        private ItemCapData() {
        }

        static /* synthetic */ int[] access$202(ItemCapData x0, int[] x1) {
            x0.slots = x1;
            return x1;
        }

        static /* synthetic */ ItemStack[] access$402(ItemCapData x0, ItemStack[] x1) {
            x0.stacks = x1;
            return x1;
        }

        static /* synthetic */ int[] access$502(ItemCapData x0, int[] x1) {
            x0.hashes = x1;
            return x1;
        }
    }

    private static class HashedStack {
        private final ItemStack stack;
        private final int id;
        private final int tagHash;

        private HashedStack(ItemStack stack, int id, int tagHash) {
            this.stack = stack;
            this.id = id;
            this.tagHash = tagHash;
        }

        public int hashCode() {
            return 31 * (31 + this.id) + this.tagHash;
        }

        public boolean equals(Object o) {
            return CommonHandler.isSameItemAndTag(this.stack, ((HashedStack)o).stack);
        }
    }
}

