/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.compat;

import appeng.api.config.Actionable;
import appeng.api.definitions.IParts;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyGridProvider;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.Api;
import cyb0124.curvy_pipes.compat.AEIconItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.IntConsumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AEPlugin {
    private static AEIconItem ICON_ITEM;

    private static native void addCable(int var0, int var1, String var2, Item var3, ResourceLocation var4);

    private static native void markBlock(World var0, int var1, int var2, int var3);

    public static void markBlock(IGridNode node) {
        DimensionalCoord loc = node.getGridBlock().getLocation();
        World world = loc.getWorld();
        if (World.func_189509_E((BlockPos)new BlockPos((Vector3i)loc.getPos()))) {
            return;
        }
        AEPlugin.markBlock(world, loc.x, loc.y, loc.z);
    }

    private static void addCable(int type, AEColor color, Item item, String sprite) {
        AEPlugin.addCable(type, color.whiteVariant, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).func_110623_a(), item, new ResourceLocation("appliedenergistics2", sprite));
    }

    private static void addCables() {
        IParts parts = Api.instance().definitions().parts();
        AEPlugin.addCable(0, AEColor.TRANSPARENT, parts.quartzFiber().item(), "part/quartz_fiber");
        for (AEColor color : AEColor.values()) {
            String suffix = color.name().toLowerCase(Locale.ROOT);
            AEPlugin.addCable(1, color, parts.cableGlass().item(color), "part/cable/glass/" + suffix);
            AEPlugin.addCable(2, color, parts.cableCovered().item(color), "part/cable/covered/" + suffix);
            AEPlugin.addCable(3, color, parts.cableSmart().item(color), "part/cable/smart/" + suffix);
            AEPlugin.addCable(4, color, parts.cableDenseCovered().item(color), "part/cable/dense_covered/" + suffix);
            AEPlugin.addCable(5, color, parts.cableDenseSmart().item(color), "part/cable/dense_smart/" + suffix);
        }
    }

    private static void registerIconItem(IForgeRegistry<Item> reg, String id) {
        if (ICON_ITEM == null) {
            ICON_ITEM = new AEIconItem(id);
        }
        reg.register((IForgeRegistryEntry)ICON_ITEM);
    }

    private static ItemStack makeIconItem(Item pipe, boolean joint) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("pipe", pipe.getRegistryName().toString());
        if (joint) {
            tag.func_74757_a("joint", true);
        }
        ItemStack result = new ItemStack((IItemProvider)ICON_ITEM);
        result.func_77982_d(tag);
        return result;
    }

    private static IGridNode addNode(ServerWorld level, Item pipe, IntConsumer setOverlayIdx, byte capacity, boolean joint) {
        IGridNode node = new NodeOwner((ServerWorld)level, (ItemStack)AEPlugin.makeIconItem((Item)pipe, (boolean)joint), (IntConsumer)setOverlayIdx, (GridFlags)(capacity == 0 ? GridFlags.CANNOT_CARRY : (capacity == 1 ? GridFlags.PREFERRED : GridFlags.DENSE_CAPACITY))).node;
        node.updateState();
        return node;
    }

    private static IGridNode[] addEnergyPair(ServerWorld level, Item pipe) {
        ItemStack icon = AEPlugin.makeIconItem(pipe, false);
        EnergyNodeOwner x = new EnergyNodeOwner(level, icon);
        EnergyNodeOwner y = new EnergyNodeOwner(level, icon);
        x.peer = y.node;
        y.peer = x.node;
        x.node.updateState();
        y.node.updateState();
        return new IGridNode[]{x.node, y.node};
    }

    private static void addNodeConn(IGridNode x, IGridNode y) {
        for (IGridConnection c : x.getConnections()) {
            if (c.a() != y && c.b() != y) continue;
            return;
        }
        try {
            Api.INSTANCE.grid().createGridConnection(x, y);
        }
        catch (FailedConnectionException failedConnectionException) {
            // empty catch block
        }
    }

    private static void addBlockConn(IGridNode node, ServerWorld level, int cx, int cz, int x, int y, int z, byte rawDir, boolean ext) {
        IPartHost host;
        Chunk chunk = level.func_72863_F().func_225313_a(cx, cz);
        if (chunk == null) {
            return;
        }
        TileEntity tile = chunk.func_175625_s(new BlockPos(x, y, z));
        if (tile instanceof IPartHost) {
            host = (IPartHost)tile;
            IPart part = host.getPart(AEPartLocation.fromOrdinal((int)rawDir));
            if (part == null) {
                part = host.getPart(AEPartLocation.INTERNAL);
            }
            if (part != null) {
                IGridNode peer;
                IGridNode iGridNode = peer = ext ? part.getExternalFacingNode() : part.getGridNode();
                if (peer != null) {
                    AEPlugin.addNodeConn(node, peer);
                    return;
                }
            }
        }
        if (tile instanceof IGridHost) {
            host = (IGridHost)tile;
            IGridNode peer = host.getGridNode(AEPartLocation.fromOrdinal((int)rawDir));
            if (peer == null) {
                peer = host.getGridNode(AEPartLocation.INTERNAL);
            }
            if (peer != null) {
                AEPlugin.addNodeConn(node, peer);
            }
        }
    }

    public static class EnergyNodeOwner
    extends NodeOwner
    implements IEnergyGridProvider {
        private IGridNode peer;

        private EnergyNodeOwner(ServerWorld level, ItemStack icon) {
            super(level, icon, null, GridFlags.CANNOT_CARRY);
        }

        public Collection<IEnergyGridProvider> providers() {
            return Arrays.asList((IEnergyGridProvider)this.node.getGrid().getCache(IEnergyGrid.class), (IEnergyGridProvider)this.peer.getGrid().getCache(IEnergyGrid.class));
        }

        public double extractProviderPower(double v, Actionable m) {
            return 0.0;
        }

        public double injectProviderPower(double v, Actionable m) {
            return 0.0;
        }

        public double getProviderEnergyDemand(double v) {
            return 0.0;
        }

        public double getProviderStoredEnergy() {
            return 0.0;
        }

        public double getProviderMaxEnergy() {
            return 0.0;
        }
    }

    public static class NodeOwner
    implements IGridBlock,
    IGridHost {
        private final EnumSet<GridFlags> flags;
        private final DimensionalCoord coord;
        private final ItemStack icon;
        private final IntConsumer setOverlayIdx;
        protected final IGridNode node;
        private int lastOverlayIdx;

        private NodeOwner(ServerWorld level, ItemStack icon, IntConsumer setOverlayIdx, GridFlags flag) {
            this.flags = EnumSet.of(flag);
            this.coord = new DimensionalCoord((World)level, 0, -268435456, 0);
            this.icon = icon;
            this.setOverlayIdx = setOverlayIdx;
            this.node = Api.INSTANCE.grid().createGridNode((IGridBlock)this);
        }

        private void updateOverlay() {
            if (this.setOverlayIdx == null) {
                return;
            }
            int overlayIdx = 0;
            IEnergyGrid energy = (IEnergyGrid)this.node.getGrid().getCache(IEnergyGrid.class);
            if (energy.isNetworkPowered()) {
                for (IGridConnection c : this.node.getConnections()) {
                    overlayIdx = Math.max(overlayIdx, c.getUsedChannels());
                }
            }
            if (this.lastOverlayIdx == overlayIdx) {
                return;
            }
            this.lastOverlayIdx = overlayIdx;
            this.setOverlayIdx.accept(overlayIdx);
        }

        @MENetworkEventSubscribe
        public void channelChanged(MENetworkChannelsChanged ignored) {
            this.updateOverlay();
        }

        @MENetworkEventSubscribe
        public void powerChanged(MENetworkPowerStatusChange ignored) {
            this.updateOverlay();
        }

        public double getIdlePowerUsage() {
            return 0.0;
        }

        public EnumSet<GridFlags> getFlags() {
            return this.flags;
        }

        public boolean isWorldAccessible() {
            return false;
        }

        public DimensionalCoord getLocation() {
            return this.coord;
        }

        public AEColor getGridColor() {
            return AEColor.TRANSPARENT;
        }

        public void onGridNotification(GridNotification notification) {
        }

        public EnumSet<Direction> getConnectableSides() {
            return EnumSet.noneOf(Direction.class);
        }

        public IGridHost getMachine() {
            return this;
        }

        public void gridChanged() {
        }

        public ItemStack getMachineRepresentation() {
            return this.icon;
        }

        public IGridNode getGridNode(AEPartLocation location) {
            return this.node;
        }

        public AECableType getCableConnectionType(AEPartLocation location) {
            return AECableType.NONE;
        }

        public void securityBreak() {
        }
    }
}

