/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.obscuria.obscureapi.api.client.ExternalData;
import com.obscuria.obscureapi.api.utils.ExceptionFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ExternalFile
implements ExternalData<JsonObject> {
    private final String LINK;
    private final boolean AUTO_UPLOAD;
    private final Consumer<ExternalFile> CALLBACK;
    private JsonObject FILE;
    private boolean uploaded = false;
    @Nullable
    private CompletableFuture<?> future = null;

    private ExternalFile(String link, boolean autoUpload, Consumer<ExternalFile> callback) {
        this.LINK = link;
        this.AUTO_UPLOAD = autoUpload;
        this.CALLBACK = callback;
        if (this.AUTO_UPLOAD) {
            this.upload();
        }
    }

    @Nonnull
    @Contract(value="_ -> new")
    public static ExternalFile create(String link) {
        return ExternalFile.create(link, false);
    }

    @Nonnull
    @Contract(value="_, _ -> new")
    public static ExternalFile create(String link, boolean autoUpload) {
        return ExternalFile.create(link, autoUpload, externalFile -> {});
    }

    @Nonnull
    @Contract(value="_, _, _ -> new")
    public static ExternalFile create(String link, boolean autoUpload, Consumer<ExternalFile> callback) {
        return new ExternalFile(link, autoUpload, callback);
    }

    @Override
    public boolean isInProgress() {
        return this.future != null;
    }

    @Override
    public boolean isUploaded() {
        return this.uploaded;
    }

    @Override
    public JsonObject get() {
        if (this.uploaded) {
            return this.FILE;
        }
        if (this.AUTO_UPLOAD) {
            this.upload();
        }
        return new JsonObject();
    }

    public ExternalFile upload() {
        if (this.isInProgress()) {
            return this;
        }
        this.future = CompletableFuture.runAsync(() -> {
            this.FILE = ExceptionFilter.getNoNull(new JsonObject(), () -> {
                URL url = new URL(this.LINK);
                URLConnection request = url.openConnection();
                request.connect();
                JsonElement root = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)request.getContent()));
                if (root != null) {
                    this.uploaded = true;
                }
                this.future = null;
                return root.getAsJsonObject();
            }, e -> {
                this.future = null;
            });
            if (this.uploaded) {
                this.CALLBACK.accept(this);
            }
        }, Util.m_183991_());
        return this;
    }
}

