/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.utils;

import com.obscuria.obscureapi.util.EntityUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class RelativeOffset {
    public float FORWARD;
    public float LEFT;
    public float UP;

    private RelativeOffset(float forward, float left, float up) {
        this.FORWARD = forward;
        this.LEFT = left;
        this.UP = up;
    }

    public static RelativeOffset of(float forward, float left, float up) {
        return new RelativeOffset(forward, left, up);
    }

    public RelativeOffset add(float forward, float left, float up) {
        return new RelativeOffset(this.FORWARD + forward, this.LEFT + left, this.UP + up);
    }

    public RelativeOffset scale(float forward, float left, float up) {
        return new RelativeOffset(this.FORWARD * forward, this.LEFT * left, this.UP * up);
    }

    public Vec3 calculate(Entity entity) {
        return EntityUtils.getRelativePos(entity, this.FORWARD, this.LEFT, this.UP);
    }
}

