/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.tooltips.client.style;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class StyleFilter {
    public int priority = 1000;
    private final JsonObject TAG = new JsonObject();
    private final List<Item> ITEMS = new ArrayList<Item>();
    private final List<String> MODS = new ArrayList<String>();
    private final List<String> RARITIES = new ArrayList<String>();
    private final List<String> ENCHANTMENTS_ANY_MATCH = new ArrayList<String>();
    private final List<String> ENCHANTMENTS_ALL_MATCH = new ArrayList<String>();
    private final List<String> KEYWORDS_ANY_MATCH = new ArrayList<String>();
    private final List<String> KEYWORDS_ALL_MATCH = new ArrayList<String>();
    private final List<String> KEYWORDS_NONE_MATCH = new ArrayList<String>();

    private StyleFilter() {
    }

    public static StyleFilter fromJson(JsonObject root) {
        StyleFilter predicate = new StyleFilter();
        if (root.has("items")) {
            for (JsonElement element : root.get("items").getAsJsonArray()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(element.getAsString()));
                if (item == null) continue;
                predicate.ITEMS.add(item);
            }
        }
        if (root.has("mods")) {
            for (JsonElement element : root.get("mods").getAsJsonArray()) {
                predicate.MODS.add(element.getAsString().toLowerCase());
            }
        }
        if (root.has("rarity")) {
            predicate.RARITIES.add(root.get("rarity").getAsString().toLowerCase());
        }
        if (root.has("rarities")) {
            for (JsonElement element : root.get("rarities").getAsJsonArray()) {
                predicate.RARITIES.add(element.getAsString().toLowerCase());
            }
        }
        if (root.has("tag")) {
            JsonObject tag = root.getAsJsonObject("tag");
            for (String key : tag.keySet()) {
                predicate.TAG.add(key, tag.get(key));
            }
        }
        if (root.has("enchantments")) {
            JsonObject enchantments = root.getAsJsonObject("enchantments");
            if (enchantments.has("any_match")) {
                for (JsonElement element : enchantments.get("any_match").getAsJsonArray()) {
                    predicate.ENCHANTMENTS_ANY_MATCH.add(element.getAsString().toLowerCase());
                }
            }
            if (enchantments.has("all_match")) {
                for (JsonElement element : enchantments.get("all_match").getAsJsonArray()) {
                    predicate.ENCHANTMENTS_ALL_MATCH.add(element.getAsString().toLowerCase());
                }
            }
        }
        if (root.has("keywords")) {
            JsonObject keywords = root.getAsJsonObject("keywords");
            if (keywords.has("any_match")) {
                for (JsonElement element : keywords.get("any_match").getAsJsonArray()) {
                    predicate.KEYWORDS_ANY_MATCH.add(element.getAsString().toLowerCase());
                }
            }
            if (keywords.has("all_match")) {
                for (JsonElement element : keywords.get("all_match").getAsJsonArray()) {
                    predicate.KEYWORDS_ALL_MATCH.add(element.getAsString().toLowerCase());
                }
            }
            if (keywords.has("none_match")) {
                for (JsonElement element : keywords.get("none_match").getAsJsonArray()) {
                    predicate.KEYWORDS_NONE_MATCH.add(element.getAsString().toLowerCase());
                }
            }
        }
        return predicate;
    }

    public boolean test(ItemStack stack) {
        if (!this.MODS.isEmpty() && !this.MODS.contains(this.getNamespace(stack))) {
            return false;
        }
        if (!this.RARITIES.isEmpty() && !this.RARITIES.contains(stack.m_41791_().name().toLowerCase())) {
            return false;
        }
        if (this.TAG.size() > 0 && this.hasTagMismatch(stack)) {
            return false;
        }
        if (!this.ENCHANTMENTS_ANY_MATCH.isEmpty() && this.hasEnchantmentMismatch(stack, this.ENCHANTMENTS_ANY_MATCH, results -> results.stream().anyMatch(result -> result))) {
            return false;
        }
        if (!this.ENCHANTMENTS_ALL_MATCH.isEmpty() && this.hasEnchantmentMismatch(stack, this.ENCHANTMENTS_ALL_MATCH, results -> results.stream().allMatch(result -> result))) {
            return false;
        }
        if (!this.KEYWORDS_ANY_MATCH.isEmpty() && this.hasKeywordMismatch(stack, this.KEYWORDS_ANY_MATCH, results -> results.stream().anyMatch(result -> result))) {
            return false;
        }
        if (!this.KEYWORDS_ALL_MATCH.isEmpty() && this.hasKeywordMismatch(stack, this.KEYWORDS_ALL_MATCH, results -> results.stream().allMatch(result -> result))) {
            return false;
        }
        if (!this.KEYWORDS_NONE_MATCH.isEmpty() && this.hasKeywordMismatch(stack, this.KEYWORDS_NONE_MATCH, results -> results.stream().noneMatch(result -> result))) {
            return false;
        }
        return this.ITEMS.isEmpty() || this.ITEMS.contains(stack.m_41720_());
    }

    public String toString() {
        return "StyleFilter<%s>".formatted(this.priority);
    }

    private boolean hasEnchantmentMismatch(ItemStack stack, List<String> enchantments, Mode mode) {
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        Set set = stack.getAllEnchantments().keySet();
        for (String key : enchantments) {
            results.add(set.stream().anyMatch(enchantment -> {
                ResourceLocation enchantmentKey = ForgeRegistries.ENCHANTMENTS.getKey(enchantment);
                return enchantmentKey != null && enchantmentKey.toString().equals(key);
            }));
        }
        return !mode.test(results);
    }

    private boolean hasKeywordMismatch(ItemStack stack, List<String> keywords, Mode mode) {
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        for (String key : keywords) {
            if (key.equals("enchanted")) {
                results.add(stack.m_41793_());
            }
            if (key.equals("enchanted_book")) {
                results.add(stack.m_41720_() instanceof EnchantedBookItem);
            }
            if (key.equals("cursed")) {
                results.add(stack.getAllEnchantments().entrySet().stream().anyMatch(entry -> ((Enchantment)entry.getKey()).m_6589_()));
            }
            if (!key.equals("foil")) continue;
            results.add(stack.m_41790_());
        }
        return !mode.test(results);
    }

    private boolean hasTagMismatch(ItemStack stack) {
        if (!stack.m_41782_()) {
            return true;
        }
        try {
            for (String key : this.TAG.keySet()) {
                if (!stack.m_41784_().m_128441_(key)) {
                    return true;
                }
                if (!this.TAG.get(key).isJsonPrimitive()) {
                    return true;
                }
                JsonPrimitive value = this.TAG.get(key).getAsJsonPrimitive();
                if (value.isString() && value.getAsString().equals(stack.m_41784_().m_128461_(key)) || value.isBoolean() && value.getAsBoolean() == stack.m_41784_().m_128471_(key) || value.isNumber() && (value.getAsInt() == stack.m_41784_().m_128451_(key) || value.getAsDouble() == stack.m_41784_().m_128459_(key) || value.getAsFloat() == stack.m_41784_().m_128457_(key) || value.getAsByte() == stack.m_41784_().m_128445_(key))) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private String getNamespace(ItemStack stack) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        return key != null ? key.m_135827_() : "null";
    }

    @FunctionalInterface
    protected static interface Mode {
        public boolean test(List<Boolean> var1);
    }
}

