/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\f\u001a\u00020\u000b\"\b\b\u0000\u0010\u0005*\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Ldev/obscuria/fragmentum/client/TooltipComponentRegistry;", "", "<init>", "()V", "Lnet/minecraft/class_5632;", "T", "Ljava/lang/Class;", "type", "Ljava/util/function/Function;", "Lnet/minecraft/class_5684;", "factory", "", "register", "(Ljava/lang/Class;Ljava/util/function/Function;)V", "component", "Ljava/util/Optional;", "create", "(Lnet/minecraft/class_5632;)Ljava/util/Optional;", "", "Ldev/obscuria/fragmentum/client/TooltipComponentRegistry$Definition;", "definitions", "Ljava/util/List;", "Definition", "fragmentum-fabric-1.20.1"})
public final class TooltipComponentRegistry {
    @NotNull
    public static final TooltipComponentRegistry INSTANCE = new TooltipComponentRegistry();
    @NotNull
    private static final List<Definition<?>> definitions;

    private TooltipComponentRegistry() {
    }

    public final <T extends class_5632> void register(@NotNull Class<T> type, @NotNull Function<T, class_5684> factory) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        if (definitions.stream().anyMatch(arg_0 -> TooltipComponentRegistry.register$lambda$1(arg_0 -> TooltipComponentRegistry.register$lambda$0(type, arg_0), arg_0))) {
            return;
        }
        definitions.add(new Definition<T>(type, factory));
    }

    @NotNull
    public final Optional<class_5684> create(@NotNull class_5632 component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        for (Definition<?> definition : definitions) {
            if (!definition.isFor(component)) continue;
            return definition.create(component);
        }
        Optional<class_5684> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        return optional;
    }

    private static final boolean register$lambda$0(Class $type, Definition it) {
        return Intrinsics.areEqual(it.getType(), (Object)$type);
    }

    private static final boolean register$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        definitions = arrayList;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003B)\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J<\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u0019\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010\u0013R#\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010#\u001a\u0004\b$\u0010\u0015\u00a8\u0006%"}, d2={"Ldev/obscuria/fragmentum/client/TooltipComponentRegistry$Definition;", "Lnet/minecraft/class_5632;", "T", "", "Ljava/lang/Class;", "type", "Ljava/util/function/Function;", "Lnet/minecraft/class_5684;", "factory", "<init>", "(Ljava/lang/Class;Ljava/util/function/Function;)V", "component", "", "isFor", "(Lnet/minecraft/class_5632;)Z", "Ljava/util/Optional;", "create", "(Lnet/minecraft/class_5632;)Ljava/util/Optional;", "component1", "()Ljava/lang/Class;", "component2", "()Ljava/util/function/Function;", "copy", "(Ljava/lang/Class;Ljava/util/function/Function;)Ldev/obscuria/fragmentum/client/TooltipComponentRegistry$Definition;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Class;", "getType", "Ljava/util/function/Function;", "getFactory", "fragmentum-fabric-1.20.1"})
    private static final class Definition<T extends class_5632> {
        @NotNull
        private final Class<T> type;
        @NotNull
        private final Function<T, class_5684> factory;

        public Definition(@NotNull Class<T> type, @NotNull Function<T, class_5684> factory) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            this.type = type;
            this.factory = factory;
        }

        @NotNull
        public final Class<T> getType() {
            return this.type;
        }

        @NotNull
        public final Function<T, class_5684> getFactory() {
            return this.factory;
        }

        public final boolean isFor(@NotNull class_5632 component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            return Intrinsics.areEqual(component.getClass(), this.type);
        }

        @NotNull
        public final Optional<class_5684> create(@NotNull class_5632 component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Optional<class_5684> optional = Optional.of(this.factory.apply(this.type.cast(component)));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            return optional;
        }

        @NotNull
        public final Class<T> component1() {
            return this.type;
        }

        @NotNull
        public final Function<T, class_5684> component2() {
            return this.factory;
        }

        @NotNull
        public final Definition<T> copy(@NotNull Class<T> type, @NotNull Function<T, class_5684> factory) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            return new Definition<T>(type, factory);
        }

        public static /* synthetic */ Definition copy$default(Definition definition, Class clazz, Function function, int n, Object object) {
            if ((n & 1) != 0) {
                clazz = definition.type;
            }
            if ((n & 2) != 0) {
                function = definition.factory;
            }
            return definition.copy(clazz, function);
        }

        @NotNull
        public String toString() {
            return "Definition(type=" + this.type + ", factory=" + this.factory + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.factory.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Definition)) {
                return false;
            }
            Definition definition = (Definition)other;
            if (!Intrinsics.areEqual(this.type, definition.type)) {
                return false;
            }
            return Intrinsics.areEqual(this.factory, definition.factory);
        }
    }
}

