/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.tools;

import dev.obscuria.fragmentum.tools.ARGB;
import dev.obscuria.fragmentum.tools.HSV;
import dev.obscuria.fragmentum.tools.RGB;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0003\u0010\u0006\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0003\u0010\t\u001a-\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\u0003\u0010\u000f\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0003\u0010\u0012\u001a\u001b\u0010\u0003\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0013\u00a2\u0006\u0004\b\u0003\u0010\u0014\u001a\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0004\u001a\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0001\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0006\u001a\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0016\u0010\t\u001a%\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0012\u001a\u001b\u0010\u0016\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0014\u001a%\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a!\u0010 \u001a\u00020\u00152\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00050\u001e\u00a2\u0006\u0004\b \u0010!\u00a8\u0006\""}, d2={"", "decimal", "Ldev/obscuria/fragmentum/tools/ARGB;", "argbOf", "(J)I", "", "(I)I", "", "hexadecimal", "(Ljava/lang/String;)I", "", "alpha", "red", "green", "blue", "(FFFF)I", "", "normalized", "([F)I", "", "(Ljava/util/List;)I", "Ldev/obscuria/fragmentum/tools/RGB;", "rgbOf", "(FFF)I", "hue", "saturation", "value", "Ldev/obscuria/fragmentum/tools/HSV;", "hsvOf", "(FFF)[F", "", "entries", "averageRGB", "(Ljava/util/Map;)I", "fragmentum-fabric-1.20.1"})
public final class ColorsKt {
    public static final int argbOf(long decimal) {
        return ARGB.constructor-impl((int)decimal);
    }

    public static final int argbOf(int decimal) {
        return ARGB.constructor-impl(decimal);
    }

    public static final int argbOf(@NotNull String hexadecimal) {
        Intrinsics.checkNotNullParameter((Object)hexadecimal, (String)"hexadecimal");
        String cleanHex = StringsKt.removePrefix((String)hexadecimal, (CharSequence)"#");
        int color = (int)Long.parseLong(cleanHex, CharsKt.checkRadix((int)16));
        return ARGB.constructor-impl(color);
    }

    public static final int argbOf(float alpha, float red, float green, float blue) {
        int a = RangesKt.coerceIn((int)((int)(alpha * (float)255)), (int)0, (int)255);
        int r = RangesKt.coerceIn((int)((int)(red * (float)255)), (int)0, (int)255);
        int g = RangesKt.coerceIn((int)((int)(green * (float)255)), (int)0, (int)255);
        int b = RangesKt.coerceIn((int)((int)(blue * (float)255)), (int)0, (int)255);
        int color = a << 24 | r << 16 | g << 8 | b;
        return ARGB.constructor-impl(color);
    }

    public static final int argbOf(@NotNull float[] normalized) {
        Intrinsics.checkNotNullParameter((Object)normalized, (String)"normalized");
        if (normalized.length != 4) {
            throw new IllegalArgumentException();
        }
        return ColorsKt.argbOf(normalized[0], normalized[1], normalized[2], normalized[3]);
    }

    public static final int argbOf(@NotNull List<Float> normalized) {
        Intrinsics.checkNotNullParameter(normalized, (String)"normalized");
        if (normalized.size() != 4) {
            throw new IllegalArgumentException();
        }
        return ColorsKt.argbOf(((Number)normalized.get(0)).floatValue(), ((Number)normalized.get(1)).floatValue(), ((Number)normalized.get(2)).floatValue(), ((Number)normalized.get(3)).floatValue());
    }

    public static final int rgbOf(long decimal) {
        return RGB.constructor-impl((int)decimal);
    }

    public static final int rgbOf(int decimal) {
        return RGB.constructor-impl(decimal);
    }

    public static final int rgbOf(@NotNull String hexadecimal) {
        Intrinsics.checkNotNullParameter((Object)hexadecimal, (String)"hexadecimal");
        String cleanHex = StringsKt.removePrefix((String)hexadecimal, (CharSequence)"#");
        int color = Integer.parseInt(cleanHex, CharsKt.checkRadix((int)16)) | 0xFF000000;
        return RGB.constructor-impl(color);
    }

    public static final int rgbOf(float red, float green, float blue) {
        int r = RangesKt.coerceIn((int)((int)(red * (float)255)), (int)0, (int)255);
        int g = RangesKt.coerceIn((int)((int)(green * (float)255)), (int)0, (int)255);
        int b = RangesKt.coerceIn((int)((int)(blue * (float)255)), (int)0, (int)255);
        int color = r << 16 | g << 8 | b;
        return RGB.constructor-impl(color);
    }

    public static final int rgbOf(@NotNull float[] normalized) {
        Intrinsics.checkNotNullParameter((Object)normalized, (String)"normalized");
        if (normalized.length != 3) {
            throw new IllegalArgumentException();
        }
        return ColorsKt.rgbOf(normalized[0], normalized[1], normalized[2]);
    }

    public static final int rgbOf(@NotNull List<Float> normalized) {
        Intrinsics.checkNotNullParameter(normalized, (String)"normalized");
        if (normalized.size() != 3) {
            throw new IllegalArgumentException();
        }
        return ColorsKt.rgbOf(((Number)normalized.get(0)).floatValue(), ((Number)normalized.get(1)).floatValue(), ((Number)normalized.get(2)).floatValue());
    }

    @NotNull
    public static final float[] hsvOf(float hue, float saturation, float value) {
        float[] fArray = new float[]{hue, saturation, value};
        return HSV.constructor-impl(fArray);
    }

    public static final int averageRGB(@NotNull Map<RGB, Integer> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        if (entries.isEmpty()) {
            return ColorsKt.rgbOf(0);
        }
        int totalWeight = 0;
        float sumR = 0.0f;
        float sumG = 0.0f;
        float sumB = 0.0f;
        for (Map.Entry<RGB, Integer> entry : entries.entrySet()) {
            int rgb = entry.getKey().unbox-impl();
            int weight = ((Number)entry.getValue()).intValue();
            if (weight <= 0) continue;
            totalWeight += weight;
            sumR += RGB.component1-impl(rgb) * (float)weight;
            sumG += RGB.component2-impl(rgb) * (float)weight;
            sumB += RGB.component3-impl(rgb) * (float)weight;
        }
        if (totalWeight == 0) {
            return ColorsKt.rgbOf(0);
        }
        return ColorsKt.rgbOf(sumR / (float)totalWeight, sumG / (float)totalWeight, sumB / (float)totalWeight);
    }
}

