/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.tools.easing;

import dev.obscuria.fragmentum.tools.easing.EasingFunction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\t\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000b\u00a2\u0006\u0004\b\t\u0010\fJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Ldev/obscuria/fragmentum/tools/easing/CubicCurve;", "", "", "resolution", "<init>", "(I)V", "", "x", "y", "addPoint", "(DD)Ldev/obscuria/fragmentum/tools/easing/CubicCurve;", "", "(FF)Ldev/obscuria/fragmentum/tools/easing/CubicCurve;", "Ldev/obscuria/fragmentum/tools/easing/CubicCurve$Point;", "samplePoint", "(F)Ldev/obscuria/fragmentum/tools/easing/CubicCurve$Point;", "sample", "(F)F", "Ldev/obscuria/fragmentum/tools/easing/EasingFunction;", "asEasing", "()Ldev/obscuria/fragmentum/tools/easing/EasingFunction;", "", "bake", "()V", "", "rawPoints", "Ljava/util/List;", "cachedPoints", "I", "", "dirty", "Z", "Point", "fragmentum-fabric-1.20.1"})
public final class CubicCurve {
    @NotNull
    private final List<Point> rawPoints = new ArrayList();
    @NotNull
    private final List<Point> cachedPoints = new ArrayList();
    private final int resolution;
    private boolean dirty;

    public CubicCurve(int resolution) {
        this.resolution = (int)Math.min(Math.max((double)resolution, 0.0), 100.0);
        this.dirty = true;
    }

    @NotNull
    public final CubicCurve addPoint(double x, double y) {
        return this.addPoint((float)x, (float)y);
    }

    @NotNull
    public final CubicCurve addPoint(float x, float y) {
        this.rawPoints.add(new Point(class_3532.method_15363((float)x, (float)0.0f, (float)1.0f), class_3532.method_15363((float)x, (float)0.0f, (float)1.0f)));
        Comparator<Object> comparator = Comparator.comparingDouble(arg_0 -> CubicCurve.addPoint$lambda$1(CubicCurve::addPoint$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparingDouble(...)");
        CollectionsKt.sortWith(this.rawPoints, comparator);
        this.dirty = true;
        return this;
    }

    @NotNull
    public final Point samplePoint(float x) {
        if (this.dirty) {
            this.bake();
        }
        if (this.cachedPoints.isEmpty()) {
            return Point.Companion.getZERO();
        }
        int index = (int)class_3532.method_15363((float)(x * (float)(this.cachedPoints.size() - 1)), (float)0.0f, (float)(this.cachedPoints.size() - 1));
        return this.cachedPoints.get(index);
    }

    public final float sample(float x) {
        return this.samplePoint(x).getY();
    }

    @NotNull
    public final EasingFunction asEasing() {
        return new EasingFunction(this){
            final /* synthetic */ CubicCurve this$0;
            {
                this.this$0 = $receiver;
            }

            public final float compute(float progress) {
                return this.this$0.sample(progress);
            }

            public EasingFunction scale(float scale2) {
                return EasingFunction.DefaultImpls.scale(this, scale2);
            }

            public EasingFunction reversed() {
                return EasingFunction.DefaultImpls.reversed(this);
            }

            public EasingFunction merge(EasingFunction other, float ratio) {
                return EasingFunction.DefaultImpls.merge(this, other, ratio);
            }

            public EasingFunction mergeOut(EasingFunction other, float ratio) {
                return EasingFunction.DefaultImpls.mergeOut(this, other, ratio);
            }
        };
    }

    private final void bake() {
        this.dirty = false;
        this.cachedPoints.clear();
        float res = 1.0f / (float)this.resolution;
        int segments = this.rawPoints.size() - 1;
        for (int i2 = 0; i2 < segments; ++i2) {
            Point point = this.rawPoints.get(i2);
            Point nextPoint = this.rawPoints.get(i2 + 1);
            float xDiff = nextPoint.getX() - point.getX();
            float yDiff = nextPoint.getY() - point.getY();
            for (float step = 0.0f; step <= 1.0f; step += res) {
                float x = point.getX() + step * xDiff;
                float y = point.getY() + step * step * ((float)3 * yDiff - (float)2 * step * yDiff);
                this.cachedPoints.add(new Point(x, y));
            }
        }
    }

    private static final double addPoint$lambda$0(Point it) {
        return it.getX();
    }

    private static final double addPoint$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).doubleValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0018\u0010\b\u00a8\u0006\u001a"}, d2={"Ldev/obscuria/fragmentum/tools/easing/CubicCurve$Point;", "", "", "x", "y", "<init>", "(FF)V", "component1", "()F", "component2", "copy", "(FF)Ldev/obscuria/fragmentum/tools/easing/CubicCurve$Point;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "getX", "getY", "Companion", "fragmentum-fabric-1.20.1"})
    public static final class Point {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final float x;
        private final float y;
        @NotNull
        private static final Point ZERO = new Point(0.0f, 0.0f);

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        public final float component1() {
            return this.x;
        }

        public final float component2() {
            return this.y;
        }

        @NotNull
        public final Point copy(float x, float y) {
            return new Point(x, y);
        }

        public static /* synthetic */ Point copy$default(Point point, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = point.x;
            }
            if ((n & 2) != 0) {
                f2 = point.y;
            }
            return point.copy(f, f2);
        }

        @NotNull
        public String toString() {
            return "Point(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.x);
            result = result * 31 + Float.hashCode(this.y);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Point)) {
                return false;
            }
            Point point = (Point)other;
            if (Float.compare(this.x, point.x) != 0) {
                return false;
            }
            return Float.compare(this.y, point.y) == 0;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/obscuria/fragmentum/tools/easing/CubicCurve$Point$Companion;", "", "<init>", "()V", "Ldev/obscuria/fragmentum/tools/easing/CubicCurve$Point;", "ZERO", "Ldev/obscuria/fragmentum/tools/easing/CubicCurve$Point;", "getZERO", "()Ldev/obscuria/fragmentum/tools/easing/CubicCurve$Point;", "fragmentum-fabric-1.20.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Point getZERO() {
                return ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

