/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.tools.event;

import dev.obscuria.fragmentum.tools.event.Event;
import dev.obscuria.fragmentum.tools.event.EventHandler;
import dev.obscuria.fragmentum.tools.event.EventToken;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00028\u0000H\u0086\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0006H\u0086\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010\u0012\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0086\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0004R \u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00160\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Ldev/obscuria/fragmentum/tools/event/Event;", "T", "", "<init>", "()V", "listener", "Ldev/obscuria/fragmentum/tools/event/EventToken;", "register", "(Ljava/lang/Object;)Ldev/obscuria/fragmentum/tools/event/EventToken;", "", "priority", "(ILjava/lang/Object;)Ldev/obscuria/fragmentum/tools/event/EventToken;", "token", "", "unregister", "(Ldev/obscuria/fragmentum/tools/event/EventToken;)V", "Ldev/obscuria/fragmentum/tools/event/EventHandler;", "handler", "broadcast", "(Ldev/obscuria/fragmentum/tools/event/EventHandler;)V", "sortIfDirty", "", "Ldev/obscuria/fragmentum/tools/event/Event$Registration;", "registrations", "Ljava/util/List;", "", "dirty", "Z", "Registration", "Token", "fragmentum-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Event.kt\ndev/obscuria/fragmentum/tools/event/Event\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1863#2,2:55\n*S KotlinDebug\n*F\n+ 1 Event.kt\ndev/obscuria/fragmentum/tools/event/Event\n*L\n27#1:55,2\n*E\n"})
public final class Event<T> {
    @NotNull
    private final List<Registration<T>> registrations = new ArrayList();
    private boolean dirty;

    @NotNull
    public final EventToken register(T listener) {
        return this.register(1000, listener);
    }

    @NotNull
    public final EventToken register(int priority, T listener) {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Token token = new Token(uUID, this);
        this.registrations.add(new Registration<T>(token, priority, listener));
        this.dirty = true;
        return token;
    }

    public final void unregister(@NotNull EventToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.registrations.removeIf(arg_0 -> Event.unregister$lambda$1(arg_0 -> Event.unregister$lambda$0(token, arg_0), arg_0));
    }

    public final void broadcast(@NotNull EventHandler<T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.sortIfDirty();
        Iterable $this$forEach$iv = this.registrations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Registration it = (Registration)element$iv;
            boolean bl = false;
            handler.handle(it.getListener());
        }
    }

    private final void sortIfDirty() {
        if (!this.dirty) {
            return;
        }
        CollectionsKt.sortWith(this.registrations, (arg_0, arg_1) -> Event.sortIfDirty$lambda$3(sortIfDirty.1.INSTANCE, arg_0, arg_1));
        this.dirty = false;
    }

    private static final boolean unregister$lambda$0(EventToken $token, Registration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getToken(), (Object)$token);
    }

    private static final boolean unregister$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int sortIfDirty$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u0002B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u000b\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0007\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Ldev/obscuria/fragmentum/tools/event/Event$Registration;", "T", "", "Ldev/obscuria/fragmentum/tools/event/EventToken;", "token", "", "priority", "listener", "<init>", "(Ldev/obscuria/fragmentum/tools/event/EventToken;ILjava/lang/Object;)V", "other", "compareTo", "(Ldev/obscuria/fragmentum/tools/event/Event$Registration;)I", "Ldev/obscuria/fragmentum/tools/event/EventToken;", "getToken", "()Ldev/obscuria/fragmentum/tools/event/EventToken;", "I", "getPriority", "()I", "Ljava/lang/Object;", "getListener", "()Ljava/lang/Object;", "fragmentum-fabric-1.20.1"})
    private static final class Registration<T>
    implements Comparable<Registration<T>> {
        @NotNull
        private final EventToken token;
        private final int priority;
        private final T listener;

        public Registration(@NotNull EventToken token, int priority, T listener) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.token = token;
            this.priority = priority;
            this.listener = listener;
        }

        @NotNull
        public final EventToken getToken() {
            return this.token;
        }

        public final int getPriority() {
            return this.priority;
        }

        public final T getListener() {
            return this.listener;
        }

        @Override
        public int compareTo(@NotNull Registration<T> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return Intrinsics.compare((int)this.priority, (int)other.priority);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ(\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\f\b\u0002\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\fR\u001b\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010\u000e\u00a8\u0006 "}, d2={"Ldev/obscuria/fragmentum/tools/event/Event$Token;", "Ldev/obscuria/fragmentum/tools/event/EventToken;", "Ljava/util/UUID;", "uuid", "Ldev/obscuria/fragmentum/tools/event/Event;", "event", "<init>", "(Ljava/util/UUID;Ldev/obscuria/fragmentum/tools/event/Event;)V", "", "unregister", "()V", "component1", "()Ljava/util/UUID;", "component2", "()Ldev/obscuria/fragmentum/tools/event/Event;", "copy", "(Ljava/util/UUID;Ldev/obscuria/fragmentum/tools/event/Event;)Ldev/obscuria/fragmentum/tools/event/Event$Token;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getUuid", "Ldev/obscuria/fragmentum/tools/event/Event;", "getEvent", "fragmentum-fabric-1.20.1"})
    public static final class Token
    implements EventToken {
        @NotNull
        private final UUID uuid;
        @NotNull
        private final Event<?> event;

        public Token(@NotNull UUID uuid, @NotNull Event<?> event) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter(event, (String)"event");
            this.uuid = uuid;
            this.event = event;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public final Event<?> getEvent() {
            return this.event;
        }

        @Override
        public void unregister() {
            this.event.unregister(this);
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        @NotNull
        public final Event<?> component2() {
            return this.event;
        }

        @NotNull
        public final Token copy(@NotNull UUID uuid, @NotNull Event<?> event) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter(event, (String)"event");
            return new Token(uuid, event);
        }

        public static /* synthetic */ Token copy$default(Token token, UUID uUID, Event event, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = token.uuid;
            }
            if ((n & 2) != 0) {
                event = token.event;
            }
            return token.copy(uUID, event);
        }

        @NotNull
        public String toString() {
            return "Token(uuid=" + this.uuid + ", event=" + this.event + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + this.event.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)token.uuid)) {
                return false;
            }
            return Intrinsics.areEqual(this.event, token.event);
        }
    }
}

