/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import javax.annotation.Nullable;
import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModBlocks;
import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.GentleIrradiantAnimationAttack1Procedure;
import net.mayoi.radiationzonereborn.procedures.GentleIrradiantAnimationAttack2Procedure;
import net.mayoi.radiationzonereborn.procedures.GentleIrradiantAnimationAttack5Procedure;
import net.mayoi.radiationzonereborn.procedures.GentleIrradiantAnimationHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.GentleIrradiantAnimationIdlePhase2Procedure;
import net.mayoi.radiationzonereborn.procedures.GentleIrradiantAnimationIdlePhase3Procedure;
import net.mayoi.radiationzonereborn.procedures.GentleIrradiantAnimationShieldHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.GentleIrradiantHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.GentleRadiantCanFollowProcedure;
import net.mayoi.radiationzonereborn.procedures.GentleRadiantClickProcedure;
import net.mayoi.radiationzonereborn.procedures.GentleRadiantTickProcedure;
import net.mayoi.radiationzonereborn.procedures.GentleRadiantWhenSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantRandomAttackProcedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantShieldBreakProcedure;
import net.mayoi.radiationzonereborn.procedures.IrradiantShieldHurtProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class GentleIrradiantEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Pathfinding = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_shield_hurt_tick = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hurt_tick = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_shield_health = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_shield_number = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_type = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_recover_shield_CD = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_hurt = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_in_shield_hurt = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_shield_hurt_cd = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_particle = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_rush_CD = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_spawn_number = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_spawn_CD = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_speed = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_recover = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_state = SynchedEntityData.defineId(GentleIrradiantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();

    public GentleIrradiantEntity(EntityType<GentleIrradiantEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_Pathfinding, (Object)false);
        builder.define(DATA_shield_hurt_tick, (Object)0);
        builder.define(DATA_hurt_tick, (Object)0);
        builder.define(DATA_shield_health, (Object)0);
        builder.define(DATA_shield_number, (Object)0);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_attack_type, (Object)0);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_recover_shield_CD, (Object)300);
        builder.define(DATA_in_hurt, (Object)false);
        builder.define(DATA_in_shield_hurt, (Object)false);
        builder.define(DATA_shield_hurt_cd, (Object)0);
        builder.define(DATA_particle, (Object)0);
        builder.define(DATA_rush_CD, (Object)100);
        builder.define(DATA_spawn_number, (Object)0);
        builder.define(DATA_spawn_CD, (Object)0);
        builder.define(DATA_speed, (Object)0);
        builder.define(DATA_recover, (Object)0);
        builder.define(DATA_state, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = GentleIrradiantEntity.this.getX();
                double y = GentleIrradiantEntity.this.getY();
                double z = GentleIrradiantEntity.this.getZ();
                GentleIrradiantEntity entity = GentleIrradiantEntity.this;
                Level world = GentleIrradiantEntity.this.level();
                return super.canUse() && GentleRadiantCanFollowProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GentleIrradiantEntity.this.getX();
                double y = GentleIrradiantEntity.this.getY();
                double z = GentleIrradiantEntity.this.getZ();
                GentleIrradiantEntity entity = GentleIrradiantEntity.this;
                Level world = GentleIrradiantEntity.this.level();
                return super.canContinueToUse() && GentleRadiantCanFollowProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = GentleIrradiantEntity.this.getX();
                double y = GentleIrradiantEntity.this.getY();
                double z = GentleIrradiantEntity.this.getZ();
                GentleIrradiantEntity entity = GentleIrradiantEntity.this;
                Level world = GentleIrradiantEntity.this.level();
                return super.canUse() && IrradiantRandomAttackProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GentleIrradiantEntity.this.getX();
                double y = GentleIrradiantEntity.this.getY();
                double z = GentleIrradiantEntity.this.getZ();
                GentleIrradiantEntity entity = GentleIrradiantEntity.this;
                Level world = GentleIrradiantEntity.this.level();
                return super.canContinueToUse() && IrradiantRandomAttackProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.amethyst_block.place"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.amethyst_block.hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.amethyst_block.break"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        GentleIrradiantEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        Entity direct = damagesource.getDirectEntity();
        if (direct instanceof Projectile && (Integer)this.entityData.get(DATA_shield_number) > 0) {
            if (!((Boolean)this.entityData.get(DATA_in_shield_hurt)).booleanValue()) {
                this.entityData.set(DATA_in_shield_hurt, (Object)true);
            }
            IrradiantShieldHurtProcedure.execute((LevelAccessor)world, x, y, z);
            return false;
        }
        if ((Integer)this.entityData.get(DATA_attack_type) == 4 && ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue() && !damagesource.is(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"minecraft:bypasses_shield")))) {
            IrradiantShieldHurtProcedure.execute((LevelAccessor)world, x, y, z);
            return false;
        }
        GentleIrradiantHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, immediatesourceentity);
        if (!world.isClientSide()) {
            LivingEntity livingAttacker;
            ItemStack weapon;
            Entity attacker = damagesource.getEntity();
            if ((Integer)this.entityData.get(DATA_attack_type) == 4 && ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue()) {
                amount *= 0.5f;
            }
            amount = attacker instanceof LivingEntity ? ((weapon = (livingAttacker = (LivingEntity)attacker).getMainHandItem()).getItem() instanceof PickaxeItem ? (amount *= 1.5f) : (amount *= 0.75f)) : (amount *= 0.75f);
            amount = Math.max(0.0f, amount);
            ItemStack weapon2 = null;
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker2 = (LivingEntity)attacker;
                weapon2 = livingAttacker2.getMainHandItem();
            }
            if (damagesource.is(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"minecraft:bypasses_shield")))) {
                return super.hurt(damagesource, amount);
            }
            if ((Integer)this.entityData.get(DATA_shield_hurt_cd) > 0 && !damagesource.is(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"minecraft:bypasses_cooldown"))) && (Integer)this.entityData.get(DATA_shield_number) > 0) {
                return false;
            }
            if ((Integer)this.entityData.get(DATA_shield_hurt_cd) > 0 && !damagesource.is(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"minecraft:bypasses_cooldown")))) {
                return false;
            }
            if ((Integer)this.entityData.get(DATA_shield_number) > 0) {
                this.entityData.set(DATA_shield_health, (Object)((Integer)this.entityData.get(DATA_shield_health) - (int)amount));
                if (weapon2 != null && (weapon2.getItem() instanceof PickaxeItem || (Integer)this.entityData.get(DATA_shield_health) <= 0)) {
                    LivingEntity _livingEntity6;
                    this.entityData.set(DATA_shield_number, (Object)((Integer)this.entityData.get(DATA_shield_number) - 1));
                    IrradiantShieldBreakProcedure.execute((LevelAccessor)world, x, y, z, immediatesourceentity);
                    this.entityData.set(DATA_shield_health, (Object)((int)((double)Math.round(entity instanceof LivingEntity && (_livingEntity6 = (LivingEntity)entity).getAttributes().hasAttribute(Attributes.MAX_HEALTH) ? _livingEntity6.getAttribute(Attributes.MAX_HEALTH).getValue() : 0.0) * 0.4)));
                } else {
                    if (!((Boolean)this.entityData.get(DATA_in_shield_hurt)).booleanValue()) {
                        this.entityData.set(DATA_in_shield_hurt, (Object)true);
                    }
                    IrradiantShieldHurtProcedure.execute((LevelAccessor)world, x, y, z);
                }
                this.entityData.set(DATA_shield_hurt_cd, (Object)10);
                return false;
            }
            return super.hurt(damagesource, amount);
        }
        return super.hurt(damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        GentleRadiantWhenSpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putBoolean("DataPathfinding", ((Boolean)this.entityData.get(DATA_Pathfinding)).booleanValue());
        compound.putInt("Datashield_hurt_tick", ((Integer)this.entityData.get(DATA_shield_hurt_tick)).intValue());
        compound.putInt("Datahurt_tick", ((Integer)this.entityData.get(DATA_hurt_tick)).intValue());
        compound.putInt("Datashield_health", ((Integer)this.entityData.get(DATA_shield_health)).intValue());
        compound.putInt("Datashield_number", ((Integer)this.entityData.get(DATA_shield_number)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Dataattack_type", ((Integer)this.entityData.get(DATA_attack_type)).intValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putInt("Datarecover_shield_CD", ((Integer)this.entityData.get(DATA_recover_shield_CD)).intValue());
        compound.putBoolean("Datain_hurt", ((Boolean)this.entityData.get(DATA_in_hurt)).booleanValue());
        compound.putBoolean("Datain_shield_hurt", ((Boolean)this.entityData.get(DATA_in_shield_hurt)).booleanValue());
        compound.putInt("Datashield_hurt_cd", ((Integer)this.entityData.get(DATA_shield_hurt_cd)).intValue());
        compound.putInt("Dataparticle", ((Integer)this.entityData.get(DATA_particle)).intValue());
        compound.putInt("Datarush_CD", ((Integer)this.entityData.get(DATA_rush_CD)).intValue());
        compound.putInt("Dataspawn_number", ((Integer)this.entityData.get(DATA_spawn_number)).intValue());
        compound.putInt("Dataspawn_CD", ((Integer)this.entityData.get(DATA_spawn_CD)).intValue());
        compound.putInt("Dataspeed", ((Integer)this.entityData.get(DATA_speed)).intValue());
        compound.putInt("Datarecover", ((Integer)this.entityData.get(DATA_recover)).intValue());
        compound.putInt("Datastate", ((Integer)this.entityData.get(DATA_state)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("DataPathfinding")) {
            this.entityData.set(DATA_Pathfinding, (Object)compound.getBoolean("DataPathfinding"));
        }
        if (compound.contains("Datashield_hurt_tick")) {
            this.entityData.set(DATA_shield_hurt_tick, (Object)compound.getInt("Datashield_hurt_tick"));
        }
        if (compound.contains("Datahurt_tick")) {
            this.entityData.set(DATA_hurt_tick, (Object)compound.getInt("Datahurt_tick"));
        }
        if (compound.contains("Datashield_health")) {
            this.entityData.set(DATA_shield_health, (Object)compound.getInt("Datashield_health"));
        }
        if (compound.contains("Datashield_number")) {
            this.entityData.set(DATA_shield_number, (Object)compound.getInt("Datashield_number"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Dataattack_type")) {
            this.entityData.set(DATA_attack_type, (Object)compound.getInt("Dataattack_type"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datarecover_shield_CD")) {
            this.entityData.set(DATA_recover_shield_CD, (Object)compound.getInt("Datarecover_shield_CD"));
        }
        if (compound.contains("Datain_hurt")) {
            this.entityData.set(DATA_in_hurt, (Object)compound.getBoolean("Datain_hurt"));
        }
        if (compound.contains("Datain_shield_hurt")) {
            this.entityData.set(DATA_in_shield_hurt, (Object)compound.getBoolean("Datain_shield_hurt"));
        }
        if (compound.contains("Datashield_hurt_cd")) {
            this.entityData.set(DATA_shield_hurt_cd, (Object)compound.getInt("Datashield_hurt_cd"));
        }
        if (compound.contains("Dataparticle")) {
            this.entityData.set(DATA_particle, (Object)compound.getInt("Dataparticle"));
        }
        if (compound.contains("Datarush_CD")) {
            this.entityData.set(DATA_rush_CD, (Object)compound.getInt("Datarush_CD"));
        }
        if (compound.contains("Dataspawn_number")) {
            this.entityData.set(DATA_spawn_number, (Object)compound.getInt("Dataspawn_number"));
        }
        if (compound.contains("Dataspawn_CD")) {
            this.entityData.set(DATA_spawn_CD, (Object)compound.getInt("Dataspawn_CD"));
        }
        if (compound.contains("Dataspeed")) {
            this.entityData.set(DATA_speed, (Object)compound.getInt("Dataspeed"));
        }
        if (compound.contains("Datarecover")) {
            this.entityData.set(DATA_recover, (Object)compound.getInt("Datarecover"));
        }
        if (compound.contains("Datastate")) {
            this.entityData.set(DATA_state, (Object)compound.getInt("Datastate"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        GentleIrradiantEntity entity = this;
        Level world = this.level();
        return GentleRadiantClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity, itemstack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(GentleIrradiantAnimationIdlePhase2Procedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(GentleIrradiantAnimationIdlePhase3Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(GentleIrradiantAnimationAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(GentleIrradiantAnimationAttack2Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(GentleIrradiantAnimationAttack5Procedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(GentleIrradiantAnimationShieldHurtProcedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(GentleIrradiantAnimationHurtProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        GentleRadiantTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        GentleIrradiantEntity retval = (GentleIrradiantEntity)((EntityType)RadiationZoneRebornModEntities.GENTLE_IRRADIANT.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RadiationZoneRebornModBlocks.RADIANCE_CRYSTAL.get())}).test(stack);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.1f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.26);
        builder = builder.add(Attributes.MAX_HEALTH, 100.0);
        builder = builder.add(Attributes.ARMOR, 4.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        return builder;
    }
}

