/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModItems;
import net.mayoi.radiationzonereborn.procedures.GiantRatAnimationAttack1Procedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatAnimationIdleRandomProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatAnimationJump2Procedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatAnimationJump3Procedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatAnimationJumpProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatCanWalkProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatFollowProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatRightClickProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatSitProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.GiantRatTick2Procedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class GiantRatEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_idle_tick = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_idle = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_type = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_walk_speed = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_run = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_jump_x = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_jump_z = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_has_tooth = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_tooth_number = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_state = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_has_target2 = SynchedEntityData.defineId(GiantRatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();

    public GiantRatEntity(EntityType<GiantRatEntity> type, Level world) {
        super(type, world);
        this.xpReward = 4;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_idle_tick, (Object)0);
        builder.define(DATA_in_idle, (Object)false);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_attack_type, (Object)0);
        builder.define(DATA_walk_speed, (Object)0);
        builder.define(DATA_in_run, (Object)false);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_jump_x, (Object)0);
        builder.define(DATA_jump_z, (Object)0);
        builder.define(DATA_has_tooth, (Object)true);
        builder.define(DATA_tooth_number, (Object)2);
        builder.define(DATA_state, (Object)1);
        builder.define(DATA_has_target2, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = GiantRatEntity.this.getX();
                double y = GiantRatEntity.this.getY();
                double z = GiantRatEntity.this.getZ();
                GiantRatEntity entity = GiantRatEntity.this;
                Level world = GiantRatEntity.this.level();
                return super.canUse() && GiantRatFollowProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GiantRatEntity.this.getX();
                double y = GiantRatEntity.this.getY();
                double z = GiantRatEntity.this.getZ();
                GiantRatEntity entity = GiantRatEntity.this;
                Level world = GiantRatEntity.this.level();
                return super.canContinueToUse() && GiantRatFollowProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Chicken.class, false, false));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = GiantRatEntity.this.getX();
                double y = GiantRatEntity.this.getY();
                double z = GiantRatEntity.this.getZ();
                GiantRatEntity entity = GiantRatEntity.this;
                Level world = GiantRatEntity.this.level();
                return super.canUse() && GiantRatCanWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GiantRatEntity.this.getX();
                double y = GiantRatEntity.this.getY();
                double z = GiantRatEntity.this.getZ();
                GiantRatEntity entity = GiantRatEntity.this;
                Level world = GiantRatEntity.this.level();
                return super.canContinueToUse() && GiantRatCanWalkProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.bat.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.bat.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.bat.death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataidle_tick", ((Integer)this.entityData.get(DATA_idle_tick)).intValue());
        compound.putBoolean("Datain_idle", ((Boolean)this.entityData.get(DATA_in_idle)).booleanValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putInt("Dataattack_type", ((Integer)this.entityData.get(DATA_attack_type)).intValue());
        compound.putInt("Datawalk_speed", ((Integer)this.entityData.get(DATA_walk_speed)).intValue());
        compound.putBoolean("Datain_run", ((Boolean)this.entityData.get(DATA_in_run)).booleanValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putInt("Datajump_x", ((Integer)this.entityData.get(DATA_jump_x)).intValue());
        compound.putInt("Datajump_z", ((Integer)this.entityData.get(DATA_jump_z)).intValue());
        compound.putBoolean("Datahas_tooth", ((Boolean)this.entityData.get(DATA_has_tooth)).booleanValue());
        compound.putInt("Datatooth_number", ((Integer)this.entityData.get(DATA_tooth_number)).intValue());
        compound.putInt("Datastate", ((Integer)this.entityData.get(DATA_state)).intValue());
        compound.putInt("Datahas_target2", ((Integer)this.entityData.get(DATA_has_target2)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataidle_tick")) {
            this.entityData.set(DATA_idle_tick, (Object)compound.getInt("Dataidle_tick"));
        }
        if (compound.contains("Datain_idle")) {
            this.entityData.set(DATA_in_idle, (Object)compound.getBoolean("Datain_idle"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Dataattack_type")) {
            this.entityData.set(DATA_attack_type, (Object)compound.getInt("Dataattack_type"));
        }
        if (compound.contains("Datawalk_speed")) {
            this.entityData.set(DATA_walk_speed, (Object)compound.getInt("Datawalk_speed"));
        }
        if (compound.contains("Datain_run")) {
            this.entityData.set(DATA_in_run, (Object)compound.getBoolean("Datain_run"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("Datajump_x")) {
            this.entityData.set(DATA_jump_x, (Object)compound.getInt("Datajump_x"));
        }
        if (compound.contains("Datajump_z")) {
            this.entityData.set(DATA_jump_z, (Object)compound.getInt("Datajump_z"));
        }
        if (compound.contains("Datahas_tooth")) {
            this.entityData.set(DATA_has_tooth, (Object)compound.getBoolean("Datahas_tooth"));
        }
        if (compound.contains("Datatooth_number")) {
            this.entityData.set(DATA_tooth_number, (Object)compound.getInt("Datatooth_number"));
        }
        if (compound.contains("Datastate")) {
            this.entityData.set(DATA_state, (Object)compound.getInt("Datastate"));
        }
        if (compound.contains("Datahas_target2")) {
            this.entityData.set(DATA_has_target2, (Object)compound.getInt("Datahas_target2"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        GiantRatEntity entity = this;
        Level world = this.level();
        return GiantRatRightClickProcedure.execute((Entity)entity, (Entity)sourceentity);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState2.animateWhen(GiantRatAnimationIdleRandomProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(GiantRatAnimationAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(GiantRatAnimationJumpProcedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(GiantRatAnimationJump2Procedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(GiantRatAnimationJump3Procedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(GiantRatSitProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        GiantRatTick2Procedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        GiantRatEntity retval = (GiantRatEntity)((EntityType)RadiationZoneRebornModEntities.GIANT_RAT.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RadiationZoneRebornModItems.SEWAGE_CHEESE.get())}).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RadiationZoneRebornModEntities.GIANT_RAT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return GiantRatSpawnProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 30.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 5.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

