/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.init.RadiationZoneRebornModEntities;
import net.mayoi.radiationzonereborn.procedures.GreaterDustormAnimationAttack1Procedure;
import net.mayoi.radiationzonereborn.procedures.GreaterDustormAnimationAttack2Procedure;
import net.mayoi.radiationzonereborn.procedures.GreaterDustormAnimationAttack3Procedure;
import net.mayoi.radiationzonereborn.procedures.GreaterDustormAnimationRushProcedure;
import net.mayoi.radiationzonereborn.procedures.GreaterDustormSpawnProcedure;
import net.mayoi.radiationzonereborn.procedures.GreaterDustormTickProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class GreaterDustormEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(GreaterDustormEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_type = SynchedEntityData.defineId(GreaterDustormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(GreaterDustormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_cd = SynchedEntityData.defineId(GreaterDustormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_sand = SynchedEntityData.defineId(GreaterDustormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();

    public GreaterDustormEntity(EntityType<GreaterDustormEntity> type, Level world) {
        super(type, world);
        this.xpReward = 12;
        this.setNoAi(false);
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_attack_type, (Object)0);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_attack_cd, (Object)0);
        builder.define(DATA_sand, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.breeze.idle_ground"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.breeze.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.breeze.death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Dataattack_type", ((Integer)this.entityData.get(DATA_attack_type)).intValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putInt("Dataattack_cd", ((Integer)this.entityData.get(DATA_attack_cd)).intValue());
        compound.putInt("Datasand", ((Integer)this.entityData.get(DATA_sand)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Dataattack_type")) {
            this.entityData.set(DATA_attack_type, (Object)compound.getInt("Dataattack_type"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Dataattack_cd")) {
            this.entityData.set(DATA_attack_cd, (Object)compound.getInt("Dataattack_cd"));
        }
        if (compound.contains("Datasand")) {
            this.entityData.set(DATA_sand, (Object)compound.getInt("Datasand"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState2.animateWhen(GreaterDustormAnimationAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(GreaterDustormAnimationAttack2Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(GreaterDustormAnimationAttack3Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(GreaterDustormAnimationRushProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        GreaterDustormTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.2f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)RadiationZoneRebornModEntities.GREATER_DUSTORM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return GreaterDustormSpawnProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 90.0);
        builder = builder.add(Attributes.ARMOR, 4.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 22.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.1);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 2.0);
        return builder;
    }
}

