/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import javax.annotation.Nullable;
import net.mayoi.radiationzonereborn.procedures.MinotaurSkeletonAnimationAttackProcedure;
import net.mayoi.radiationzonereborn.procedures.MinotaurSkeletonIsntMadProcedure;
import net.mayoi.radiationzonereborn.procedures.MinotaurSkeletonRandomWalkProcedure;
import net.mayoi.radiationzonereborn.procedures.MinotaurSkeletonTextureEyeProcedure;
import net.mayoi.radiationzonereborn.procedures.MinotaurSkeletonTickProcedure;
import net.mayoi.radiationzonereborn.procedures.MinotaurSkeletonWhenSpawnProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class MinotaurSkeletonEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(MinotaurSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(MinotaurSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(MinotaurSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Pathfinding = SynchedEntityData.defineId(MinotaurSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_is_mad = SynchedEntityData.defineId(MinotaurSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();

    public MinotaurSkeletonEntity(EntityType<MinotaurSkeletonEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_Pathfinding, (Object)false);
        builder.define(DATA_is_mad, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = MinotaurSkeletonEntity.this.getX();
                double y = MinotaurSkeletonEntity.this.getY();
                double z = MinotaurSkeletonEntity.this.getZ();
                MinotaurSkeletonEntity entity = MinotaurSkeletonEntity.this;
                Level world = MinotaurSkeletonEntity.this.level();
                return super.canUse() && MinotaurSkeletonTextureEyeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = MinotaurSkeletonEntity.this.getX();
                double y = MinotaurSkeletonEntity.this.getY();
                double z = MinotaurSkeletonEntity.this.getZ();
                MinotaurSkeletonEntity entity = MinotaurSkeletonEntity.this;
                Level world = MinotaurSkeletonEntity.this.level();
                return super.canContinueToUse() && MinotaurSkeletonTextureEyeProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, false, false){

            public boolean canUse() {
                double x = MinotaurSkeletonEntity.this.getX();
                double y = MinotaurSkeletonEntity.this.getY();
                double z = MinotaurSkeletonEntity.this.getZ();
                MinotaurSkeletonEntity entity = MinotaurSkeletonEntity.this;
                Level world = MinotaurSkeletonEntity.this.level();
                return super.canUse() && MinotaurSkeletonTextureEyeProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = MinotaurSkeletonEntity.this.getX();
                double y = MinotaurSkeletonEntity.this.getY();
                double z = MinotaurSkeletonEntity.this.getZ();
                MinotaurSkeletonEntity entity = MinotaurSkeletonEntity.this;
                Level world = MinotaurSkeletonEntity.this.level();
                return super.canContinueToUse() && MinotaurSkeletonTextureEyeProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal<Wolf>((PathfinderMob)this, Wolf.class, 6.0f, 1.2, 1.2){

            public boolean canUse() {
                double x = MinotaurSkeletonEntity.this.getX();
                double y = MinotaurSkeletonEntity.this.getY();
                double z = MinotaurSkeletonEntity.this.getZ();
                MinotaurSkeletonEntity entity = MinotaurSkeletonEntity.this;
                Level world = MinotaurSkeletonEntity.this.level();
                return super.canUse() && MinotaurSkeletonIsntMadProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = MinotaurSkeletonEntity.this.getX();
                double y = MinotaurSkeletonEntity.this.getY();
                double z = MinotaurSkeletonEntity.this.getZ();
                MinotaurSkeletonEntity entity = MinotaurSkeletonEntity.this;
                Level world = MinotaurSkeletonEntity.this.level();
                return super.canContinueToUse() && MinotaurSkeletonIsntMadProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = MinotaurSkeletonEntity.this.getX();
                double y = MinotaurSkeletonEntity.this.getY();
                double z = MinotaurSkeletonEntity.this.getZ();
                MinotaurSkeletonEntity entity = MinotaurSkeletonEntity.this;
                Level world = MinotaurSkeletonEntity.this.level();
                return super.canUse() && MinotaurSkeletonRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = MinotaurSkeletonEntity.this.getX();
                double y = MinotaurSkeletonEntity.this.getY();
                double z = MinotaurSkeletonEntity.this.getZ();
                MinotaurSkeletonEntity entity = MinotaurSkeletonEntity.this;
                Level world = MinotaurSkeletonEntity.this.level();
                return super.canContinueToUse() && MinotaurSkeletonRandomWalkProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = MinotaurSkeletonEntity.this.getX();
                double y = MinotaurSkeletonEntity.this.getY();
                double z = MinotaurSkeletonEntity.this.getZ();
                MinotaurSkeletonEntity entity = MinotaurSkeletonEntity.this;
                Level world = MinotaurSkeletonEntity.this.level();
                return super.canUse() && MinotaurSkeletonRandomWalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = MinotaurSkeletonEntity.this.getX();
                double y = MinotaurSkeletonEntity.this.getY();
                double z = MinotaurSkeletonEntity.this.getZ();
                MinotaurSkeletonEntity entity = MinotaurSkeletonEntity.this;
                Level world = MinotaurSkeletonEntity.this.level();
                return super.canContinueToUse() && MinotaurSkeletonRandomWalkProcedure.execute((Entity)entity);
            }
        });
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wither_skeleton.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wither_skeleton.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wither_skeleton.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wither_skeleton.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        MinotaurSkeletonWhenSpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putBoolean("DataPathfinding", ((Boolean)this.entityData.get(DATA_Pathfinding)).booleanValue());
        compound.putBoolean("Datais_mad", ((Boolean)this.entityData.get(DATA_is_mad)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("DataPathfinding")) {
            this.entityData.set(DATA_Pathfinding, (Object)compound.getBoolean("DataPathfinding"));
        }
        if (compound.contains("Datais_mad")) {
            this.entityData.set(DATA_is_mad, (Object)compound.getBoolean("Datais_mad"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(MinotaurSkeletonAnimationAttackProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(true, this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        MinotaurSkeletonTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 22.0);
        builder = builder.add(Attributes.ARMOR, 1.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 7.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

