/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.procedures.SandstoneWitherAnimationAttack1Procedure;
import net.mayoi.radiationzonereborn.procedures.SandstoneWitherAnimationAttack2Procedure;
import net.mayoi.radiationzonereborn.procedures.SandstoneWitherAnimationAttack31Procedure;
import net.mayoi.radiationzonereborn.procedures.SandstoneWitherAnimationAttack3Procedure;
import net.mayoi.radiationzonereborn.procedures.SandstoneWitherAnimationAttack4Procedure;
import net.mayoi.radiationzonereborn.procedures.SandstoneWitherAnimationAttack5Procedure;
import net.mayoi.radiationzonereborn.procedures.SandstoneWitherAnimationDeathProcedure;
import net.mayoi.radiationzonereborn.procedures.SandstoneWitherTickProcedure;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class SandstoneWitherEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_attack_tick_mainhead = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack_mainhead = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_tick_lefthead = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack_lefthead = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_tick_righthead = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack_righthead = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_attack_eye_cd = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick_eye = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack_eye = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_rush_cd = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_rush_type = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick_rush = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack_rush = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_spawn_tick = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_spawn = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_death_tick = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_death = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_break_block = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_can_break = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_will_rush = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_recover = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hurt_break = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_has_hurt_break = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_in_phase3 = SynchedEntityData.defineId(SandstoneWitherEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();
    public final AnimationState animationState9 = new AnimationState();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);

    public SandstoneWitherEntity(EntityType<SandstoneWitherEntity> type, Level world) {
        super(type, world);
        this.xpReward = 100;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_attack_tick_mainhead, (Object)0);
        builder.define(DATA_in_attack_mainhead, (Object)false);
        builder.define(DATA_attack_tick_lefthead, (Object)0);
        builder.define(DATA_in_attack_lefthead, (Object)false);
        builder.define(DATA_attack_tick_righthead, (Object)0);
        builder.define(DATA_in_attack_righthead, (Object)false);
        builder.define(DATA_attack_eye_cd, (Object)0);
        builder.define(DATA_attack_tick_eye, (Object)0);
        builder.define(DATA_in_attack_eye, (Object)false);
        builder.define(DATA_rush_cd, (Object)0);
        builder.define(DATA_rush_type, (Object)0);
        builder.define(DATA_attack_tick_rush, (Object)0);
        builder.define(DATA_in_attack_rush, (Object)false);
        builder.define(DATA_spawn_tick, (Object)0);
        builder.define(DATA_in_spawn, (Object)false);
        builder.define(DATA_death_tick, (Object)0);
        builder.define(DATA_in_death, (Object)false);
        builder.define(DATA_break_block, (Object)0);
        builder.define(DATA_can_break, (Object)0);
        builder.define(DATA_will_rush, (Object)false);
        builder.define(DATA_recover, (Object)0);
        builder.define(DATA_hurt_break, (Object)0);
        builder.define(DATA_has_hurt_break, (Object)false);
        builder.define(DATA_in_phase3, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wither.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wither.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wither.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        SandstoneWitherEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        if (damagesource.is(DamageTypes.DROWN) || damagesource.is(DamageTypes.FALL) || damagesource.is(DamageTypes.IN_FIRE) || damagesource.is(DamageTypes.ON_FIRE)) {
            return false;
        }
        if (((Boolean)this.entityData.get(DATA_in_death)).booleanValue() || ((Boolean)this.entityData.get(DATA_in_spawn)).booleanValue()) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (!world.isClientSide()) {
            ItemStack weapon;
            Entity attacker = damagesource.getEntity();
            amount = immediatesourceentity instanceof Mob || immediatesourceentity instanceof Player ? ((weapon = ((LivingEntity)immediatesourceentity).getMainHandItem()).getItem() instanceof PickaxeItem ? (amount *= 1.5f) : (this.getHealth() <= this.getMaxHealth() / 2.0f ? (amount *= 0.4f) : (amount *= 0.75f))) : (amount *= 0.75f);
            if (((Boolean)this.entityData.get(DATA_in_phase3)).booleanValue()) {
                amount *= 0.5f;
            }
            amount = Math.max(0.0f, amount);
            if (this.getHealth() - amount <= 0.0f) {
                this.entityData.set(DATA_in_death, (Object)true);
                this.setHealth(1.1f);
                amount = 0.1f;
                if (sourceentity instanceof ServerPlayer) {
                    AdvancementProgress _ap;
                    ServerPlayer _player = (ServerPlayer)sourceentity;
                    AdvancementHolder _adv = _player.server.getAdvancements().get(ResourceLocation.parse((String)"radiation_zone_reborn:kill_sandstone_wither"));
                    if (_adv != null && !(_ap = _player.getAdvancements().getOrStartProgress(_adv)).isDone()) {
                        for (String criteria : _ap.getRemainingCriteria()) {
                            _player.getAdvancements().award(_adv, criteria);
                        }
                    }
                }
                return super.hurt(damagesource, amount);
            }
            return super.hurt(damagesource, amount);
        }
        return super.hurt(damagesource, amount);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataattack_tick_mainhead", ((Integer)this.entityData.get(DATA_attack_tick_mainhead)).intValue());
        compound.putBoolean("Datain_attack_mainhead", ((Boolean)this.entityData.get(DATA_in_attack_mainhead)).booleanValue());
        compound.putInt("Dataattack_tick_lefthead", ((Integer)this.entityData.get(DATA_attack_tick_lefthead)).intValue());
        compound.putBoolean("Datain_attack_lefthead", ((Boolean)this.entityData.get(DATA_in_attack_lefthead)).booleanValue());
        compound.putInt("Dataattack_tick_righthead", ((Integer)this.entityData.get(DATA_attack_tick_righthead)).intValue());
        compound.putBoolean("Datain_attack_righthead", ((Boolean)this.entityData.get(DATA_in_attack_righthead)).booleanValue());
        compound.putInt("Dataattack_eye_cd", ((Integer)this.entityData.get(DATA_attack_eye_cd)).intValue());
        compound.putInt("Dataattack_tick_eye", ((Integer)this.entityData.get(DATA_attack_tick_eye)).intValue());
        compound.putBoolean("Datain_attack_eye", ((Boolean)this.entityData.get(DATA_in_attack_eye)).booleanValue());
        compound.putInt("Datarush_cd", ((Integer)this.entityData.get(DATA_rush_cd)).intValue());
        compound.putInt("Datarush_type", ((Integer)this.entityData.get(DATA_rush_type)).intValue());
        compound.putInt("Dataattack_tick_rush", ((Integer)this.entityData.get(DATA_attack_tick_rush)).intValue());
        compound.putBoolean("Datain_attack_rush", ((Boolean)this.entityData.get(DATA_in_attack_rush)).booleanValue());
        compound.putInt("Dataspawn_tick", ((Integer)this.entityData.get(DATA_spawn_tick)).intValue());
        compound.putBoolean("Datain_spawn", ((Boolean)this.entityData.get(DATA_in_spawn)).booleanValue());
        compound.putInt("Datadeath_tick", ((Integer)this.entityData.get(DATA_death_tick)).intValue());
        compound.putBoolean("Datain_death", ((Boolean)this.entityData.get(DATA_in_death)).booleanValue());
        compound.putInt("Databreak_block", ((Integer)this.entityData.get(DATA_break_block)).intValue());
        compound.putInt("Datacan_break", ((Integer)this.entityData.get(DATA_can_break)).intValue());
        compound.putBoolean("Datawill_rush", ((Boolean)this.entityData.get(DATA_will_rush)).booleanValue());
        compound.putInt("Datarecover", ((Integer)this.entityData.get(DATA_recover)).intValue());
        compound.putInt("Datahurt_break", ((Integer)this.entityData.get(DATA_hurt_break)).intValue());
        compound.putBoolean("Datahas_hurt_break", ((Boolean)this.entityData.get(DATA_has_hurt_break)).booleanValue());
        compound.putBoolean("Datain_phase3", ((Boolean)this.entityData.get(DATA_in_phase3)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataattack_tick_mainhead")) {
            this.entityData.set(DATA_attack_tick_mainhead, (Object)compound.getInt("Dataattack_tick_mainhead"));
        }
        if (compound.contains("Datain_attack_mainhead")) {
            this.entityData.set(DATA_in_attack_mainhead, (Object)compound.getBoolean("Datain_attack_mainhead"));
        }
        if (compound.contains("Dataattack_tick_lefthead")) {
            this.entityData.set(DATA_attack_tick_lefthead, (Object)compound.getInt("Dataattack_tick_lefthead"));
        }
        if (compound.contains("Datain_attack_lefthead")) {
            this.entityData.set(DATA_in_attack_lefthead, (Object)compound.getBoolean("Datain_attack_lefthead"));
        }
        if (compound.contains("Dataattack_tick_righthead")) {
            this.entityData.set(DATA_attack_tick_righthead, (Object)compound.getInt("Dataattack_tick_righthead"));
        }
        if (compound.contains("Datain_attack_righthead")) {
            this.entityData.set(DATA_in_attack_righthead, (Object)compound.getBoolean("Datain_attack_righthead"));
        }
        if (compound.contains("Dataattack_eye_cd")) {
            this.entityData.set(DATA_attack_eye_cd, (Object)compound.getInt("Dataattack_eye_cd"));
        }
        if (compound.contains("Dataattack_tick_eye")) {
            this.entityData.set(DATA_attack_tick_eye, (Object)compound.getInt("Dataattack_tick_eye"));
        }
        if (compound.contains("Datain_attack_eye")) {
            this.entityData.set(DATA_in_attack_eye, (Object)compound.getBoolean("Datain_attack_eye"));
        }
        if (compound.contains("Datarush_cd")) {
            this.entityData.set(DATA_rush_cd, (Object)compound.getInt("Datarush_cd"));
        }
        if (compound.contains("Datarush_type")) {
            this.entityData.set(DATA_rush_type, (Object)compound.getInt("Datarush_type"));
        }
        if (compound.contains("Dataattack_tick_rush")) {
            this.entityData.set(DATA_attack_tick_rush, (Object)compound.getInt("Dataattack_tick_rush"));
        }
        if (compound.contains("Datain_attack_rush")) {
            this.entityData.set(DATA_in_attack_rush, (Object)compound.getBoolean("Datain_attack_rush"));
        }
        if (compound.contains("Dataspawn_tick")) {
            this.entityData.set(DATA_spawn_tick, (Object)compound.getInt("Dataspawn_tick"));
        }
        if (compound.contains("Datain_spawn")) {
            this.entityData.set(DATA_in_spawn, (Object)compound.getBoolean("Datain_spawn"));
        }
        if (compound.contains("Datadeath_tick")) {
            this.entityData.set(DATA_death_tick, (Object)compound.getInt("Datadeath_tick"));
        }
        if (compound.contains("Datain_death")) {
            this.entityData.set(DATA_in_death, (Object)compound.getBoolean("Datain_death"));
        }
        if (compound.contains("Databreak_block")) {
            this.entityData.set(DATA_break_block, (Object)compound.getInt("Databreak_block"));
        }
        if (compound.contains("Datacan_break")) {
            this.entityData.set(DATA_can_break, (Object)compound.getInt("Datacan_break"));
        }
        if (compound.contains("Datawill_rush")) {
            this.entityData.set(DATA_will_rush, (Object)compound.getBoolean("Datawill_rush"));
        }
        if (compound.contains("Datarecover")) {
            this.entityData.set(DATA_recover, (Object)compound.getInt("Datarecover"));
        }
        if (compound.contains("Datahurt_break")) {
            this.entityData.set(DATA_hurt_break, (Object)compound.getInt("Datahurt_break"));
        }
        if (compound.contains("Datahas_hurt_break")) {
            this.entityData.set(DATA_has_hurt_break, (Object)compound.getBoolean("Datahas_hurt_break"));
        }
        if (compound.contains("Datain_phase3")) {
            this.entityData.set(DATA_in_phase3, (Object)compound.getBoolean("Datain_phase3"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(true, this.tickCount);
            this.animationState3.animateWhen(SandstoneWitherAnimationDeathProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(SandstoneWitherAnimationAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(SandstoneWitherAnimationAttack2Procedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(SandstoneWitherAnimationAttack3Procedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(SandstoneWitherAnimationAttack4Procedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(SandstoneWitherAnimationAttack5Procedure.execute((Entity)this), this.tickCount);
            this.animationState9.animateWhen(SandstoneWitherAnimationAttack31Procedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        SandstoneWitherTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.2f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 320.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 16.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 40.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.1);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        return builder;
    }
}

