/*
 * Decompiled with CFR 0.152.
 */
package net.mayoi.radiationzonereborn.entity;

import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationAttack11Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationAttack1Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationAttack2Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationAttack3Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationAttack4Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationGetupProcedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationJump2Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationJump3Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationJump4Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationJumpProcedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationPhase22Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationPhase2Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationPhase3Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationRandomwalkProcedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationRush1Procedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationRushProcedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationShootSkyProcedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationSleepEndProcedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantAnimationSleepProcedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantCanGetEnemyProcedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantHurtProcedure;
import net.mayoi.radiationzonereborn.procedures.WastelandsTyrantTickProcedure;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class WastelandsTyrantEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_attack_type = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_tick = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_attack = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_has_target = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_Pathfinding = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_in_cd = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_in_cd2 = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_range_cd = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_phase = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_phase_tick = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_phase = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_in_hurt = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_hurt_tick = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_jumpback_tick = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_in_jumpback = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_can_jumpback = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_sleep = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_in_sleep_getup = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_sleep_tick = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_recover = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_can_recover = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_can_recover_tick = SynchedEntityData.defineId(WastelandsTyrantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();
    public final AnimationState animationState5 = new AnimationState();
    public final AnimationState animationState6 = new AnimationState();
    public final AnimationState animationState7 = new AnimationState();
    public final AnimationState animationState8 = new AnimationState();
    public final AnimationState animationState9 = new AnimationState();
    public final AnimationState animationState10 = new AnimationState();
    public final AnimationState animationState11 = new AnimationState();
    public final AnimationState animationState12 = new AnimationState();
    public final AnimationState animationState13 = new AnimationState();
    public final AnimationState animationState14 = new AnimationState();
    public final AnimationState animationState15 = new AnimationState();
    public final AnimationState animationState16 = new AnimationState();
    public final AnimationState animationState17 = new AnimationState();
    public final AnimationState animationState18 = new AnimationState();
    public final AnimationState animationState19 = new AnimationState();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);

    public WastelandsTyrantEntity(EntityType<WastelandsTyrantEntity> type, Level world) {
        super(type, world);
        this.xpReward = 30;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_attack_type, (Object)0);
        builder.define(DATA_attack_tick, (Object)0);
        builder.define(DATA_in_attack, (Object)false);
        builder.define(DATA_has_target, (Object)0);
        builder.define(DATA_Pathfinding, (Object)false);
        builder.define(DATA_in_cd, (Object)false);
        builder.define(DATA_in_cd2, (Object)false);
        builder.define(DATA_range_cd, (Object)0);
        builder.define(DATA_phase, (Object)1);
        builder.define(DATA_phase_tick, (Object)0);
        builder.define(DATA_in_phase, (Object)false);
        builder.define(DATA_in_hurt, (Object)false);
        builder.define(DATA_hurt_tick, (Object)0);
        builder.define(DATA_jumpback_tick, (Object)0);
        builder.define(DATA_in_jumpback, (Object)false);
        builder.define(DATA_can_jumpback, (Object)false);
        builder.define(DATA_sleep, (Object)false);
        builder.define(DATA_in_sleep_getup, (Object)false);
        builder.define(DATA_sleep_tick, (Object)0);
        builder.define(DATA_recover, (Object)0);
        builder.define(DATA_can_recover, (Object)false);
        builder.define(DATA_can_recover_tick, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = WastelandsTyrantEntity.this.getX();
                double y = WastelandsTyrantEntity.this.getY();
                double z = WastelandsTyrantEntity.this.getZ();
                WastelandsTyrantEntity entity = WastelandsTyrantEntity.this;
                Level world = WastelandsTyrantEntity.this.level();
                return super.canUse() && WastelandsTyrantCanGetEnemyProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WastelandsTyrantEntity.this.getX();
                double y = WastelandsTyrantEntity.this.getY();
                double z = WastelandsTyrantEntity.this.getZ();
                WastelandsTyrantEntity entity = WastelandsTyrantEntity.this;
                Level world = WastelandsTyrantEntity.this.level();
                return super.canContinueToUse() && WastelandsTyrantCanGetEnemyProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = WastelandsTyrantEntity.this.getX();
                double y = WastelandsTyrantEntity.this.getY();
                double z = WastelandsTyrantEntity.this.getZ();
                WastelandsTyrantEntity entity = WastelandsTyrantEntity.this;
                Level world = WastelandsTyrantEntity.this.level();
                return super.canUse() && WastelandsTyrantAnimationRandomwalkProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WastelandsTyrantEntity.this.getX();
                double y = WastelandsTyrantEntity.this.getY();
                double z = WastelandsTyrantEntity.this.getZ();
                WastelandsTyrantEntity entity = WastelandsTyrantEntity.this;
                Level world = WastelandsTyrantEntity.this.level();
                return super.canContinueToUse() && WastelandsTyrantAnimationRandomwalkProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.ravager.ambient"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.ravager.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.ravager.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.ravager.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        WastelandsTyrantEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        int phase = (Integer)this.entityData.get(DATA_phase);
        boolean inPhase = (Boolean)this.entityData.get(DATA_in_phase);
        boolean sleep = (Boolean)this.entityData.get(DATA_sleep);
        boolean inSleepGetup = (Boolean)this.entityData.get(DATA_in_sleep_getup);
        float currentHealth = this.getHealth();
        WastelandsTyrantHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, immediatesourceentity);
        if (inPhase) {
            return false;
        }
        if (sleep) {
            this.entityData.set(DATA_sleep, (Object)false);
            this.entityData.set(DATA_in_sleep_getup, (Object)true);
            return false;
        }
        if (inSleepGetup) {
            return false;
        }
        if (phase == 1 && currentHealth - amount <= 0.0f) {
            this.entityData.set(DATA_phase, (Object)2);
            this.entityData.set(DATA_in_phase, (Object)true);
            this.entityData.set(DATA_phase_tick, (Object)0);
            this.setHealth(1.0f);
            return false;
        }
        if (phase == 2 && currentHealth - amount <= 0.0f) {
            if (sourceentity instanceof ServerPlayer) {
                AdvancementProgress _ap;
                ServerPlayer _player = (ServerPlayer)sourceentity;
                AdvancementHolder _adv = _player.server.getAdvancements().get(ResourceLocation.parse((String)"radiation_zone_reborn:kill_wastelands_tyrant"));
                if (_adv != null && !(_ap = _player.getAdvancements().getOrStartProgress(_adv)).isDone()) {
                    for (String criteria : _ap.getRemainingCriteria()) {
                        _player.getAdvancements().award(_adv, criteria);
                    }
                }
            }
            this.entityData.set(DATA_phase, (Object)3);
            this.entityData.set(DATA_in_phase, (Object)true);
            this.entityData.set(DATA_phase_tick, (Object)0);
            this.setHealth(1.0f);
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (phase == 1 && !world.isClientSide() && amount > 0.0f) {
            boolean isEntityDamage;
            boolean canJumpback = (Boolean)this.entityData.get(DATA_can_jumpback);
            boolean inJumpback = (Boolean)this.entityData.get(DATA_in_jumpback);
            boolean bl = isEntityDamage = sourceentity != null;
            if (canJumpback && !inJumpback && isEntityDamage && this.getRandom().nextFloat() < 0.3f) {
                this.entityData.set(DATA_in_jumpback, (Object)true);
                return false;
            }
        }
        if (phase == 2) {
            double dz;
            double dy;
            double dx;
            double distanceSqr;
            if (damagesource.is(DamageTypes.IN_FIRE)) {
                return false;
            }
            if (damagesource.is(DamageTypes.ON_FIRE)) {
                return false;
            }
            Entity sourceentity2 = damagesource.getEntity();
            if (sourceentity2 != null && (distanceSqr = (dx = sourceentity2.getX() - this.getX()) * dx + (dy = sourceentity2.getY() - this.getY()) * dy + (dz = sourceentity2.getZ() - this.getZ()) * dz) > 400.0) {
                return false;
            }
            if (!world.isClientSide()) {
                LivingEntity livingAttacker;
                ItemStack weapon;
                Entity attacker = damagesource.getEntity();
                amount = attacker instanceof LivingEntity ? ((weapon = (livingAttacker = (LivingEntity)attacker).getMainHandItem()).getItem() instanceof PickaxeItem ? (amount *= 1.5f) : (amount *= 0.75f)) : (amount *= 0.25f);
                amount = Math.max(0.0f, amount);
            }
        }
        return super.hurt(damagesource, amount);
    }

    public boolean isPushable() {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataattack_type", ((Integer)this.entityData.get(DATA_attack_type)).intValue());
        compound.putInt("Dataattack_tick", ((Integer)this.entityData.get(DATA_attack_tick)).intValue());
        compound.putBoolean("Datain_attack", ((Boolean)this.entityData.get(DATA_in_attack)).booleanValue());
        compound.putInt("Datahas_target", ((Integer)this.entityData.get(DATA_has_target)).intValue());
        compound.putBoolean("DataPathfinding", ((Boolean)this.entityData.get(DATA_Pathfinding)).booleanValue());
        compound.putBoolean("Datain_cd", ((Boolean)this.entityData.get(DATA_in_cd)).booleanValue());
        compound.putBoolean("Datain_cd2", ((Boolean)this.entityData.get(DATA_in_cd2)).booleanValue());
        compound.putInt("Datarange_cd", ((Integer)this.entityData.get(DATA_range_cd)).intValue());
        compound.putInt("Dataphase", ((Integer)this.entityData.get(DATA_phase)).intValue());
        compound.putInt("Dataphase_tick", ((Integer)this.entityData.get(DATA_phase_tick)).intValue());
        compound.putBoolean("Datain_phase", ((Boolean)this.entityData.get(DATA_in_phase)).booleanValue());
        compound.putBoolean("Datain_hurt", ((Boolean)this.entityData.get(DATA_in_hurt)).booleanValue());
        compound.putInt("Datahurt_tick", ((Integer)this.entityData.get(DATA_hurt_tick)).intValue());
        compound.putInt("Datajumpback_tick", ((Integer)this.entityData.get(DATA_jumpback_tick)).intValue());
        compound.putBoolean("Datain_jumpback", ((Boolean)this.entityData.get(DATA_in_jumpback)).booleanValue());
        compound.putBoolean("Datacan_jumpback", ((Boolean)this.entityData.get(DATA_can_jumpback)).booleanValue());
        compound.putBoolean("Datasleep", ((Boolean)this.entityData.get(DATA_sleep)).booleanValue());
        compound.putBoolean("Datain_sleep_getup", ((Boolean)this.entityData.get(DATA_in_sleep_getup)).booleanValue());
        compound.putInt("Datasleep_tick", ((Integer)this.entityData.get(DATA_sleep_tick)).intValue());
        compound.putInt("Datarecover", ((Integer)this.entityData.get(DATA_recover)).intValue());
        compound.putBoolean("Datacan_recover", ((Boolean)this.entityData.get(DATA_can_recover)).booleanValue());
        compound.putInt("Datacan_recover_tick", ((Integer)this.entityData.get(DATA_can_recover_tick)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataattack_type")) {
            this.entityData.set(DATA_attack_type, (Object)compound.getInt("Dataattack_type"));
        }
        if (compound.contains("Dataattack_tick")) {
            this.entityData.set(DATA_attack_tick, (Object)compound.getInt("Dataattack_tick"));
        }
        if (compound.contains("Datain_attack")) {
            this.entityData.set(DATA_in_attack, (Object)compound.getBoolean("Datain_attack"));
        }
        if (compound.contains("Datahas_target")) {
            this.entityData.set(DATA_has_target, (Object)compound.getInt("Datahas_target"));
        }
        if (compound.contains("DataPathfinding")) {
            this.entityData.set(DATA_Pathfinding, (Object)compound.getBoolean("DataPathfinding"));
        }
        if (compound.contains("Datain_cd")) {
            this.entityData.set(DATA_in_cd, (Object)compound.getBoolean("Datain_cd"));
        }
        if (compound.contains("Datain_cd2")) {
            this.entityData.set(DATA_in_cd2, (Object)compound.getBoolean("Datain_cd2"));
        }
        if (compound.contains("Datarange_cd")) {
            this.entityData.set(DATA_range_cd, (Object)compound.getInt("Datarange_cd"));
        }
        if (compound.contains("Dataphase")) {
            this.entityData.set(DATA_phase, (Object)compound.getInt("Dataphase"));
        }
        if (compound.contains("Dataphase_tick")) {
            this.entityData.set(DATA_phase_tick, (Object)compound.getInt("Dataphase_tick"));
        }
        if (compound.contains("Datain_phase")) {
            this.entityData.set(DATA_in_phase, (Object)compound.getBoolean("Datain_phase"));
        }
        if (compound.contains("Datain_hurt")) {
            this.entityData.set(DATA_in_hurt, (Object)compound.getBoolean("Datain_hurt"));
        }
        if (compound.contains("Datahurt_tick")) {
            this.entityData.set(DATA_hurt_tick, (Object)compound.getInt("Datahurt_tick"));
        }
        if (compound.contains("Datajumpback_tick")) {
            this.entityData.set(DATA_jumpback_tick, (Object)compound.getInt("Datajumpback_tick"));
        }
        if (compound.contains("Datain_jumpback")) {
            this.entityData.set(DATA_in_jumpback, (Object)compound.getBoolean("Datain_jumpback"));
        }
        if (compound.contains("Datacan_jumpback")) {
            this.entityData.set(DATA_can_jumpback, (Object)compound.getBoolean("Datacan_jumpback"));
        }
        if (compound.contains("Datasleep")) {
            this.entityData.set(DATA_sleep, (Object)compound.getBoolean("Datasleep"));
        }
        if (compound.contains("Datain_sleep_getup")) {
            this.entityData.set(DATA_in_sleep_getup, (Object)compound.getBoolean("Datain_sleep_getup"));
        }
        if (compound.contains("Datasleep_tick")) {
            this.entityData.set(DATA_sleep_tick, (Object)compound.getInt("Datasleep_tick"));
        }
        if (compound.contains("Datarecover")) {
            this.entityData.set(DATA_recover, (Object)compound.getInt("Datarecover"));
        }
        if (compound.contains("Datacan_recover")) {
            this.entityData.set(DATA_can_recover, (Object)compound.getBoolean("Datacan_recover"));
        }
        if (compound.contains("Datacan_recover_tick")) {
            this.entityData.set(DATA_can_recover_tick, (Object)compound.getInt("Datacan_recover_tick"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(true, this.tickCount);
            this.animationState2.animateWhen(WastelandsTyrantAnimationAttack1Procedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(WastelandsTyrantAnimationAttack11Procedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(WastelandsTyrantAnimationAttack2Procedure.execute((Entity)this), this.tickCount);
            this.animationState5.animateWhen(WastelandsTyrantAnimationAttack3Procedure.execute((Entity)this), this.tickCount);
            this.animationState6.animateWhen(WastelandsTyrantAnimationAttack4Procedure.execute((Entity)this), this.tickCount);
            this.animationState7.animateWhen(WastelandsTyrantAnimationRushProcedure.execute((Entity)this), this.tickCount);
            this.animationState8.animateWhen(WastelandsTyrantAnimationRush1Procedure.execute((Entity)this), this.tickCount);
            this.animationState9.animateWhen(WastelandsTyrantAnimationJumpProcedure.execute((Entity)this), this.tickCount);
            this.animationState10.animateWhen(WastelandsTyrantAnimationJump2Procedure.execute((Entity)this), this.tickCount);
            this.animationState11.animateWhen(WastelandsTyrantAnimationGetupProcedure.execute((Entity)this), this.tickCount);
            this.animationState12.animateWhen(WastelandsTyrantAnimationPhase2Procedure.execute((Entity)this), this.tickCount);
            this.animationState13.animateWhen(WastelandsTyrantAnimationJump3Procedure.execute((Entity)this), this.tickCount);
            this.animationState14.animateWhen(WastelandsTyrantAnimationShootSkyProcedure.execute((Entity)this), this.tickCount);
            this.animationState15.animateWhen(WastelandsTyrantAnimationJump4Procedure.execute((Entity)this), this.tickCount);
            this.animationState16.animateWhen(WastelandsTyrantAnimationPhase3Procedure.execute((Entity)this), this.tickCount);
            this.animationState17.animateWhen(WastelandsTyrantAnimationPhase22Procedure.execute((Entity)this), this.tickCount);
            this.animationState18.animateWhen(WastelandsTyrantAnimationSleepProcedure.execute((Entity)this), this.tickCount);
            this.animationState19.animateWhen(WastelandsTyrantAnimationSleepEndProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        WastelandsTyrantTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.23);
        builder = builder.add(Attributes.MAX_HEALTH, 240.0);
        builder = builder.add(Attributes.ARMOR, 4.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 16.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.1);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        return builder;
    }
}

