/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.fantasy_trees;

import com.github.x3r.fantasy_trees.FantasyTreesConfig;
import com.github.x3r.fantasy_trees.common.biome.region.FantasyBirchRegion;
import com.github.x3r.fantasy_trees.common.biome.region.FantasyDarkOakRegion;
import com.github.x3r.fantasy_trees.common.biome.region.FantasyJungleRegion;
import com.github.x3r.fantasy_trees.common.biome.region.FantasyOakRegion;
import com.github.x3r.fantasy_trees.common.biome.region.FantasySavanna;
import com.github.x3r.fantasy_trees.common.biome.region.FantasySpruceRegion;
import com.github.x3r.fantasy_trees.registry.BlockItemRegistry;
import com.github.x3r.fantasy_trees.registry.BlockRegistry;
import com.github.x3r.fantasy_trees.registry.FeatureRegistry;
import com.github.x3r.fantasy_trees.registry.ItemRegistry;
import com.github.x3r.fantasy_trees.registry.StructureRegistry;
import com.mojang.logging.LogUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;
import terrablender.api.Region;
import terrablender.api.Regions;

@Mod(value="fantasy_trees")
public class FantasyTrees {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MOD_ID = "fantasy_trees";
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"fantasy_trees");
    public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registries.f_256911_, (String)"fantasy_trees");
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registries.f_256988_, (String)"fantasy_trees");

    public FantasyTrees() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::setup);
        BIOMES.register(modEventBus);
        BlockRegistry.BLOCKS.register(modEventBus);
        BlockRegistry.registerFantasyBlocks();
        BlockItemRegistry.BLOCK_ITEMS.register(modEventBus);
        BlockItemRegistry.registerFantasyBlockItems();
        ItemRegistry.ITEMS.register(modEventBus);
        ItemRegistry.registerFantasyItems();
        ItemRegistry.FantasyTreesItemTab.CREATIVE_TABS.register(modEventBus);
        StructureRegistry.STRUCTURE_FEATURES.register(modEventBus);
        FeatureRegistry.FEATURES.register(modEventBus);
        CONFIGURED_FEATURES.register(modEventBus);
        PLACED_FEATURES.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)FantasyTreesConfig.SPEC, "fantasy_trees-common.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Regions.register((Region)new FantasyOakRegion(new ResourceLocation(MOD_ID, "oak_region"), (Integer)FantasyTreesConfig.oak_region_weight.get()));
            Regions.register((Region)new FantasySpruceRegion(new ResourceLocation(MOD_ID, "spruce_region"), (Integer)FantasyTreesConfig.spruce_region_weight.get()));
            Regions.register((Region)new FantasyBirchRegion(new ResourceLocation(MOD_ID, "birch_region"), (Integer)FantasyTreesConfig.birch_region_weight.get()));
            Regions.register((Region)new FantasyDarkOakRegion(new ResourceLocation(MOD_ID, "dark_oak_region"), (Integer)FantasyTreesConfig.dark_oak_region_weight.get()));
            Regions.register((Region)new FantasyJungleRegion(new ResourceLocation(MOD_ID, "jungle_region"), (Integer)FantasyTreesConfig.jungle_region_weight.get()));
            Regions.register((Region)new FantasySavanna(new ResourceLocation(MOD_ID, "savanna_region"), (Integer)FantasyTreesConfig.savanna_region_weight.get()));
        });
    }
}

