/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.fantasy_trees.client;

import com.github.x3r.fantasy_trees.registry.BlockRegistry;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="fantasy_trees", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        BlockRegistry.SAPLINGS.forEach((s, blockRegistryObject) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)blockRegistryObject.get()), (RenderType)RenderType.m_110457_()));
        BlockRegistry.DOORS.forEach((s, blockRegistryObject) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)blockRegistryObject.get()), (RenderType)RenderType.m_110457_()));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.FANTASY_FLOWER.get()), (RenderType)RenderType.m_110457_());
    }

    @SubscribeEvent
    public static void blockColorHandler(RegisterColorHandlersEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        BlockRegistry.LEAVES.forEach((s, blockRegistryObject) -> colors.m_92589_((blockState, tintGetter, blockPos, i) -> tintGetter != null && blockPos != null ? ClientEvents.getBlockLeafColor(s, tintGetter, blockPos) : FoliageColor.m_46113_(), new Block[]{(Block)blockRegistryObject.get()}));
    }

    @SubscribeEvent
    public static void itemColorHandler(RegisterColorHandlersEvent.Item event) {
        ItemColors colors = event.getItemColors();
        BlockRegistry.LEAVES.forEach((s, blockRegistryObject) -> colors.m_92689_((stack, i) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return event.getBlockColors().m_92577_(blockstate, null, null, i);
        }, new ItemLike[]{(ItemLike)blockRegistryObject.get()}));
    }

    private static int getBlockLeafColor(String name, BlockAndTintGetter p_92627_, BlockPos p_92628_) {
        if (name.equals("spruce")) {
            return FoliageColor.m_46106_();
        }
        if (name.equals("birch")) {
            return FoliageColor.m_46112_();
        }
        return BiomeColors.m_108804_((BlockAndTintGetter)p_92627_, (BlockPos)p_92628_);
    }
}

