/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.fantasy_trees.common.biome.region;

import com.github.x3r.fantasy_trees.registry.BiomeRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import terrablender.api.ParameterUtils;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class FantasyJungleRegion
extends Region {
    public FantasyJungleRegion(ResourceLocation name, int weight) {
        super(name, RegionType.OVERWORLD, weight);
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
            builder.replaceBiome(Biomes.f_48222_, BiomeRegistry.FANTASY_JUNGLE);
            List fantasyForestPoints = new ParameterUtils.ParameterPointListBuilder().temperature(new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-0.3f, (float)0.0f)}).humidity(new ParameterUtils.Humidity[]{ParameterUtils.Humidity.WET, ParameterUtils.Humidity.HUMID}).continentalness(new Climate.Parameter[]{Climate.Parameter.m_186822_((float)0.25f, (float)1.0f)}).erosion(new ParameterUtils.Erosion[]{ParameterUtils.Erosion.FULL_RANGE}).depth(new ParameterUtils.Depth[]{ParameterUtils.Depth.SURFACE}).weirdness(new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-0.35f, (float)0.35f)}).build();
            fantasyForestPoints.forEach(parameterPoint -> builder.replaceBiome(parameterPoint, BiomeRegistry.FANTASY_JUNGLE));
        });
    }
}

