/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.fantasy_trees.common.blocks.grower;

import com.github.x3r.fantasy_trees.FantasyTreesConfig;
import com.github.x3r.fantasy_trees.common.features.TreeConfiguration;
import com.github.x3r.fantasy_trees.registry.BlockRegistry;
import com.github.x3r.fantasy_trees.registry.ConfiguredFeatureRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.jetbrains.annotations.Nullable;

public class FantasyTreeGrower
extends AbstractTreeGrower {
    private final String name;

    public FantasyTreeGrower(String name) {
        this.name = name;
    }

    public boolean m_213817_(ServerLevel level, ChunkGenerator chunkGenerator, BlockPos pos, BlockState state, RandomSource random) {
        if (!((Boolean)FantasyTreesConfig.can_grow_fantasy_sapling.get()).booleanValue()) {
            return false;
        }
        Pair<BlockPattern.BlockPatternMatch, Integer> pattern = this.getTreePattern(level, pos);
        ResourceLocation structure = FantasyTreeGrower.getStructure((Integer)pattern.getSecond(), this.name, random);
        if (structure == null) {
            return false;
        }
        this.destroyArea(level, (BlockPattern.BlockPatternMatch)pattern.getFirst());
        int offset = 0;
        if ((Integer)pattern.getSecond() == 2) {
            offset = -3;
        }
        if ((Integer)pattern.getSecond() == 3) {
            offset = -5;
        }
        return true;
    }

    protected static ResourceLocation getStructure(int size, String name, RandomSource random) {
        switch (size) {
            case 1: {
                if (name.equals("acacia")) {
                    return TreeConfiguration.getRandomTree(ConfiguredFeatureRegistry.FANTASY_ACACIA_SMALL_LIST, random);
                }
                if (name.equals("birch")) {
                    return TreeConfiguration.getRandomTree(ConfiguredFeatureRegistry.FANTASY_BIRCH_SMALL_LIST, random);
                }
                if (name.equals("oak")) {
                    return TreeConfiguration.getRandomTree(ConfiguredFeatureRegistry.FANTASY_OAK_SMALL_LIST, random);
                }
                if (name.equals("jungle")) {
                    return TreeConfiguration.getRandomTree(ConfiguredFeatureRegistry.FANTASY_JUNGLE_SMALL_LIST, random);
                }
                if (!name.equals("spruce")) break;
                return TreeConfiguration.getRandomTree(ConfiguredFeatureRegistry.FANTASY_SPRUCE_SMALL_LIST, random);
            }
            case 2: {
                if (name.equals("birch")) {
                    return TreeConfiguration.getRandomTree(ConfiguredFeatureRegistry.FANTASY_BIRCH_MEDIUM_LIST, random);
                }
                if (name.equals("oak")) {
                    return TreeConfiguration.getRandomTree(ConfiguredFeatureRegistry.FANTASY_OAK_MEDIUM_LIST, random);
                }
                if (name.equals("jungle")) {
                    return TreeConfiguration.getRandomTree(ConfiguredFeatureRegistry.FANTASY_JUNGLE_MEDIUM_LIST, random);
                }
                if (!name.equals("spruce")) break;
                return TreeConfiguration.getRandomTree(ConfiguredFeatureRegistry.FANTASY_SPRUCE_MEDIUM_LIST, random);
            }
            case 3: {
                if (name.equals("acacia")) {
                    return new ResourceLocation("fantasy_trees", "fantasy_acacia_large_" + (random.m_188503_(3) + 1));
                }
                if (name.equals("birch")) {
                    return new ResourceLocation("fantasy_trees", "fantasy_birch_large_1");
                }
                if (name.equals("dark_oak")) {
                    return new ResourceLocation("fantasy_trees", "fantasy_dark_oak_large_" + (random.m_188503_(4) + 1));
                }
                if (name.equals("jungle")) {
                    return new ResourceLocation("fantasy_trees", "fantasy_jungle_large_" + (random.m_188503_(3) + 1));
                }
                if (name.equals("oak")) {
                    return new ResourceLocation("fantasy_trees", "fantasy_oak_large_" + (random.m_188503_(5) + 1));
                }
                if (!name.equals("spruce")) break;
                return new ResourceLocation("fantasy_trees", "fantasy_spruce_large_" + (random.m_188503_(3) + 1));
            }
        }
        return null;
    }

    protected Pair<BlockPattern.BlockPatternMatch, Integer> getTreePattern(ServerLevel level, BlockPos pos) {
        Block sapling = (Block)BlockRegistry.SAPLINGS.get(this.name).get();
        BlockPattern.BlockPatternMatch medium = this.mediumTreePattern(sapling).m_61184_((LevelReader)level, pos);
        if (medium != null) {
            return new Pair((Object)medium, (Object)2);
        }
        BlockPattern.BlockPatternMatch large = this.largeTreePattern(sapling).m_61184_((LevelReader)level, pos);
        if (large != null) {
            return new Pair((Object)large, (Object)3);
        }
        return new Pair(null, (Object)1);
    }

    private BlockPattern mediumTreePattern(Block sapling) {
        return BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~*~", "*^*", "~*~"}).m_61244_('~', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50016_))).m_61244_('*', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)sapling))).m_61244_('^', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50074_))).m_61249_();
    }

    private BlockPattern largeTreePattern(Block sapling) {
        return BlockPatternBuilder.m_61243_().m_61247_(new String[]{"***", "*^*", "***"}).m_61244_('*', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)sapling))).m_61244_('^', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50090_))).m_61249_();
    }

    protected void destroyArea(ServerLevel level, BlockPattern.BlockPatternMatch patternMatch) {
        if (patternMatch != null) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    level.m_7731_(patternMatch.m_61229_(i, j, 0).m_61176_(), Blocks.f_50016_.m_49966_(), 18);
                }
            }
        }
    }

    @Nullable
    protected ResourceKey<ConfiguredFeature<?, ?>> m_213888_(RandomSource randomSource, boolean b) {
        return null;
    }
}

