/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.fantasy_trees.common.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class TreeConfiguration
implements FeatureConfiguration {
    public static final Codec<TreeConfiguration> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)Codec.pair((Codec)Codec.INT.fieldOf("weight").codec(), (Codec)Codec.INT.fieldOf("offset").codec())).fieldOf("trees").forGetter(treeConfiguration -> treeConfiguration.trees)).apply((Applicative)codec, TreeConfiguration::new));
    public final Map<ResourceLocation, Pair<Integer, Integer>> trees;

    public TreeConfiguration(Map<ResourceLocation, Pair<Integer, Integer>> trees) {
        this.trees = trees;
    }

    public static ResourceLocation getRandomTree(Map<ResourceLocation, Pair<Integer, Integer>> trees, RandomSource random) {
        int[] totalWeight = new int[]{0};
        trees.values().forEach(integerIntegerPair -> {
            totalWeight[0] = totalWeight[0] + (Integer)integerIntegerPair.getFirst();
        });
        int targetWeight = Math.round(random.m_188501_() * (float)totalWeight[0]);
        int accWeight = 0;
        for (ResourceLocation resourceLocation : trees.keySet()) {
            if ((accWeight += ((Integer)trees.get(resourceLocation).getFirst()).intValue()) < targetWeight) continue;
            return resourceLocation;
        }
        return null;
    }
}

