/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.fantasy_trees.common.structures;

import com.github.x3r.fantasy_trees.common.structures.StructureUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class LargeTreeStructures
extends Structure {
    public static final Codec<LargeTreeStructures> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LargeTreeStructures.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, LargeTreeStructures::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public LargeTreeStructures(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.TOP_LAYER_MODIFICATION;
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext context) {
        if (this.startJigsawName.isEmpty()) {
            return Optional.empty();
        }
        StructureTemplate structuretemplate = context.f_226625_().m_230359_(this.startJigsawName.get());
        BlockPos pos = context.f_226628_().m_45615_();
        Rotation rotation = Rotation.m_221990_((RandomSource)RandomSource.m_216327_());
        BlockPos centerOffset = new BlockPos(structuretemplate.m_163801_().m_123341_() / 2, pos.m_123342_(), structuretemplate.m_163801_().m_123343_() / 2).m_7954_(rotation);
        BlockPos centerPos = pos.m_121955_((Vec3i)centerOffset);
        int y = context.f_226622_().m_223235_(centerPos.m_123341_(), centerPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        if (!LargeTreeStructures.isFeatureChunk(context, centerPos = centerPos.m_175288_(y))) {
            return Optional.empty();
        }
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)pos.m_175288_(y - 5 + LargeTreeStructures.getOffset(this.startJigsawName.get())), (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public static boolean isFeatureChunk(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext context, BlockPos pos) {
        if (!LargeTreeStructures.validBiomeOnTop(context, Heightmap.Types.WORLD_SURFACE_WG)) {
            return false;
        }
        if (!StructureUtils.isChunkFlat(pos, context.f_226624_().m_224579_(), Climate.Parameter.m_186822_((float)-0.2f, (float)0.2f), Climate.Parameter.m_186822_((float)-0.6f, (float)0.6f))) {
            return false;
        }
        return StructureUtils.isAreaDry(context, pos, 4);
    }

    public static boolean validBiomeOnTop(Structure.GenerationContext context, Heightmap.Types pHeightmapType) {
        int $$1 = context.f_226628_().m_151390_();
        int $$2 = context.f_226628_().m_151393_();
        int $$3 = context.f_226622_().m_223235_($$1, $$2, pHeightmapType, context.f_226629_(), context.f_226624_());
        Holder $$4 = context.f_226622_().m_62218_().m_203407_(QuartPos.m_175400_((int)$$1), QuartPos.m_175400_((int)$$3), QuartPos.m_175400_((int)$$2), context.f_226624_().m_224579_());
        return context.f_226630_().test($$4);
    }

    public StructureType<?> m_213658_() {
        return null;
    }

    private static int getOffset(ResourceLocation resourceLocation) {
        if (resourceLocation.m_135815_().equals("fantasy_dark_oak_large_1")) {
            return -15;
        }
        if (resourceLocation.m_135815_().equals("fantasy_acacia_large_2")) {
            return 4;
        }
        return 0;
    }
}

