/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.fantasy_trees.common.structures;

import com.github.x3r.fantasy_trees.FantasyTreesConfig;
import com.github.x3r.fantasy_trees.common.features.TreeConfiguration;
import com.github.x3r.fantasy_trees.common.util.Scheduler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;

public final class StructureUtils {
    private StructureUtils() {
    }

    public static boolean isAreaDry(@NotNull Structure.GenerationContext context, BlockPos origin, int radius) {
        return StructureUtils.isAreaDry(origin, context.f_226622_(), context.f_226629_(), radius, context);
    }

    public static boolean isAreaDry(BlockPos blockPos, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, int radius, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Structure.GenerationContext context) {
        for (Direction direction : Direction.values()) {
            if (!direction.m_122434_().m_122479_()) continue;
            BlockPos checkPos = blockPos.m_5484_(direction, radius);
            int h = chunkGenerator.m_223235_(checkPos.m_123341_(), checkPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, context.f_226624_());
            NoiseColumn column = chunkGenerator.m_214184_(checkPos.m_123341_(), checkPos.m_123343_(), heightAccessor, context.f_226624_());
            if (column.m_183556_(h).m_60819_().m_76178_()) continue;
            return false;
        }
        return true;
    }

    public static boolean isChunkFlat(BlockPos pos, Climate.Sampler sampler, Climate.Parameter acceptableDepth, Climate.Parameter acceptableWeird) {
        double depth = sampler.f_207849_().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        boolean f0 = depth >= (double)Climate.m_186796_((long)acceptableDepth.f_186813_()) && depth <= (double)Climate.m_186796_((long)acceptableDepth.f_186814_());
        double weirdness = sampler.f_207850_().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        boolean f1 = weirdness >= (double)Climate.m_186796_((long)acceptableWeird.f_186813_()) && weirdness <= (double)Climate.m_186796_((long)acceptableWeird.f_186814_());
        return f0 && f1;
    }

    public static boolean isSuitableTreePos(BlockPos pos, FeaturePlaceContext<TreeConfiguration> context) {
        boolean f0 = context.m_159774_().m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144274_);
        boolean f1 = !context.m_159774_().m_8055_(pos).m_60838_((BlockGetter)context.m_159774_(), pos);
        return f0 && f1;
    }

    public static boolean placeStructure(ResourceLocation resourceLocation, ServerLevel level, BlockPos pos, int offset) {
        if (resourceLocation != null && level.m_215082_().m_230407_(resourceLocation).isPresent()) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 18);
            StructureTemplate structuretemplate = (StructureTemplate)level.m_215082_().m_230407_(resourceLocation).get();
            try {
                Field f = ObfuscationReflectionHelper.findField(StructureTemplate.class, (String)"f_74482_");
                f.setAccessible(true);
                List paletteList = (List)f.get(structuretemplate);
                ArrayList blocks = new ArrayList();
                ArrayList leaves = new ArrayList();
                ArrayList vines = new ArrayList();
                paletteList.forEach(palette -> palette.m_74652_().forEach(structureBlockInfo -> {
                    if (structureBlockInfo.f_74676_().m_60734_() instanceof VineBlock) {
                        vines.add(structureBlockInfo);
                    } else if (structureBlockInfo.f_74676_().m_60734_() instanceof LeavesBlock) {
                        leaves.add(structureBlockInfo);
                    } else {
                        blocks.add(structureBlockInfo);
                    }
                }));
                int i = StructureUtils.getMaxHeight(paletteList) + 1;
                for (StructureTemplate.StructureBlockInfo info : blocks) {
                    Scheduler.schedule(() -> StructureUtils.placeStructureBlock(info, structuretemplate, level, pos, offset), info.f_74675_().m_123342_() * (Integer)FantasyTreesConfig.growth_delay.get());
                }
                for (StructureTemplate.StructureBlockInfo info : leaves) {
                    Scheduler.schedule(() -> StructureUtils.placeStructureBlock(info, structuretemplate, level, pos, offset), (2 * i - info.f_74675_().m_123342_()) * (Integer)FantasyTreesConfig.growth_delay.get());
                }
                for (StructureTemplate.StructureBlockInfo info : vines) {
                    Scheduler.schedule(() -> StructureUtils.placeStructureBlock(info, structuretemplate, level, pos, offset), (int)((2.5 * (double)i - (double)info.f_74675_().m_123342_()) * (double)((Integer)FantasyTreesConfig.growth_delay.get()).intValue()));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    private static void placeStructureBlock(StructureTemplate.StructureBlockInfo info, StructureTemplate structuretemplate, ServerLevel level, BlockPos pos, int offset) {
        BlockPos placePos = pos.m_121955_((Vec3i)info.f_74675_()).m_7918_(-(structuretemplate.m_163801_().m_123341_() / 2), offset, -(structuretemplate.m_163801_().m_123343_() / 2));
        if (((Boolean)FantasyTreesConfig.override_blocks.get()).booleanValue()) {
            level.m_7731_(placePos, info.f_74676_(), 18);
        } else if (level.m_8055_(placePos).m_60795_()) {
            level.m_7731_(placePos, info.f_74676_(), 18);
        }
    }

    private static int getMaxHeight(List<StructureTemplate.Palette> paletteList) {
        int max = 0;
        for (StructureTemplate.Palette palette : paletteList) {
            for (StructureTemplate.StructureBlockInfo block : palette.m_74652_()) {
                max = Math.max(max, block.f_74675_().m_123342_());
            }
        }
        return max;
    }
}

