/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.fantasy_trees.common.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="fantasy_trees")
public final class Scheduler {
    public static final ConcurrentMap<Integer, List<Runnable>> SERVER_SCHEDULE = new ConcurrentHashMap<Integer, List<Runnable>>();

    private Scheduler() {
    }

    public static void schedule(Runnable task, int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("delay cannot be negative");
        }
        SERVER_SCHEDULE.compute(ServerLifecycleHooks.getCurrentServer().m_129921_() + delay, (integer, runnables) -> {
            if (runnables == null) {
                runnables = new ObjectArrayList();
            }
            runnables.add(task);
            return runnables;
        });
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        int ticks = ServerLifecycleHooks.getCurrentServer().m_129921_();
        List tasks = (List)SERVER_SCHEDULE.get(ticks);
        if (tasks != null) {
            tasks.forEach(Runnable::run);
            SERVER_SCHEDULE.remove(ticks);
        }
    }
}

