/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.fantasy_trees.registry;

import com.github.x3r.fantasy_trees.registry.PlacedFeatureRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class BiomeRegistry {
    private static List<ResourceKey<Biome>> biomes = Lists.newArrayList();
    public static final ResourceKey<Biome> FANTASY_TAIGA = BiomeRegistry.registerBiome("fantasy_taiga");
    public static final ResourceKey<Biome> FANTASY_FOREST = BiomeRegistry.registerBiome("fantasy_forest");
    public static final ResourceKey<Biome> FANTASY_BIRCH_FOREST = BiomeRegistry.registerBiome("fantasy_birch_forest");
    public static final ResourceKey<Biome> FANTASY_DARK_FOREST = BiomeRegistry.registerBiome("fantasy_dark_forest");
    public static final ResourceKey<Biome> FANTASY_JUNGLE = BiomeRegistry.registerBiome("fantasy_jungle");
    public static final ResourceKey<Biome> FANTASY_SAVANNA = BiomeRegistry.registerBiome("fantasy_savanna");

    public static void bootstrapBiomes(BootstapContext<Biome> context) {
        HolderGetter carverGetter = context.m_255420_(Registries.f_257003_);
        HolderGetter placedFeatureGetter = context.m_255420_(Registries.f_256988_);
        BiomeGenerationSettings.Builder genBuilder = new BiomeGenerationSettings.Builder(placedFeatureGetter, carverGetter);
        BiomeRegistry.register(context, FANTASY_TAIGA, BiomeRegistry.buildFantasyTaiga((BiomeGenerationSettings.Builder)genBuilder.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_SPRUCE_MEDIUM_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_SPRUCE_MEDIUM_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_FLOWERS_CHECKED))));
        BiomeRegistry.register(context, FANTASY_FOREST, BiomeRegistry.buildFantasyForest((BiomeGenerationSettings.Builder)genBuilder.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_OAK_SMALL_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_OAK_MEDIUM_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_FOREST_GRASS_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_VANILLA_FLOWERS_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_FLOWERS_CHECKED))));
        BiomeRegistry.register(context, FANTASY_BIRCH_FOREST, BiomeRegistry.buildFantasyBirchForest((BiomeGenerationSettings.Builder)genBuilder.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_BIRCH_SMALL_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_BIRCH_MEDIUM_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_FOREST_GRASS_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_VANILLA_FLOWERS_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_FLOWERS_CHECKED))));
        BiomeRegistry.register(context, FANTASY_DARK_FOREST, BiomeRegistry.buildFantasyDarkForest((BiomeGenerationSettings.Builder)genBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195422_).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_FOREST_GRASS_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_FLOWERS_CHECKED))));
        BiomeRegistry.register(context, FANTASY_JUNGLE, BiomeRegistry.buildFantasyJungle((BiomeGenerationSettings.Builder)genBuilder.m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_JUNGLE_SMALL_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_JUNGLE_MEDIUM_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_VANILLA_FLOWERS_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_FLOWERS_CHECKED))));
        BiomeRegistry.register(context, FANTASY_SAVANNA, BiomeRegistry.buildFantasySavanna((BiomeGenerationSettings.Builder)genBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, PlacedFeatureRegistry.FANTASY_ACACIA_SMALL_CHECKED).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_FOREST_GRASS_CHECKED)).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)placedFeatureGetter.m_255043_(PlacedFeatureRegistry.FANTASY_FLOWERS_CHECKED))));
    }

    private static void register(BootstapContext<Biome> context, ResourceKey<Biome> key, Biome biome) {
        context.m_255272_(key, (Object)biome);
    }

    private static ResourceKey<Biome> registerBiome(String name) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("fantasy_trees", name));
        biomes.add((ResourceKey<Biome>)key);
        return key;
    }

    public static List<ResourceKey<Biome>> getBiomes() {
        return ImmutableList.copyOf(biomes);
    }

    public static Biome buildFantasyTaiga(BiomeGenerationSettings.Builder genBuilder) {
        float temp = 0.25f;
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeRegistry.globalOverworldGeneration(genBuilder);
        genBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195442_);
        genBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195443_);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)genBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temp).m_47599_(Biome.TemperatureModifier.NONE).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(BiomeRegistry.calculateSkyColor(temp)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(mobspawnsettings$builder.m_48381_()).m_47601_(genBuilder.m_255380_()).m_47592_();
    }

    public static Biome buildFantasyForest(BiomeGenerationSettings.Builder genBuilder) {
        float temp = 0.6f;
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeRegistry.globalOverworldGeneration(genBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)genBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temp).m_47599_(Biome.TemperatureModifier.NONE).m_47611_(0.6f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(BiomeRegistry.calculateSkyColor(temp)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(mobspawnsettings$builder.m_48381_()).m_47601_(genBuilder.m_255380_()).m_47592_();
    }

    public static Biome buildFantasyBirchForest(BiomeGenerationSettings.Builder genBuilder) {
        float temp = 0.6f;
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeRegistry.globalOverworldGeneration(genBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)genBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temp).m_47599_(Biome.TemperatureModifier.NONE).m_47611_(0.6f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(BiomeRegistry.calculateSkyColor(temp)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(mobspawnsettings$builder.m_48381_()).m_47601_(genBuilder.m_255380_()).m_47592_();
    }

    public static Biome buildFantasyDarkForest(BiomeGenerationSettings.Builder genBuilder) {
        float temp = 0.7f;
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeRegistry.globalOverworldGeneration(genBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)genBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temp).m_47599_(Biome.TemperatureModifier.NONE).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(BiomeRegistry.calculateSkyColor(temp)).m_48031_(BiomeSpecialEffects.GrassColorModifier.DARK_FOREST).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(mobspawnsettings$builder.m_48381_()).m_47601_(genBuilder.m_255380_()).m_47592_();
    }

    public static Biome buildFantasyJungle(BiomeGenerationSettings.Builder genBuilder) {
        float temp = 0.9f;
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)mobspawnsettings$builder);
        BiomeRegistry.globalOverworldGeneration(genBuilder);
        BiomeDefaultFeatures.m_126722_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_198933_((BiomeGenerationSettings.Builder)genBuilder);
        BiomeDefaultFeatures.m_198929_((BiomeGenerationSettings.Builder)genBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temp).m_47599_(Biome.TemperatureModifier.NONE).m_47611_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(BiomeRegistry.calculateSkyColor(temp)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(mobspawnsettings$builder.m_48381_()).m_47601_(genBuilder.m_255380_()).m_47592_();
    }

    public static Biome buildFantasySavanna(BiomeGenerationSettings.Builder genBuilder) {
        float temp = 2.0f;
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        BiomeRegistry.globalOverworldGeneration(genBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temp).m_47599_(Biome.TemperatureModifier.NONE).m_47611_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(BiomeRegistry.calculateSkyColor(temp)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47605_(mobspawnsettings$builder.m_48381_()).m_47601_(genBuilder.m_255380_()).m_47592_();
    }

    private static int calculateSkyColor(float color) {
        float v = color / 3.0f;
        v = Mth.m_14036_((float)v, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - v * 0.05f), (float)(0.5f + v * 0.1f), (float)1.0f);
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)builder);
    }
}

