/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.fantasy_trees.registry;

import com.github.x3r.fantasy_trees.common.blocks.FantasyCraftingTableBlock;
import com.github.x3r.fantasy_trees.common.blocks.FantasyDoorBlock;
import com.github.x3r.fantasy_trees.common.blocks.FantasyLeavesBlock;
import com.github.x3r.fantasy_trees.common.blocks.FantasyLogBlock;
import com.github.x3r.fantasy_trees.common.blocks.FantasyPlanksBlock;
import com.github.x3r.fantasy_trees.common.blocks.FantasySaplingBlock;
import com.github.x3r.fantasy_trees.common.blocks.FantasyTrapDoorBlock;
import com.github.x3r.fantasy_trees.common.blocks.grower.FantasyTreeGrower;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"fantasy_trees");
    public static final RegistryObject<Block> FANTASY_FLOWER = BLOCKS.register("fantasy_flower", () -> new FlowerBlock(() -> MobEffects.f_19617_, 20, BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_60953_(value -> 15)));
    public static final Map<String, RegistryObject<Block>> WOODS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> LOGS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> STRIPPED_LOGS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> LEAVES = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> PLANKS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> STAIRS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> DOORS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> FENCES = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> FENCE_GATES = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> CRAFTING_TABLES = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> SAPLINGS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> STRIPPED_WOODS = new HashMap<String, RegistryObject<Block>>();
    public static final Map<String, RegistryObject<Block>> TRAPDOORS = new HashMap<String, RegistryObject<Block>>();
    protected static final WoodType[] WOOD_TYPES = new WoodType[]{WoodType.f_61830_, WoodType.f_61831_, WoodType.f_61832_, WoodType.f_61833_, WoodType.f_61834_, WoodType.f_61835_};

    public static void registerFantasyBlocks() {
        Arrays.stream(WOOD_TYPES).forEach(woodType -> {
            String name = woodType.f_61839_();
            RegistryObject wood = BLOCKS.register(String.format("fantasy_%s_wood", name), FantasyLogBlock::new);
            WOODS.put(name, (RegistryObject<Block>)wood);
            RegistryObject log = BLOCKS.register(String.format("fantasy_%s_log", name), FantasyLogBlock::new);
            LOGS.put(name, (RegistryObject<Block>)log);
            RegistryObject stripped_wood = BLOCKS.register(String.format("fantasy_stripped_%s_wood", name), FantasyLogBlock::new);
            STRIPPED_WOODS.put(name, (RegistryObject<Block>)stripped_wood);
            RegistryObject stripped_log = BLOCKS.register(String.format("fantasy_stripped_%s_log", name), FantasyLogBlock::new);
            STRIPPED_LOGS.put(name, (RegistryObject<Block>)stripped_log);
            RegistryObject leaves = BLOCKS.register(String.format("fantasy_%s_leaves", name), FantasyLeavesBlock::new);
            LEAVES.put(name, (RegistryObject<Block>)leaves);
            RegistryObject planks = BLOCKS.register(String.format("fantasy_%s_planks", name), FantasyPlanksBlock::new);
            PLANKS.put(name, (RegistryObject<Block>)planks);
            RegistryObject stairs = BLOCKS.register(String.format("fantasy_%s_stairs", name), () -> new StairBlock(() -> ((Block)planks.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)planks.get())).m_60953_(value -> 7)));
            STAIRS.put(name, (RegistryObject<Block>)stairs);
            RegistryObject door = BLOCKS.register(String.format("fantasy_%s_door", name), () -> new FantasyDoorBlock(woodType.f_271340_()));
            DOORS.put(name, (RegistryObject<Block>)door);
            RegistryObject trapdoor = BLOCKS.register(String.format("fantasy_%s_trapdoor", name), () -> new FantasyTrapDoorBlock(woodType.f_271340_()));
            TRAPDOORS.put(name, (RegistryObject<Block>)trapdoor);
            RegistryObject fence = BLOCKS.register(String.format("fantasy_%s_fence", name), () -> new FenceBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60953_(value -> 7)));
            FENCES.put(name, (RegistryObject<Block>)fence);
            RegistryObject fence_gate = BLOCKS.register(String.format("fantasy_%s_fence_gate", name), () -> new FenceGateBlock(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60953_(value -> 7), woodType));
            FENCE_GATES.put(name, (RegistryObject<Block>)fence_gate);
            RegistryObject crafting_table = BLOCKS.register(String.format("fantasy_%s_crafting_table", name), () -> new FantasyCraftingTableBlock(BlockBehaviour.Properties.m_284310_().m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_60953_(value -> 7)));
            CRAFTING_TABLES.put(name, (RegistryObject<Block>)crafting_table);
            RegistryObject sapling = BLOCKS.register(String.format("fantasy_%s_sapling", name), () -> new FantasySaplingBlock(new FantasyTreeGrower(name)));
            SAPLINGS.put(name, (RegistryObject<Block>)sapling);
        });
    }
}

