/*
 * Decompiled with CFR 0.152.
 */
package com.Vilantious.config;

import com.Vilantious.config.CreeperEvolutionConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3532;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path BASE_CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("creeperevolution/");
    private static final Path CONFIG_FILE_PATH = BASE_CONFIG_PATH.resolve("creeper-evolution.json");
    private static CreeperEvolutionConfig instance;

    public static CreeperEvolutionConfig getInstance() {
        if (instance == null) {
            ConfigManager.load();
        }
        return instance;
    }

    public static CreeperEvolutionConfig createDefault() {
        return new CreeperEvolutionConfig();
    }

    public static void load() {
        try {
            if (!BASE_CONFIG_PATH.toFile().exists()) {
                Files.createDirectory(BASE_CONFIG_PATH, new FileAttribute[0]);
            }
            if (!CONFIG_FILE_PATH.toFile().exists()) {
                CreeperEvolutionConfig creeperConfig = ConfigManager.createDefault();
                String newJson = GSON.toJson((Object)creeperConfig);
                Files.writeString(CONFIG_FILE_PATH, (CharSequence)newJson, StandardOpenOption.CREATE_NEW);
            }
            String json = Files.readString(CONFIG_FILE_PATH);
            CreeperEvolutionConfig creeperConfig = (CreeperEvolutionConfig)GSON.fromJson(json, CreeperEvolutionConfig.class);
            creeperConfig.chargedCreeperSpawnChance = class_3532.method_15363((float)creeperConfig.chargedCreeperSpawnChance, (float)0.0f, (float)1.0f);
            instance = creeperConfig;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load or create CreeperEvolutionConfig", e);
        }
    }
}

