/*
 * Decompiled with CFR 0.152.
 */
package net.noah.ironspawners.blockentities;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IronSpawnersBlockEntityBase
extends BlockEntity
implements MenuProvider {
    private int spawnDelay = 0;
    private double oSpin;
    private double spin;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            IronSpawnersBlockEntityBase.this.m_6596_();
            IronSpawnersBlockEntityBase.this.f_58857_.m_7260_(IronSpawnersBlockEntityBase.this.m_58899_(), IronSpawnersBlockEntityBase.this.m_58900_(), IronSpawnersBlockEntityBase.this.m_58900_(), 3);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            Item i = stack.m_41720_();
            return !i.equals(Items.f_220215_) && !i.equals(Items.f_42559_) && !i.equals(Items.f_254737_) && i instanceof SpawnEggItem;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public IronSpawnersBlockEntityBase(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, IronSpawnersBlockEntityBase pBaseEntity) {
        if (pLevel.m_5776_()) {
            if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
                RandomSource randomsource = pLevel.m_213780_();
                double d0 = (double)pPos.m_123341_() + randomsource.m_188500_();
                double d1 = (double)pPos.m_123342_() + randomsource.m_188500_();
                double d2 = (double)pPos.m_123343_() + randomsource.m_188500_();
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
                pBaseEntity.setOSpin(pBaseEntity.getSpin());
                pBaseEntity.setSpin((pBaseEntity.getSpin() + (double)(1000.0f / ((float)pBaseEntity.serializeNBT().m_128451_("spawnDelay") + 200.0f))) % 360.0);
            } else {
                pBaseEntity.setOSpin(pBaseEntity.getSpin());
            }
        } else {
            Item d0 = pBaseEntity.getItem();
            if (d0 instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)d0;
                if (((Boolean)pBaseEntity.m_58900_().m_61143_((Property)POWERED)).booleanValue()) {
                    pBaseEntity.setSpawnDelay(pBaseEntity.getSpawnDelay() + 1);
                    if (pBaseEntity.getSpawnDelay() >= pBaseEntity.getMaxDelay()) {
                        for (int i = 0; i < pBaseEntity.getSpawnCount(); ++i) {
                            Random r = new Random();
                            int xOffset = r.ints(-4, 5).findFirst().getAsInt();
                            int yOffset = r.ints(-4, 3).findFirst().getAsInt();
                            int zOffset = r.ints(-4, 5).findFirst().getAsInt();
                            BlockPos newPos = new BlockPos(pPos.m_123341_() + xOffset, pPos.m_123342_() + yOffset, pPos.m_123343_() + zOffset);
                            EntityType<?> entityType = pBaseEntity.getEntityType(spawnEggItem);
                            entityType.m_262496_((ServerLevel)pLevel, newPos, MobSpawnType.SPAWNER);
                        }
                        pBaseEntity.setSpawnDelay(0);
                    }
                }
            }
        }
    }

    public int getSpawnDelay() {
        return this.spawnDelay;
    }

    public void setSpawnDelay(int spawnDelay) {
        this.spawnDelay = spawnDelay;
    }

    public Item getItem() {
        return this.itemHandler.getStackInSlot(0).m_41720_();
    }

    public int getMaxDelay() {
        return 999999;
    }

    public int getSpawnCount() {
        return 0;
    }

    public EntityType<?> getEntityType(SpawnEggItem i) {
        return i.m_43228_(this.itemHandler.getStackInSlot(0).m_41783_());
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        inventory.m_6836_(0, this.itemHandler.getStackInSlot(0));
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public boolean bannedEgg(SpawnEggItem i) {
        return i.equals(Items.f_220215_) || i.equals(Items.f_42559_) || i.equals(Items.f_254737_);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("spawnDelay", this.spawnDelay);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.spawnDelay = pTag.m_128451_("spawnDelay");
    }

    public ItemStack getDisplayStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }

    public void setSpin(double _spin) {
        this.spin = _spin;
    }

    public void setOSpin(double _oSpin) {
        this.oSpin = _oSpin;
    }
}

