/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="endlessevents")
public class events18 {
    private static final Random RNG = new Random();
    private static final Map<ServerPlayer, Integer> activeProblems = new ConcurrentHashMap<ServerPlayer, Integer>();
    private static final Map<ServerPlayer, Integer> correctCount = new ConcurrentHashMap<ServerPlayer, Integer>();
    private static final Map<ServerPlayer, Integer> wrongCount = new ConcurrentHashMap<ServerPlayer, Integer>();
    private static final Map<ServerPlayer, Integer> difficultyLevel = new ConcurrentHashMap<ServerPlayer, Integer>();

    public static void trigger(Collection<ServerPlayer> players) {
        if (players == null || players.isEmpty()) {
            return;
        }
        for (ServerPlayer player : players) {
            int a;
            int level = difficultyLevel.getOrDefault(player, 1);
            int b = switch (level) {
                case 1 -> {
                    a = RNG.nextInt(10) + 1;
                    yield RNG.nextInt(10) + 1;
                }
                case 2 -> {
                    a = RNG.nextInt(16) + 5;
                    yield RNG.nextInt(16) + 5;
                }
                default -> {
                    a = RNG.nextInt(41) + 10;
                    yield RNG.nextInt(41) + 10;
                }
            };
            boolean addition = RNG.nextBoolean();
            int answer = addition ? a + b : a - b;
            activeProblems.put(player, answer);
            player.sendSystemMessage((Component)Component.literal((String)("\u0420\u0435\u0448\u0438\u0442\u0435 \u043f\u0440\u0438\u043c\u0435\u0440: " + a + (addition ? " + " : " - ") + b)).withStyle(style -> style.withColor(TextColor.fromRgb((int)65280))));
            new Thread(() -> {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (activeProblems.containsKey(player)) {
                    player.hurt(player.damageSources().magic(), player.getHealth() / 2.0f);
                    player.sendSystemMessage((Component)Component.literal((String)"\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u0448\u043b\u043e! \u0412\u044b \u043f\u043e\u0442\u0435\u0440\u044f\u043b\u0438 \u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0443 \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044f."));
                    player.level().playSound(null, player.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.PLAYERS, 1.0f, 1.0f);
                    activeProblems.remove(player);
                    wrongCount.put(player, wrongCount.getOrDefault(player, 0) + 1);
                    events18.updateDifficulty(player);
                }
            }).start();
        }
    }

    @SubscribeEvent
    public static void onPlayerChat(ServerChatEvent event) {
        ServerPlayer serverPlayer = event.getPlayer();
        if (!(serverPlayer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = serverPlayer;
        if (!activeProblems.containsKey(player)) {
            return;
        }
        String msg = event.getMessage().getString().trim();
        int correctAnswer = activeProblems.get(player);
        try {
            int playerAnswer = Integer.parseInt(msg);
            if (playerAnswer == correctAnswer) {
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0));
                player.sendSystemMessage((Component)Component.literal((String)"\u0412\u0435\u0440\u043d\u043e! \u042d\u0444\u0444\u0435\u043a\u0442 \u0440\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d."));
                player.level().playSound(null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 1.0f);
                correctCount.put(player, correctCount.getOrDefault(player, 0) + 1);
            } else {
                player.hurt(player.damageSources().magic(), player.getHealth() / 2.0f);
                player.sendSystemMessage((Component)Component.literal((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u043e! \u0412\u044b \u043f\u043e\u0442\u0435\u0440\u044f\u043b\u0438 \u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0443 \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044f."));
                player.level().playSound(null, player.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.PLAYERS, 1.0f, 1.0f);
                wrongCount.put(player, wrongCount.getOrDefault(player, 0) + 1);
            }
            events18.updateDifficulty(player);
        }
        catch (NumberFormatException e) {
            player.sendSystemMessage((Component)Component.literal((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043e\u0442\u0432\u0435\u0442\u0430! \u041d\u0443\u0436\u043d\u043e \u0447\u0438\u0441\u043b\u043e."));
        }
        activeProblems.remove(player);
        event.setCanceled(true);
    }

    private static void updateDifficulty(ServerPlayer player) {
        int correct = correctCount.getOrDefault(player, 0);
        int wrong = wrongCount.getOrDefault(player, 0);
        int level = difficultyLevel.getOrDefault(player, 1);
        if (correct > wrong) {
            level = Math.min(3, level + 1);
        } else if (wrong > correct) {
            level = Math.max(1, level - 1);
        }
        difficultyLevel.put(player, level);
    }
}

