/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class events29 {
    private static final Map<ServerPlayer, RoomFillData> playerFillData = new HashMap<ServerPlayer, RoomFillData>();

    public static void trigger(Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            int x;
            ServerLevel world = (ServerLevel)player.getCommandSenderWorld();
            BlockPos center = player.blockPosition().below(10);
            int roomRadius = 3;
            int roomHeight = 4;
            for (x = -roomRadius; x <= roomRadius; ++x) {
                for (int y = 0; y < roomHeight; ++y) {
                    for (int z = -roomRadius; z <= roomRadius; ++z) {
                        world.setBlock(center.offset(x, y, z), Blocks.AIR.defaultBlockState(), 3);
                    }
                }
            }
            for (x = -roomRadius; x <= roomRadius; ++x) {
                for (int z = -roomRadius; z <= roomRadius; ++z) {
                    world.setBlock(center.offset(x, -1, z), Blocks.STONE.defaultBlockState(), 3);
                    world.setBlock(center.offset(x, roomHeight, z), Blocks.STONE.defaultBlockState(), 3);
                }
            }
            for (int y = 0; y < roomHeight; ++y) {
                for (int i = -roomRadius; i <= roomRadius; ++i) {
                    world.setBlock(center.offset(-roomRadius, y, i), Blocks.STONE.defaultBlockState(), 3);
                    world.setBlock(center.offset(roomRadius, y, i), Blocks.STONE.defaultBlockState(), 3);
                    world.setBlock(center.offset(i, y, -roomRadius), Blocks.STONE.defaultBlockState(), 3);
                    world.setBlock(center.offset(i, y, roomRadius), Blocks.STONE.defaultBlockState(), 3);
                }
            }
            world.setBlock(center.offset(0, 1, 0), Blocks.TORCH.defaultBlockState(), 3);
            player.teleportTo((double)center.getX() + 0.5, (double)center.getY() + 0.5, (double)center.getZ() + 0.5);
            playerFillData.put(player, new RoomFillData(center, roomRadius, roomHeight));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (Map.Entry entry : playerFillData.entrySet().toArray(new Map.Entry[0])) {
            ServerPlayer player = (ServerPlayer)entry.getKey();
            RoomFillData data = (RoomFillData)entry.getValue();
            ServerLevel world = (ServerLevel)player.getCommandSenderWorld();
            if (data.currentLayer >= data.roomHeight) {
                playerFillData.remove(player);
                continue;
            }
            if (data.tickDelay < 4) {
                ++data.tickDelay;
                continue;
            }
            data.tickDelay = 0;
            BlockPos pos = data.center.offset(data.currentX, data.currentLayer, data.currentZ);
            world.setBlock(pos, Blocks.WATER.defaultBlockState(), 3);
            ++data.currentX;
            if (data.currentX <= data.roomRadius - 1) continue;
            data.currentX = -data.roomRadius + 1;
            ++data.currentZ;
            if (data.currentZ <= data.roomRadius - 1) continue;
            data.currentZ = -data.roomRadius + 1;
            ++data.currentLayer;
        }
    }

    private static class RoomFillData {
        final BlockPos center;
        final int roomHeight;
        final int roomRadius;
        int currentLayer;
        int currentX;
        int currentZ;
        int tickDelay;

        RoomFillData(BlockPos center, int roomRadius, int roomHeight) {
            this.center = center;
            this.roomRadius = roomRadius;
            this.roomHeight = roomHeight;
            this.currentLayer = 0;
            this.currentX = -roomRadius + 1;
            this.currentZ = -roomRadius + 1;
            this.tickDelay = 0;
        }
    }
}

