/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.endlessevents.randomEvents;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class events4 {
    private static final Set<LockedPos> lockedChests = Collections.synchronizedSet(new HashSet());
    private static volatile boolean listenerRegistered = false;

    public static void trigger(Collection<ServerPlayer> players) {
        if (!listenerRegistered) {
            MinecraftForge.EVENT_BUS.register((Object)new ChestListeners());
            listenerRegistered = true;
        }
        for (ServerPlayer player : players) {
            Level level = player.level();
            if (level.isClientSide()) continue;
            BlockPos pos = player.blockPosition();
            level.setBlockAndUpdate(pos, Blocks.CHEST.defaultBlockState());
            lockedChests.add(new LockedPos(level, pos));
            player.sendSystemMessage((Component)Component.literal((String)"Locked chest spawned."));
        }
    }

    public static class ChestListeners {
        private final Random rnd = ThreadLocalRandom.current();

        @SubscribeEvent
        public void onBreak(BlockEvent.BreakEvent event) {
            BlockPos pos;
            Level level = (Level)event.getLevel();
            LockedPos key = new LockedPos(level, pos = event.getPos());
            if (lockedChests.contains(key)) {
                event.setCanceled(true);
                Player player = event.getPlayer();
                if (player instanceof Player) {
                    Player p = player;
                    p.displayClientMessage((Component)Component.literal((String)"\u042d\u0442\u043e\u0442 \u0441\u0443\u043d\u0434\u0443\u043a \u043d\u0435\u043b\u044c\u0437\u044f \u043b\u043e\u043c\u0430\u0442\u044c, \u043f\u043e\u043a\u0430 \u043e\u043d \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442."), false);
                }
            }
        }

        @SubscribeEvent
        public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
            BlockPos pos;
            Level level = event.getLevel();
            LockedPos key = new LockedPos(level, pos = event.getPos());
            if (!lockedChests.contains(key)) {
                return;
            }
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (event.getHand() != InteractionHand.MAIN_HAND) {
                return;
            }
            event.setCanceled(true);
            lockedChests.remove(key);
            if (this.rnd.nextDouble() < 0.5) {
                level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0f, Level.ExplosionInteraction.BLOCK);
                player2.sendSystemMessage((Component)Component.literal((String)"\u0421\u0443\u043d\u0434\u0443\u043a \u0432\u0437\u043e\u0440\u0432\u0430\u043b\u0441\u044f!"));
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                return;
            }
            List<Reward> rewards = List.of(new Reward(new ItemStack((ItemLike)Items.DIAMOND_SWORD, 1), 10), new Reward(new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE, 1), 80), new Reward(new ItemStack((ItemLike)Items.GOLDEN_APPLE, 5), 50), new Reward(new ItemStack((ItemLike)Items.NETHERITE_SWORD, 1), 5), new Reward(new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK.asItem(), 3), 3), new Reward(new ItemStack((ItemLike)Items.TRIDENT, 1), 30), new Reward(new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING, 1), 20), new Reward(new ItemStack((ItemLike)Items.CAKE, 1), 70));
            int totalWeight = rewards.stream().mapToInt(r -> r.weight).sum();
            int pick = this.rnd.nextInt(totalWeight);
            int cursor = 0;
            ItemStack chosen = rewards.get((int)0).stack;
            for (Reward r2 : rewards) {
                if (pick >= (cursor += r2.weight)) continue;
                chosen = r2.stack;
                break;
            }
            if (!player2.getInventory().add(chosen.copy())) {
                level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, chosen.copy()));
            }
            player2.sendSystemMessage((Component)Component.literal((String)"\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043d\u0430\u0433\u0440\u0430\u0434\u0443 \u0438\u0437 \u0441\u0443\u043d\u0434\u0443\u043a\u0430."));
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }

    private static final class LockedPos {
        final Level level;
        final BlockPos pos;

        LockedPos(Level level, BlockPos pos) {
            this.level = level;
            this.pos = pos.immutable();
        }

        public int hashCode() {
            return Objects.hash(System.identityHashCode(this.level), this.pos);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LockedPos)) {
                return false;
            }
            LockedPos lp = (LockedPos)o;
            return lp.level == this.level && lp.pos.equals((Object)this.pos);
        }
    }

    private static final class Reward {
        final ItemStack stack;
        final int weight;

        Reward(ItemStack s, int w) {
            this.stack = s;
            this.weight = Math.max(0, w);
        }
    }
}

