/*
 * Decompiled with CFR 0.152.
 */
package minecraftlover.moonvent.HPHUD.config;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Properties;
import minecraftlover.moonvent.HPHUD.util.Constant;

public final class ModConfig {
    private static ModConfig instance;
    public static String outputIndicatorMode;
    public static int searchDistance;
    public static String indicatorColor;
    public static String indicatorPosition;
    public static boolean warningAfterPressMenuKey;
    public static boolean greetingsAfterEnterInWorld;
    private static final Path CONFIG_PATH;
    private Properties configProps = new Properties();

    public static ModConfig getInstance() {
        return instance;
    }

    public ModConfig() {
        instance = this;
        this.load();
    }

    private void load() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                this.save();
            } else {
                this.configProps.load(new FileInputStream(CONFIG_PATH.toFile()));
                outputIndicatorMode = this.configProps.getProperty("outputIndicatorMode", outputIndicatorMode);
                searchDistance = Integer.parseInt(this.configProps.getProperty("searchDistance", String.valueOf(searchDistance)));
                indicatorColor = this.configProps.getProperty("indicatorColor", String.valueOf(indicatorColor));
                indicatorPosition = this.configProps.getProperty("indicatorPosition", indicatorPosition);
                warningAfterPressMenuKey = Objects.equals(this.configProps.getProperty("warningAfterPressMenuKey", "1"), "1");
                greetingsAfterEnterInWorld = Objects.equals(this.configProps.getProperty("greetingsAfterEnterInWorld", "1"), "1");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            this.configProps.setProperty("outputIndicatorMode", outputIndicatorMode);
            this.configProps.setProperty("searchDistance", String.valueOf(searchDistance));
            this.configProps.setProperty("indicatorColor", String.valueOf(indicatorColor));
            this.configProps.setProperty("indicatorPosition", indicatorPosition);
            this.configProps.setProperty("warningAfterPressMenuKey", String.valueOf(warningAfterPressMenuKey ? 1 : 0));
            this.configProps.setProperty("greetingsAfterEnterInWorld", String.valueOf(greetingsAfterEnterInWorld ? 1 : 0));
            this.configProps.store(new FileOutputStream(CONFIG_PATH.toFile()), "[HPHUP]\nMod configuration file\n\nThis config sets a few detail which help you tailor the mod more for your playstyle,\nbelow, I have describe a several fields and all possible values for them,\nthis documentation should help you in configuring the mod;\nHappy configuring :)\n\n==================================================\n\noutputIndicatorMode - mod has 3 different modes to output you amount of entity health:\n\n  Available values:\n    1) currentHP - display amount of current entity HP, default value for parametr\n      Example:\n      10\n    2) currentWithMaxHP - display current hp, slash, max hp\n      Example:\n        10 / 20\n    3) currentPercentageHP - display amount of entity hp in percentage\n      Example:\n        50%\n\nsearchDistance - How far (in blocks) mod will be search entity for display amount of HP\n  Available values:\n\n    Positive Integer, 1 - 100, if set someting wrong\n  Example:\n    20\n\nindicatorColor - Color of indicator, I try a several colors, and find that pink :)\n  is more suitable for most cases, but, if you think otherwise and have a suitable replacement, let me know.\n  Our staff of one employee will check it, and if necessary, change the default color\n\n  Available values:\n    Any color in hex view, for example, and by default sets FFAFFF\n  Example:\n    FFAFFF\n\nindicatorPosition - Indicator position, now, in relation from crosshair\n\n  Available values:\n    LEFT_UPPER_NEAR_CROSSHAIR, RIGHT_UPPER_NEAR_CROSSHAIR, LEFT_BOTTOM_NEAR_CROSSHAIR, RIGHT_BOTTOM_NEAR_CROSSHAIR,\n    RIGHT_NEAR_CROSSHAIR, TOP_NEAR_CROSSHAIR, BOTTOM_NEAR_CROSSHAIR, LEFT_NEAR_CROSSHAIR\n  Example:\n    LEFT_UPPER_NEAR_CROSSHAIR\n\nwarningAfterPressMenuKey - a warning in chat, which appear when press not complete keybind for open configuration of menu\n\n  Available values:\n    1, 0\n  Example:\n    1greetingsAfterEnterInWorld - greetings in chat, after enter in the world\n\n  Available values:\n    1, 0\n  Example:\n    1Final default config example seem like that:\n\nindicatorColor=FFAFFF\nindicatorPosition=LEFT_UPPER_NEAR_CROSSHAIR\noutputIndicatorMode=currentHP\ngreetingsAfterEnterInWorld=1\nwarningAfterPressMenuKey=1\nsearchDistance=20\n\nIf something went wrong, you are set the wrong type of parametr or wrong parametr,\nmod will be use default value, which describe in a config example above\n\nThank you for playing with this mod!\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        outputIndicatorMode = "currentHP";
        searchDistance = 20;
        indicatorColor = "FFAFFF";
        indicatorPosition = "LEFT_UPPER_NEAR_CROSSHAIR";
        warningAfterPressMenuKey = true;
        greetingsAfterEnterInWorld = true;
        CONFIG_PATH = Paths.get(Constant.CONFIG_FILE_PATH, new String[0]);
    }
}

