/*
 * Decompiled with CFR 0.152.
 */
package minecraftlover.moonvent.HPHUD.mixin;

import java.util.function.Predicate;
import minecraftlover.moonvent.HPHUD.config.ModConfig;
import minecraftlover.moonvent.HPHUD.util.Constant;
import minecraftlover.moonvent.HPHUD.util.IndicatorCoordinate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public class PlayHUDMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Constant.LOGGER_HUD_NAME);
    private int maxEntityHealth;
    private String indicatorText;
    private int currentEntityHealth;
    private int maxEntityHpAmountLength;
    private int currentEntityHealthLenght;
    private ModConfig config;
    private int previousScreenWidth = 0;
    private int previousScreenHeight = 0;
    private int textWidth;
    private int textHeight;

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void render(class_332 context, float tickDelta, CallbackInfo ci) {
        class_310 minecraftClient = class_310.method_1551();
        class_327 textRenderer = minecraftClient.field_1772;
        class_437 currentScreen = minecraftClient.field_1755;
        IndicatorCoordinate indicatorCoordinate = IndicatorCoordinate.getInstance();
        if (indicatorCoordinate == null) {
            return;
        }
        this.config = ModConfig.getInstance();
        if (currentScreen != null) {
            this.previousScreenHeight = indicatorCoordinate.getCachedPlayerScreenHeight();
            this.previousScreenHeight = indicatorCoordinate.getCachedPlayerScreenWidth();
            if (this.previousScreenWidth != currentScreen.field_22789 || this.previousScreenHeight != currentScreen.field_22790) {
                indicatorCoordinate.setCachedPlayerScreen(currentScreen);
            }
        } else {
            class_1297 viewer = minecraftClient.method_1560();
            class_243 position = viewer.method_5836(tickDelta);
            class_243 look = viewer.method_5828(1.0f);
            class_243 max = position.method_1031(look.field_1352 * (double)ModConfig.searchDistance, look.field_1351 * (double)ModConfig.searchDistance, look.field_1350 * (double)ModConfig.searchDistance);
            class_238 searchBox = viewer.method_5829().method_18804(look.method_1021((double)ModConfig.searchDistance)).method_1009(1.0, 1.0, 1.0);
            Predicate<class_1297> isPositive = entity -> true;
            class_3966 result = class_1675.method_18075((class_1297)viewer, (class_243)position, (class_243)max, (class_238)searchBox, isPositive, (double)(ModConfig.searchDistance * ModConfig.searchDistance));
            if (result != null && result.method_17782() instanceof class_1309) {
                class_1309 target = (class_1309)result.method_17782();
                this.getTextForIndicator(target);
                if (this.indicatorText == null) {
                    return;
                }
                this.textWidth = textRenderer.method_1727(this.indicatorText);
                this.textHeight = textRenderer.method_1713(this.indicatorText, this.textWidth);
                context.method_51433(textRenderer, this.indicatorText, indicatorCoordinate.getX() - this.textWidth / 2, indicatorCoordinate.getY() - this.textHeight / 2, Integer.parseInt(ModConfig.indicatorColor, 16), true);
            }
        }
    }

    private void getTextForIndicator(class_1309 entity) {
        this.maxEntityHealth = (int)entity.method_6063();
        this.currentEntityHealth = (int)Math.ceil(entity.method_6032());
        this.maxEntityHpAmountLength = Integer.toString(this.maxEntityHealth).length();
        this.currentEntityHealthLenght = Integer.toString(this.currentEntityHealth).length();
        if (this.currentEntityHealth == 0) {
            this.indicatorText = null;
            return;
        }
        switch (ModConfig.outputIndicatorMode) {
            case "currentWithMaxHP": {
                this.indicatorText = String.format("%s / %s", this.currentEntityHealth, this.maxEntityHealth);
                break;
            }
            case "currentPercentageHP": {
                this.indicatorText = String.format("%s %%", (int)Math.ceil((double)((float)this.currentEntityHealth / (float)this.maxEntityHealth) * 100.0));
                break;
            }
            default: {
                this.indicatorText = String.format("%s", this.currentEntityHealth);
            }
        }
        if (this.currentEntityHealthLenght < this.maxEntityHpAmountLength) {
            this.indicatorText = String.format("%" + (this.maxEntityHpAmountLength - this.currentEntityHealthLenght) + "s%s", "", this.indicatorText);
        }
    }
}

