/*
 * Decompiled with CFR 0.152.
 */
package cyb0124.curvy_pipes.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import cyb0124.curvy_pipes.client.BaseScreen;
import cyb0124.curvy_pipes.client.GuiContext;
import cyb0124.curvy_pipes.client.MiscRenderTypes;
import cyb0124.curvy_pipes.common.BaseMenu;
import cyb0124.curvy_pipes.common.CommonHandler;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.vertices.ImmediateState;
import net.minecraft.block.Blocks;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class ClientHandler {
    private static boolean TRY_IRIS = true;
    static final FloatBuffer TRANSFORMS = BufferUtils.createFloatBuffer((int)32);
    public static float partialTick;

    static native String[] builtInTextures();

    private static native void loadSprites(AtlasTexture var0);

    static native void renderPipeItem(Matrix3f var0, int var1, int var2, int var3, int var4);

    private static native void renderLevel(double var0, double var2, double var4, Matrix3f var6, boolean var7, boolean var8, int var9, int var10, int var11, int var12, double var13, float var15, int var16, int var17);

    private static native void renderTranslucent();

    private static native void renderGui(GuiContext var0);

    private static native void tick();

    private static native boolean interact(RayTraceResult var0, boolean var1);

    static boolean syncIris() {
        boolean wasExtended = false;
        if (TRY_IRIS) {
            try {
                wasExtended = ImmediateState.renderWithExtendedVertexFormat;
                ImmediateState.renderWithExtendedVertexFormat = false;
                Iris.getPipelineManager().getPipeline().ifPresent(WorldRenderingPipeline::syncProgram);
            }
            catch (NoClassDefFoundError ignored) {
                TRY_IRIS = false;
            }
        }
        return wasExtended;
    }

    static void drawImmediate(RenderType type, ByteBuffer elems, long vb, boolean syncIris) {
        GL15.glBindBuffer((int)34962, (int)0);
        type.func_228547_a_();
        VertexFormat fmt = type.func_228663_p_();
        boolean wasExtended = syncIris && ClientHandler.syncIris();
        fmt.func_227892_a_(vb);
        GL11.glDrawElements((int)4, (IntBuffer)elems.asIntBuffer());
        fmt.func_227895_d_();
        if (wasExtended) {
            ImmediateState.renderWithExtendedVertexFormat = true;
        }
        type.func_228549_b_();
    }

    private static void drawImmediate(int type, ByteBuffer elems, long vb) {
        ClientHandler.drawImmediate(MiscRenderTypes.TYPES[type], elems, vb, true);
    }

    private static void drawCrumble(float pct, ByteBuffer elems, long vb) {
        int n = ModelBakery.field_229320_k_.size();
        ClientHandler.drawImmediate((RenderType)ModelBakery.field_229320_k_.get(Math.min((int)(pct * (float)n), n - 1)), elems, vb, true);
    }

    private static void spawnPipeEffects(double[] coords, SoundEvent sound, Consumer<Vector3d> makeParticle) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        Vector3d bestPos = null;
        double bestDist = 0.0;
        int i = 0;
        while (i != coords.length) {
            Vector3d pos = new Vector3d(coords[i++], coords[i++], coords[i++]);
            double dist = pos.func_72436_e(mc.field_71439_g.func_213303_ch());
            if (bestPos == null || dist < bestDist) {
                bestPos = pos;
                bestDist = dist;
            }
            makeParticle.accept(pos);
        }
        mc.field_71441_e.func_184134_a(bestPos.field_72450_a, bestPos.field_72448_b, bestPos.field_72449_c, sound, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
    }

    private static void spawnBreakEffects(double[] coords, final float u0, final float v0, final float u1, final float v1, float r, float g, float b) {
        ClientHandler.spawnPipeEffects(coords, SoundEvents.field_187835_fT, pos -> {
            Minecraft mc = Minecraft.func_71410_x();
            DiggingParticle particle = new DiggingParticle(mc.field_71441_e, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, Blocks.field_150348_b.func_176223_P()){
                final float uRand;
                final float vRand;
                {
                    super(x0, x1, x2, x3, x4, x5, x6, x7);
                    this.uRand = this.field_187136_p.nextFloat() * 3.0f;
                    this.vRand = this.field_187136_p.nextFloat() * 3.0f;
                }

                protected float func_217563_c() {
                    return u0 + (u1 - u0) * (this.uRand + 1.0f) / 4.0f;
                }

                protected float func_217562_e() {
                    return v0 + (v1 - v0) * this.vRand / 4.0f;
                }

                protected float func_217564_d() {
                    return u0 + (u1 - u0) * this.uRand / 4.0f;
                }

                protected float func_217560_f() {
                    return v0 + (v1 - v0) * (this.vRand + 1.0f) / 4.0f;
                }
            };
            particle.func_174845_l();
            particle.func_70538_b(r, g, b);
            mc.field_71452_i.func_78873_a((Particle)particle);
        });
    }

    private static void spawnBurnEffects(double[] coords) {
        ClientHandler.spawnPipeEffects(coords, SoundEvents.field_187659_cY, pos -> Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197595_F, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 5.0E-5, 0.0));
    }

    private static void swingHand() {
        Minecraft.func_71410_x().field_71439_g.func_184609_a(Hand.MAIN_HAND);
    }

    private static int queryLight(int x, int y, int z) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = new BlockPos(x, y, z);
        int block = world.func_226658_a_(LightType.BLOCK, pos);
        int sky = world.func_226658_a_(LightType.SKY, pos);
        return LightTexture.func_228451_a_((int)block, (int)sky);
    }

    private static boolean queryLight(int[] data) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        int i = 0;
        while (i != data.length) {
            int sky;
            BlockPos pos;
            int block;
            if (LightTexture.func_228451_a_((int)(block = world.func_226658_a_(LightType.BLOCK, pos = new BlockPos(data[i++], data[i++], data[i++]))), (int)(sky = world.func_226658_a_(LightType.SKY, pos))) == data[i++]) continue;
            return true;
        }
        return false;
    }

    private static int countStacks(Item item) {
        return CommonHandler.countStacks(CommonHandler.gatherStacks((PlayerEntity)Minecraft.func_71410_x().field_71439_g, item));
    }

    private static String dim() {
        return Minecraft.func_71410_x().field_71441_e.func_234923_W_().func_240901_a_().toString();
    }

    private static void playClickSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    private static double[] getOutlineBoxes(int x, int y, int z) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = new BlockPos(x, y, z);
        return CommonHandler.getOutlineBoxes(pos, world.func_180495_p(pos), (World)world);
    }

    private static double[] getExtOutlineBoxes(int x0, int y0, int z0) {
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        DoubleArrayList boxes = new DoubleArrayList();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    int x = x0 + i;
                    int y = y0 + j;
                    int z = z0 + k;
                    BlockPos pos = new BlockPos(x, y, z);
                    level.func_180495_p(pos).func_196954_c((IBlockReader)level, pos).func_197755_b((xn, yn, zn, xp, yp, zp) -> {
                        boxes.add(xn + (double)x);
                        boxes.add(yn + (double)y);
                        boxes.add(zn + (double)z);
                        boxes.add(xp + (double)x);
                        boxes.add(yp + (double)y);
                        boxes.add(zp + (double)z);
                    });
                }
            }
        }
        return boxes.toDoubleArray();
    }

    private static IRenderTypeBuffer.Impl immediateBuffer() {
        return IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
    }

    public static void renderLevel(RenderType type, MatrixStack poseStack, double x, double y, double z) {
        if (type == RenderType.func_228641_d_()) {
            Minecraft mc = Minecraft.func_71410_x();
            MainWindow fb = mc.func_228018_at_();
            ItemStack mainHand = ItemStack.field_190927_a;
            ItemStack offHand = ItemStack.field_190927_a;
            if (mc.field_71439_g != null) {
                mainHand = mc.field_71439_g.func_184614_ca();
                offHand = mc.field_71439_g.func_184592_cb();
            }
            TRANSFORMS.position(0);
            GL11.glGetFloatv((int)2983, (FloatBuffer)TRANSFORMS);
            TRANSFORMS.position(16);
            MatrixStack.Entry pose = poseStack.func_227866_c_();
            pose.func_227870_a_().func_195879_b(TRANSFORMS.slice());
            if (mc.field_71441_e.func_239132_a_().func_239217_c_()) {
                RenderHelper.func_237533_a_((Matrix4f)pose.func_227870_a_());
            } else {
                RenderHelper.func_227781_a_((Matrix4f)pose.func_227870_a_());
            }
            boolean shadow = false;
            if (TRY_IRIS) {
                try {
                    shadow = ShadowRenderer.ACTIVE;
                }
                catch (NoClassDefFoundError ignored) {
                    TRY_IRIS = false;
                }
            }
            ClientHandler.renderLevel(x, y, z, pose.func_227872_b_(), shadow, mc.field_71474_y.field_151444_V.func_151470_d(), fb.func_198105_m(), fb.func_198083_n(), fb.func_198109_k(), fb.func_198091_l(), fb.func_198100_s(), partialTick, CommonHandler.itemId(mainHand), CommonHandler.itemId(offHand));
        } else if (type == RenderType.func_241715_r_()) {
            ClientHandler.renderTranslucent();
        }
    }

    public static void renderGui(RenderGameOverlayEvent.Pre evt) {
        if (evt.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ClientHandler.renderGui(new GuiContext(evt.getMatrixStack()));
        }
    }

    public static void onPreStitch(TextureStitchEvent.Pre evt) {
        if (evt.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            for (String sprite : ClientHandler.builtInTextures()) {
                evt.addSprite(new ResourceLocation(sprite));
            }
        }
    }

    public static void onPostStitch(TextureStitchEvent.Post evt) {
        AtlasTexture atlas = evt.getMap();
        if (atlas.func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            ClientHandler.loadSprites(atlas);
        }
    }

    public static void onTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            ClientHandler.tick();
        }
    }

    public static void onInteract(InputEvent.ClickInputEvent evt) {
        if (!evt.isUseItem()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71476_x != null && ClientHandler.interact(mc.field_71476_x, mc.field_71474_y.field_228046_af_.func_151470_d())) {
            evt.setSwingHand(true);
            evt.setCanceled(true);
        }
    }

    public static void onClientSetup(FMLClientSetupEvent evt) {
        evt.enqueueWork(() -> ScreenManager.func_216911_a(BaseMenu.TYPE, BaseScreen::new));
    }
}

