/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.ArrowFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.CustomFunction;
import dev.latvian.mods.rhino.CustomProperty;
import dev.latvian.mods.rhino.EvaluatorException;
import dev.latvian.mods.rhino.FieldAndMethods;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.InterfaceAdapter;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.NativeDate;
import dev.latvian.mods.rhino.NativeFunction;
import dev.latvian.mods.rhino.NativeJavaArray;
import dev.latvian.mods.rhino.NativeJavaClass;
import dev.latvian.mods.rhino.NativeObject;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Symbol;
import dev.latvian.mods.rhino.SymbolKey;
import dev.latvian.mods.rhino.SymbolScriptable;
import dev.latvian.mods.rhino.TopLevel;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.util.Deletable;
import dev.latvian.mods.rhino.util.JavaIteratorWrapper;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class NativeJavaObject
implements Scriptable,
SymbolScriptable,
Wrapper {
    static final byte CONVERSION_TRIVIAL = 1;
    static final byte CONVERSION_NONTRIVIAL = 0;
    static final byte CONVERSION_NONE = 99;
    private static final Object COERCED_INTERFACE_KEY = "Coerced Interface";
    private static final int JSTYPE_UNDEFINED = 0;
    private static final int JSTYPE_NULL = 1;
    private static final int JSTYPE_BOOLEAN = 2;
    private static final int JSTYPE_NUMBER = 3;
    private static final int JSTYPE_STRING = 4;
    private static final int JSTYPE_JAVA_CLASS = 5;
    private static final int JSTYPE_JAVA_OBJECT = 6;
    private static final int JSTYPE_JAVA_ARRAY = 7;
    private static final int JSTYPE_OBJECT = 8;
    protected Scriptable prototype;
    protected Scriptable parent;
    protected transient Object javaObject;
    protected transient Class<?> staticType;
    protected transient JavaMembers members;
    protected transient Map<String, FieldAndMethods> fieldAndMethods;
    protected transient Map<String, Object> customMembers;
    protected transient boolean isAdapter;

    public static boolean canConvert(Context cx, Object fromObj, Class<?> to) {
        return NativeJavaObject.getConversionWeight(cx, fromObj, to) < 99;
    }

    static int getConversionWeight(Context cx, Object fromObj, Class<?> to) {
        if (cx.hasTypeWrappers() && cx.getTypeWrappers().getWrapperFactory(to, fromObj) != null) {
            return 0;
        }
        int fromCode = NativeJavaObject.getJSTypeCode(fromObj);
        switch (fromCode) {
            case 0: {
                if (to != ScriptRuntime.StringClass && to != ScriptRuntime.ObjectClass) break;
                return 1;
            }
            case 1: {
                if (to.isPrimitive()) break;
                return 1;
            }
            case 2: {
                if (to == Boolean.TYPE) {
                    return 1;
                }
                if (to == ScriptRuntime.BooleanClass) {
                    return 2;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (to != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 3: {
                if (to.isPrimitive()) {
                    if (to == Double.TYPE) {
                        return 1;
                    }
                    if (to == Boolean.TYPE) break;
                    return 1 + NativeJavaObject.getSizeRank(to);
                }
                if (to == ScriptRuntime.StringClass) {
                    return 9;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    return 10;
                }
                if (!ScriptRuntime.NumberClass.isAssignableFrom(to)) break;
                return 2;
            }
            case 4: {
                if (to == ScriptRuntime.StringClass) {
                    return 1;
                }
                if (to.isInstance(fromObj)) {
                    return 2;
                }
                if (!to.isPrimitive()) break;
                if (to == Character.TYPE) {
                    return 3;
                }
                if (to == Boolean.TYPE) break;
                return 4;
            }
            case 5: {
                if (to == ScriptRuntime.ClassClass) {
                    return 1;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (to != ScriptRuntime.StringClass) break;
                return 4;
            }
            case 6: 
            case 7: {
                Object javaObj = fromObj;
                if (javaObj instanceof Wrapper) {
                    javaObj = ((Wrapper)javaObj).unwrap();
                }
                if (to.isInstance(javaObj)) {
                    return 0;
                }
                if (to == ScriptRuntime.StringClass) {
                    return 2;
                }
                if (!to.isPrimitive() || to == Boolean.TYPE) break;
                return fromCode == 7 ? 99 : 2 + NativeJavaObject.getSizeRank(to);
            }
            case 8: {
                if (to != ScriptRuntime.ObjectClass && to.isInstance(fromObj)) {
                    return 1;
                }
                if (to.isArray()) {
                    if (!(fromObj instanceof NativeArray)) break;
                    return 2;
                }
                if (to == ScriptRuntime.ObjectClass) {
                    return 3;
                }
                if (to == ScriptRuntime.StringClass) {
                    return 4;
                }
                if (to == ScriptRuntime.DateClass) {
                    if (!(fromObj instanceof NativeDate)) break;
                    return 1;
                }
                if (to.isInterface()) {
                    if (fromObj instanceof NativeFunction) {
                        return 1;
                    }
                    if (fromObj instanceof NativeObject) {
                        return 2;
                    }
                    return 12;
                }
                if (!to.isPrimitive() || to == Boolean.TYPE) break;
                return 4 + NativeJavaObject.getSizeRank(to);
            }
        }
        return 99;
    }

    static int getSizeRank(Class<?> aType) {
        if (aType == Double.TYPE) {
            return 1;
        }
        if (aType == Float.TYPE) {
            return 2;
        }
        if (aType == Long.TYPE) {
            return 3;
        }
        if (aType == Integer.TYPE) {
            return 4;
        }
        if (aType == Short.TYPE) {
            return 5;
        }
        if (aType == Character.TYPE) {
            return 6;
        }
        if (aType == Byte.TYPE) {
            return 7;
        }
        if (aType == Boolean.TYPE) {
            return 99;
        }
        return 8;
    }

    private static int getJSTypeCode(Object value) {
        if (value == null) {
            return 1;
        }
        if (value == Undefined.instance) {
            return 0;
        }
        if (value instanceof CharSequence) {
            return 4;
        }
        if (value instanceof Number) {
            return 3;
        }
        if (value instanceof Boolean) {
            return 2;
        }
        if (value instanceof Scriptable) {
            if (value instanceof NativeJavaClass) {
                return 5;
            }
            if (value instanceof NativeJavaArray) {
                return 7;
            }
            if (value instanceof Wrapper) {
                return 6;
            }
            return 8;
        }
        if (value instanceof Class) {
            return 5;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            return 7;
        }
        return 6;
    }

    static Object coerceTypeImpl(@Nullable TypeWrappers typeWrappers, Class<?> type, Object value, Context cx) {
        TypeWrapperFactory<?> typeWrapper;
        if (value == null || value.getClass() == type) {
            return value;
        }
        Object unwrappedValue = Wrapper.unwrapped(value);
        TypeWrapperFactory<?> typeWrapperFactory = typeWrapper = typeWrappers == null ? null : typeWrappers.getWrapperFactory(type, unwrappedValue);
        if (typeWrapper != null) {
            return typeWrapper.wrap(cx, unwrappedValue);
        }
        switch (NativeJavaObject.getJSTypeCode(value)) {
            case 1: {
                if (type.isPrimitive()) {
                    return NativeJavaObject.reportConversionError(value, type, cx);
                }
                return null;
            }
            case 0: {
                if (type == ScriptRuntime.StringClass || type == ScriptRuntime.ObjectClass) {
                    return "undefined";
                }
                return NativeJavaObject.reportConversionError("undefined", type, value, cx);
            }
            case 2: {
                if (type == Boolean.TYPE || type == ScriptRuntime.BooleanClass || type == ScriptRuntime.ObjectClass) {
                    return value;
                }
                if (type == ScriptRuntime.StringClass) {
                    return value.toString();
                }
                return NativeJavaObject.reportConversionError(value, type, cx);
            }
            case 3: {
                if (type == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(cx, value);
                }
                if (type == ScriptRuntime.ObjectClass) {
                    return NativeJavaObject.coerceToNumber(Double.TYPE, value, cx);
                }
                if (type.isPrimitive() && type != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(type)) {
                    return NativeJavaObject.coerceToNumber(type, value, cx);
                }
                return NativeJavaObject.reportConversionError(value, type, cx);
            }
            case 4: {
                if (type == ScriptRuntime.StringClass || type.isInstance(value)) {
                    return value.toString();
                }
                if (type == Character.TYPE || type == ScriptRuntime.CharacterClass) {
                    if (((CharSequence)value).length() == 1) {
                        return Character.valueOf(((CharSequence)value).charAt(0));
                    }
                    return NativeJavaObject.coerceToNumber(type, value, cx);
                }
                if (type.isPrimitive() && type != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(type)) {
                    return NativeJavaObject.coerceToNumber(type, value, cx);
                }
                return NativeJavaObject.reportConversionError(value, type, cx);
            }
            case 5: {
                if (type == ScriptRuntime.ClassClass || type == ScriptRuntime.ObjectClass) {
                    return unwrappedValue;
                }
                if (type == ScriptRuntime.StringClass) {
                    return unwrappedValue.toString();
                }
                return NativeJavaObject.reportConversionError(unwrappedValue, type, cx);
            }
            case 6: 
            case 7: {
                if (type.isPrimitive()) {
                    if (type == Boolean.TYPE) {
                        return NativeJavaObject.reportConversionError(unwrappedValue, type, cx);
                    }
                    return NativeJavaObject.coerceToNumber(type, unwrappedValue, cx);
                }
                if (type == ScriptRuntime.StringClass) {
                    return unwrappedValue.toString();
                }
                if (type.isInstance(unwrappedValue)) {
                    return unwrappedValue;
                }
                return NativeJavaObject.reportConversionError(unwrappedValue, type, cx);
            }
            case 8: {
                if (type == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(cx, value);
                }
                if (type.isPrimitive()) {
                    if (type == Boolean.TYPE) {
                        return NativeJavaObject.reportConversionError(value, type, cx);
                    }
                    return NativeJavaObject.coerceToNumber(type, value, cx);
                }
                if (type.isInstance(value)) {
                    return value;
                }
                if (type == ScriptRuntime.DateClass && value instanceof NativeDate) {
                    double time = ((NativeDate)value).getJSTimeValue();
                    return new Date((long)time);
                }
                if (type.isArray() && value instanceof NativeArray) {
                    NativeArray array = (NativeArray)value;
                    long length = array.getLength();
                    Class<?> arrayType = type.getComponentType();
                    Object Result = Array.newInstance(arrayType, (int)length);
                    int i = 0;
                    while ((long)i < length) {
                        try {
                            Array.set(Result, i, NativeJavaObject.coerceTypeImpl(typeWrappers, arrayType, array.get(cx, i, (Scriptable)array), cx));
                        }
                        catch (EvaluatorException ee) {
                            return NativeJavaObject.reportConversionError(value, type, cx);
                        }
                        ++i;
                    }
                    return Result;
                }
                if (value instanceof Wrapper) {
                    if (type.isInstance(unwrappedValue)) {
                        return unwrappedValue;
                    }
                    return NativeJavaObject.reportConversionError(unwrappedValue, type, cx);
                }
                if (type.isInterface() && (value instanceof NativeObject || value instanceof NativeFunction || value instanceof ArrowFunction)) {
                    return NativeJavaObject.createInterfaceAdapter(cx, type, (ScriptableObject)value);
                }
                return NativeJavaObject.reportConversionError(value, type, cx);
            }
        }
        return value;
    }

    public static Object createInterfaceAdapter(Context cx, Class<?> type, ScriptableObject so) {
        Object key = Kit.makeHashKeyFromPair(COERCED_INTERFACE_KEY, type);
        Object old = so.getAssociatedValue(key);
        if (old != null) {
            return old;
        }
        Object glue = InterfaceAdapter.create(cx, type, so);
        glue = so.associateValue(key, glue);
        return glue;
    }

    private static Object coerceToNumber(Class<?> type, Object value, Context cx) {
        Class<?> valueClass = value.getClass();
        if (type == Character.TYPE || type == ScriptRuntime.CharacterClass) {
            if (valueClass == ScriptRuntime.CharacterClass) {
                return value;
            }
            return Character.valueOf((char)NativeJavaObject.toInteger(value, ScriptRuntime.CharacterClass, 0.0, 65535.0, cx));
        }
        if (type == ScriptRuntime.ObjectClass || type == ScriptRuntime.DoubleClass || type == Double.TYPE) {
            return valueClass == ScriptRuntime.DoubleClass ? value : Double.valueOf(NativeJavaObject.toDouble(value, cx));
        }
        if (type == ScriptRuntime.FloatClass || type == Float.TYPE) {
            if (valueClass == ScriptRuntime.FloatClass) {
                return value;
            }
            double number = NativeJavaObject.toDouble(value, cx);
            if (Double.isInfinite(number) || Double.isNaN(number) || number == 0.0) {
                return Float.valueOf((float)number);
            }
            double absNumber = Math.abs(number);
            if (absNumber < (double)1.4E-45f) {
                return Float.valueOf(number > 0.0 ? 0.0f : -0.0f);
            }
            if (absNumber > 3.4028234663852886E38) {
                return Float.valueOf(number > 0.0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
            }
            return Float.valueOf((float)number);
        }
        if (type == ScriptRuntime.IntegerClass || type == Integer.TYPE) {
            if (valueClass == ScriptRuntime.IntegerClass) {
                return value;
            }
            return (int)NativeJavaObject.toInteger(value, ScriptRuntime.IntegerClass, -2.147483648E9, 2.147483647E9, cx);
        }
        if (type == ScriptRuntime.LongClass || type == Long.TYPE) {
            if (valueClass == ScriptRuntime.LongClass) {
                return value;
            }
            double max = Double.longBitsToDouble(4890909195324358655L);
            double min = Double.longBitsToDouble(-4332462841530417152L);
            return NativeJavaObject.toInteger(value, ScriptRuntime.LongClass, min, max, cx);
        }
        if (type == ScriptRuntime.ShortClass || type == Short.TYPE) {
            if (valueClass == ScriptRuntime.ShortClass) {
                return value;
            }
            return (short)NativeJavaObject.toInteger(value, ScriptRuntime.ShortClass, -32768.0, 32767.0, cx);
        }
        if (type == ScriptRuntime.ByteClass || type == Byte.TYPE) {
            if (valueClass == ScriptRuntime.ByteClass) {
                return value;
            }
            return (byte)NativeJavaObject.toInteger(value, ScriptRuntime.ByteClass, -128.0, 127.0, cx);
        }
        return NativeJavaObject.toDouble(value, cx);
    }

    private static double toDouble(Object value, Context cx) {
        Method meth;
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return ScriptRuntime.toNumber(cx, (String)value);
        }
        if (value instanceof Scriptable) {
            if (value instanceof Wrapper) {
                return NativeJavaObject.toDouble(((Wrapper)value).unwrap(), cx);
            }
            return ScriptRuntime.toNumber(cx, value);
        }
        try {
            meth = value.getClass().getMethod("doubleValue", null);
        }
        catch (NoSuchMethodException e) {
            meth = null;
        }
        catch (SecurityException e) {
            meth = null;
        }
        if (meth != null) {
            try {
                return ((Number)meth.invoke(value, (Object[])null)).doubleValue();
            }
            catch (IllegalAccessException e) {
                NativeJavaObject.reportConversionError(value, Double.TYPE, cx);
            }
            catch (InvocationTargetException e) {
                NativeJavaObject.reportConversionError(value, Double.TYPE, cx);
            }
        }
        return ScriptRuntime.toNumber(cx, value.toString());
    }

    private static long toInteger(Object value, Class<?> type, double min, double max, Context cx) {
        double d = NativeJavaObject.toDouble(value, cx);
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(cx, value), type, cx);
        }
        if ((d = d > 0.0 ? Math.floor(d) : Math.ceil(d)) < min || d > max) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(cx, value), type, cx);
        }
        return (long)d;
    }

    static Object reportConversionError(Object value, Class<?> type, Context cx) {
        return NativeJavaObject.reportConversionError(value, type, value, cx);
    }

    static Object reportConversionError(Object value, Class<?> type, Object stringValue, Context cx) {
        throw Context.reportRuntimeError2("msg.conversion.not.allowed", String.valueOf(stringValue), JavaMembers.javaSignature(type), cx);
    }

    public NativeJavaObject() {
    }

    public NativeJavaObject(Scriptable scope, Object javaObject, Class<?> staticType, Context cx) {
        this(scope, javaObject, staticType, false, cx);
    }

    public NativeJavaObject(Scriptable scope, Object javaObject, Class<?> staticType, boolean isAdapter, Context cx) {
        this.parent = scope;
        this.javaObject = javaObject;
        this.staticType = staticType;
        this.isAdapter = isAdapter;
        this.initMembers(cx, scope);
    }

    protected void initMembers(Context cx, Scriptable scope) {
        Class<?> dynamicType = this.javaObject != null ? this.javaObject.getClass() : this.staticType;
        this.members = JavaMembers.lookupClass(cx, scope, dynamicType, this.staticType, this.isAdapter);
        this.fieldAndMethods = this.members.getFieldAndMethodsObjects(this, this.javaObject, false, cx);
        this.customMembers = null;
    }

    protected void addCustomMember(String name, Object fm) {
        if (this.customMembers == null) {
            this.customMembers = new HashMap<String, Object>();
        }
        this.customMembers.put(name, fm);
    }

    protected void addCustomFunction(String name, CustomFunction.Func func, Class<?> ... argTypes) {
        this.addCustomMember(name, new CustomFunction(name, func, argTypes));
    }

    protected void addCustomFunction(String name, CustomFunction.NoArgFunc func) {
        this.addCustomFunction(name, func, CustomFunction.NO_ARGS);
    }

    public void addCustomProperty(String name, CustomProperty getter) {
        this.addCustomMember(name, getter);
    }

    @Override
    public boolean has(Context cx, String name, Scriptable start) {
        return this.members.has(name, false) || this.customMembers != null && this.customMembers.containsKey(name);
    }

    @Override
    public boolean has(Context cx, int index, Scriptable start) {
        return false;
    }

    @Override
    public boolean has(Context cx, Symbol key, Scriptable start) {
        return this.javaObject instanceof Iterable && SymbolKey.ITERATOR.equals(key);
    }

    @Override
    public Object get(Context cx, String name, Scriptable start) {
        Object result;
        if (this.fieldAndMethods != null && (result = this.fieldAndMethods.get(name)) != null) {
            return result;
        }
        if (this.customMembers != null && (result = this.customMembers.get(name)) != null) {
            if (result instanceof CustomProperty) {
                Object r = ((CustomProperty)result).get(cx);
                if (r == null) {
                    return Undefined.instance;
                }
                Object r1 = cx.getWrapFactory().wrap(cx, this, r, r.getClass());
                if (r1 instanceof Scriptable) {
                    return ((Scriptable)r1).getDefaultValue(cx, null);
                }
                return r1;
            }
            return result;
        }
        return this.members.get(this, name, this.javaObject, false, cx);
    }

    @Override
    public Object get(Context cx, Symbol key, Scriptable start) {
        Object object = this.javaObject;
        if (object instanceof Iterable) {
            Iterable itr = (Iterable)object;
            if (SymbolKey.ITERATOR.equals(key)) {
                return new JavaIteratorWrapper(itr.iterator());
            }
        }
        return Scriptable.NOT_FOUND;
    }

    @Override
    public Object get(Context cx, int index, Scriptable start) {
        throw this.members.reportMemberNotFound(Integer.toString(index), cx);
    }

    @Override
    public void put(Context cx, String name, Scriptable start, Object value) {
        if (this.prototype == null || this.members.has(name, false)) {
            this.members.put(this, name, this.javaObject, value, false, cx);
        } else {
            this.prototype.put(cx, name, this.prototype, value);
        }
    }

    @Override
    public void put(Context cx, Symbol symbol, Scriptable start, Object value) {
        String name = symbol.toString();
        if (this.prototype == null || this.members.has(name, false)) {
            this.members.put(this, name, this.javaObject, value, false, cx);
        } else if (this.prototype instanceof SymbolScriptable) {
            ((SymbolScriptable)((Object)this.prototype)).put(cx, symbol, this.prototype, value);
        }
    }

    @Override
    public void put(Context cx, int index, Scriptable start, Object value) {
        throw this.members.reportMemberNotFound(Integer.toString(index), cx);
    }

    @Override
    public boolean hasInstance(Context cx, Scriptable value) {
        return false;
    }

    @Override
    public void delete(Context cx, String name) {
        Object result;
        if (this.fieldAndMethods != null && (result = this.fieldAndMethods.get(name)) != null) {
            Deletable.deleteObject(result);
            return;
        }
        if (this.customMembers != null && (result = this.customMembers.get(name)) != null) {
            Deletable.deleteObject(result);
            return;
        }
        Deletable.deleteObject(this.members.get(this, name, this.javaObject, false, cx));
    }

    @Override
    public void delete(Context cx, Symbol key) {
    }

    @Override
    public void delete(Context cx, int index) {
    }

    @Override
    public Scriptable getPrototype(Context cx) {
        if (this.prototype == null && this.javaObject instanceof String) {
            return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(this.parent), TopLevel.Builtins.String, cx);
        }
        return this.prototype;
    }

    @Override
    public void setPrototype(Scriptable m) {
        this.prototype = m;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parent;
    }

    @Override
    public void setParentScope(Scriptable m) {
        this.parent = m;
    }

    @Override
    public Object[] getIds(Context cx) {
        if (this.customMembers != null) {
            Object[] c = this.customMembers.keySet().toArray(ScriptRuntime.EMPTY_OBJECTS);
            Object[] m = this.members.getIds(false);
            Object[] result = new Object[c.length + m.length];
            System.arraycopy(c, 0, result, 0, c.length);
            System.arraycopy(m, 0, result, c.length, m.length);
            return result;
        }
        return this.members.getIds(false);
    }

    @Override
    public Object unwrap() {
        return this.javaObject;
    }

    @Override
    public String getClassName() {
        return "JavaObject";
    }

    @Override
    public Object getDefaultValue(Context cx, Class<?> hint) {
        Object value;
        if (hint == null) {
            if (this.javaObject instanceof Boolean) {
                hint = ScriptRuntime.BooleanClass;
            }
            if (this.javaObject instanceof Number) {
                hint = ScriptRuntime.NumberClass;
            }
        }
        if (hint == null || hint == ScriptRuntime.StringClass) {
            value = this.javaObject.toString();
        } else {
            String converterName;
            if (hint == ScriptRuntime.BooleanClass) {
                converterName = "booleanValue";
            } else if (hint == ScriptRuntime.NumberClass) {
                converterName = "doubleValue";
            } else {
                throw Context.reportRuntimeError0("msg.default.value", cx);
            }
            Object converterObject = this.get(cx, converterName, (Scriptable)this);
            if (converterObject instanceof Function) {
                Function f = (Function)converterObject;
                value = f.call(cx, f.getParentScope(), this, ScriptRuntime.EMPTY_OBJECTS);
            } else {
                boolean b;
                value = hint == ScriptRuntime.NumberClass && this.javaObject instanceof Boolean ? ((b = ((Boolean)this.javaObject).booleanValue()) ? (Number)ScriptRuntime.wrapNumber(1.0) : (Number)ScriptRuntime.zeroObj) : this.javaObject.toString();
            }
        }
        return value;
    }
}

