/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.living.model;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Consumer;
import java.util.function.Function;
import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.client.living.CustomKubeJSEntityRenderer;
import net.liopyu.entityjs.client.living.model.CustomGeoLayerJS;
import net.liopyu.entityjs.client.living.model.CustomGlowingGeoLayerJS;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJSCustom;
import net.liopyu.entityjs.entities.living.entityjs.WrappedAnimatableEntity;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.implementation.ILivingEntityJS;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CustomGeoLayerJSBuilder<T extends LivingEntity> {
    public transient Function<T, Object> textureResource;
    public CustomEntityJSBuilder builder;
    public transient Consumer<ContextUtils.PreRenderContext<T>> render;
    public transient Consumer<ContextUtils.PreRenderContext<T>> preRender;

    public CustomGeoLayerJSBuilder(CustomEntityJSBuilder builder) {
        this.builder = builder;
    }

    public CustomGeoLayerJS<T> build(CustomKubeJSEntityRenderer<T> entityRendererIn, CustomEntityJSBuilder builder) {
        return new CustomGeoLayerJS<T>(entityRendererIn, this, builder);
    }

    public CustomGlowingGeoLayerJS<T> buildGlowing(CustomKubeJSEntityRenderer<T> entityRendererIn, CustomEntityJSBuilder builder) {
        return new CustomGlowingGeoLayerJS<T>(entityRendererIn, this, builder);
    }

    public CustomEntityJSBuilder getBuilder() {
        return this.builder;
    }

    @Info(value="Defines logic to preRender the newGeoLayer.\n\nExample usage:\n```javascript\ngeoBuilder.preRender(context => {\n    // Define logic to render the newGeoLayer\n    if (context.entity.isBaby()) {\n        context.poseStack.scale(0.5, 0.5, 0.5);\n    }\n});\n```\n")
    public CustomGeoLayerJSBuilder<T> preRender(Consumer<ContextUtils.PreRenderContext<T>> preRender) {
        this.preRender = preRender;
        return this;
    }

    @Info(value="Defines logic to render the newGeoLayer.\nBy default this will render the flat texture set in textureResource\nonto the entity as an overlay. This method overrides the render method completely\nallowing scripters to define their own render logic.\n\nExample usage:\n```javascript\ngeoBuilder.render(context => {\n    // Define logic to render the newGeoLayer\n    if (context.entity.isBaby()) {\n        context.poseStack.scale(0.5, 0.5, 0.5);\n    }\n});\n```\n")
    public CustomGeoLayerJSBuilder<T> render(Consumer<ContextUtils.PreRenderContext<T>> render) {
        this.render = render;
        return this;
    }

    @Info(value="Sets a function to determine the texture resource for the entity.\nThe provided Function accepts a parameter of type T (the entity),\nallowing changing the texture based on information about the entity.\nThe default behavior returns <namespace>:textures/entity/<path>.png.\n\nExample usage:\n```javascript\nentityBuilder.textureResource(entity => {\n    // Define logic to determine the texture resource for the entity\n    // Use information about the entity provided by the context.\n    return \"kubejs:textures/entity/wyrm.png\" // Some ResourceLocation representing the texture resource;\n});\n```\n")
    public CustomGeoLayerJSBuilder<T> textureResource(Function<T, Object> function) {
        this.textureResource = entity -> {
            Object obj = function.apply(entity = this.ensureIAnimatableJS((LivingEntity)entity));
            if (obj instanceof String && !obj.toString().equals("undefined")) {
                return new ResourceLocation((String)obj);
            }
            if (obj instanceof ResourceLocation) {
                return (ResourceLocation)obj;
            }
            EntityJSHelperClass.logWarningMessageOnce("Invalid return value for textureResource in newGeoLayer builder: " + obj + ". Defaulting to " + ((IAnimatableJSCustom)entity).getBuilder().newID("textures/entity/", ".png"));
            return ((IAnimatableJSCustom)entity).getBuilder().newID("textures/entity/", ".png");
        };
        return this;
    }

    private T ensureIAnimatableJS(LivingEntity entity) {
        if (entity instanceof IAnimatableJSCustom) {
            IAnimatableJSCustom animatableJS = (IAnimatableJSCustom)entity;
            return (T)((LivingEntity)animatableJS);
        }
        if (entity instanceof ILivingEntityJS) {
            ILivingEntityJS iLivingEntityJS = (ILivingEntityJS)entity;
            return (T)iLivingEntityJS.entityJs$getAnimatableEntity();
        }
        return (T)new WrappedAnimatableEntity(entity, this.builder);
    }
}

