/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.living.vanilla;

import com.mojang.serialization.Dynamic;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.builders.living.vanilla.WolfJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJS;
import net.liopyu.entityjs.entities.nonliving.entityjs.PartEntityJS;
import net.liopyu.entityjs.events.AddGoalSelectorsEventJS;
import net.liopyu.entityjs.events.AddGoalTargetsEventJS;
import net.liopyu.entityjs.events.BuildBrainEventJS;
import net.liopyu.entityjs.events.BuildBrainProviderEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.liopyu.entityjs.util.ModKeybinds;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WolfEntityJS
extends Wolf
implements IAnimatableJS,
RangedAttackMob,
OwnableEntity,
NeutralMob {
    private final AnimatableInstanceCache getAnimatableInstanceCache;
    protected final WolfJSBuilder builder;
    private final PartEntityJS<?>[] partEntities;
    protected boolean thisJumping = false;

    public String entityName() {
        return this.m_6095_().toString();
    }

    public WolfEntityJS(WolfJSBuilder builder, EntityType<? extends Wolf> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.builder = builder;
        this.m_7105_(false);
        this.getAnimatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        ArrayList<PartEntityJS<WolfEntityJS>> tempPartEntities = new ArrayList<PartEntityJS<WolfEntityJS>>();
        for (ContextUtils.PartEntityParams params : builder.partEntityParamsList) {
            PartEntityJS<WolfEntityJS> partEntity = new PartEntityJS<WolfEntityJS>(this, params.name, params.width, params.height, params.builder);
            tempPartEntities.add(partEntity);
        }
        this.partEntities = tempPartEntities.toArray(new PartEntityJS[0]);
        this.f_21344_ = this.m_6037_(pLevel);
        this.f_21365_ = this.createLookControl();
        this.f_21342_ = this.createMoveControl();
        this.f_21343_ = this.createJumpControl();
    }

    private MoveControl createMoveControl() {
        if (this.builder.setMoveControl != null) {
            Object obj = this.builder.setMoveControl.apply(this);
            if (obj != null) {
                return (MoveControl)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMoveControl from entity: " + this.entityName() + ". Value: " + obj + ". Must be a MoveControl object. Defaulting to super method.");
        }
        return this.f_21342_;
    }

    private LookControl createLookControl() {
        if (this.builder.setLookControl != null) {
            Object obj = this.builder.setLookControl.apply(this);
            if (obj != null) {
                return (LookControl)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setLookControl from entity: " + this.entityName() + ". Value: " + obj + ". Must be a LookControl object. Defaulting to super method.");
        }
        return this.f_21365_;
    }

    private JumpControl createJumpControl() {
        if (this.builder.setJumpControl != null) {
            Object obj = this.builder.setJumpControl.apply(this);
            if (obj != null) {
                return (JumpControl)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setJumpControl from entity: " + this.entityName() + ". Value: " + obj + ". Must be a JumpControl object. Defaulting to super method.");
        }
        return this.f_21343_;
    }

    public void m_20234_(int entityId) {
        super.m_20234_(entityId);
        for (int i = 0; i < this.partEntities.length; ++i) {
            PartEntityJS<?> partEntity = this.partEntities[i];
            if (partEntity == null) continue;
            partEntity.m_20234_(entityId + i + 1);
        }
    }

    public void tickPart(String partName, double offsetX, double offsetY, double offsetZ) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        for (PartEntityJS<?> partEntity : this.partEntities) {
            if (!partEntity.name.equals(partName)) continue;
            partEntity.movePart(x + offsetX, y + offsetY, z + offsetZ, partEntity.m_146908_(), partEntity.m_146909_());
            return;
        }
        EntityJSHelperClass.logWarningMessageOnce("Part with name " + partName + " not found for entity: " + this.entityName());
    }

    public boolean isMultipartEntity() {
        return this.partEntities != null;
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
    }

    public PartEntity<?>[] getParts() {
        return Objects.requireNonNullElseGet(this.partEntities, () -> new PartEntity[0]);
    }

    @Override
    public BaseLivingEntityBuilder<?> getBuilder() {
        return this.builder;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.getAnimatableInstanceCache;
    }

    public Brain.Provider<?> m_5490_() {
        if (EventHandlers.buildBrainProvider.hasListeners()) {
            BuildBrainProviderEventJS event = new BuildBrainProviderEventJS();
            EventHandlers.buildBrainProvider.post(event, (Object)this.getTypeId());
            return event.provide();
        }
        return super.m_5490_();
    }

    protected Brain<WolfEntityJS> m_8075_(Dynamic<?> p_21069_) {
        if (EventHandlers.buildBrain.hasListeners()) {
            Brain brain = (Brain)UtilsJS.cast((Object)this.m_5490_().m_22073_(p_21069_));
            EventHandlers.buildBrain.post(new BuildBrainEventJS(brain), (Object)this.getTypeId());
            return brain;
        }
        return (Brain)UtilsJS.cast((Object)super.m_8075_(p_21069_));
    }

    protected void m_8099_() {
        if (EventHandlers.addGoalTargets.hasListeners()) {
            EventHandlers.addGoalTargets.post(new AddGoalTargetsEventJS<WolfEntityJS>(this, this.f_21346_), (Object)this.getTypeId());
        }
        if (EventHandlers.addGoalSelectors.hasListeners()) {
            EventHandlers.addGoalSelectors.post(new AddGoalSelectorsEventJS<WolfEntityJS>(this, this.f_21345_), (Object)this.getTypeId());
        }
    }

    public boolean tamableFood(ItemStack pStack) {
        if (this.builder.tamableFood == null && this.builder.tamableFoodPredicate == null) {
            return this.m_6898_(pStack);
        }
        boolean isTamableFood = this.builder.tamableFood != null && this.builder.tamableFood.test(pStack);
        boolean isTamableFoodPredicate = this.builder.tamableFoodPredicate != null && this.tamableFoodPredicate(pStack);
        return isTamableFood || isTamableFoodPredicate;
    }

    public boolean tamableFoodPredicate(ItemStack pStack) {
        if (this.builder.tamableFoodPredicate == null) {
            return false;
        }
        ContextUtils.EntityItemStackContext context = new ContextUtils.EntityItemStackContext(pStack, (LivingEntity)this);
        Object obj = this.builder.tamableFoodPredicate.apply(context);
        if (obj instanceof Boolean) {
            Boolean b = (Boolean)obj;
            return b;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for tamableFoodPredicate from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to false.");
        return false;
    }

    public void m_21828_(Player pPlayer) {
        ContextUtils.PlayerEntityContext context;
        if (this.builder.tameOverride != null) {
            this.m_7105_(true);
            context = new ContextUtils.PlayerEntityContext(pPlayer, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.tameOverride, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: tameOverride.");
            if (pPlayer instanceof ServerPlayer) {
                CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)pPlayer, (Animal)this);
            }
        } else {
            super.m_21828_(pPlayer);
        }
        if (this.builder.onTamed != null) {
            context = new ContextUtils.PlayerEntityContext(pPlayer, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onTamed, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onTamed.");
        }
    }

    public boolean m_7757_(LivingEntity pTarget, LivingEntity pOwner) {
        if (!(pTarget instanceof Creeper) && !(pTarget instanceof Ghast)) {
            if (pTarget instanceof WolfEntityJS) {
                WolfEntityJS mobjs = (WolfEntityJS)pTarget;
                return !mobjs.m_21824_() || mobjs.m_269323_() != pOwner;
            }
            if (pTarget instanceof Player && pOwner instanceof Player && !((Player)pOwner).m_7099_((Player)pTarget)) {
                return false;
            }
            if (pTarget instanceof AbstractHorse && ((AbstractHorse)pTarget).m_30614_()) {
                return false;
            }
            return !(pTarget instanceof TamableAnimal) || !((TamableAnimal)pTarget).m_21824_();
        }
        return false;
    }

    public Wolf m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        if (this.builder.setBreedOffspring != null) {
            ResourceLocation resourceLocation;
            EntityType breedOffspringType;
            ContextUtils.BreedableEntityContext context = new ContextUtils.BreedableEntityContext((AgeableMob)this, ageableMob, serverLevel);
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBreedOffspring.apply(context), "resourcelocation");
            if (obj instanceof ResourceLocation && (breedOffspringType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation = (ResourceLocation)obj)) != null) {
                Entity breedOffspringEntity = breedOffspringType.m_20615_((Level)serverLevel);
                if (breedOffspringEntity instanceof TamableAnimal) {
                    TamableAnimal animal = (TamableAnimal)breedOffspringEntity;
                    UUID uuid = this.m_21805_();
                    if (uuid != null) {
                        animal.m_21816_(uuid);
                        animal.m_7105_(true);
                    }
                    return (Wolf)breedOffspringEntity;
                }
                if (breedOffspringEntity instanceof Wolf) {
                    return (Wolf)breedOffspringEntity;
                }
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid resource location or Entity Type for breedOffspring: " + this.builder.setBreedOffspring.apply(context) + ". Must return a Wolf entity type ResourceLocation. Defaulting to super method: " + this.builder.get());
        }
        return (Wolf)((EntityType)this.builder.get()).m_20615_((Level)serverLevel);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    protected void m_21834_(boolean pTamed) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!pTamed) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public boolean m_6898_(ItemStack pStack) {
        return this.builder.isFood != null && this.builder.isFood.test(pStack) || this.isFoodPredicate(pStack);
    }

    public boolean isFoodPredicate(ItemStack pStack) {
        if (this.builder.isFoodPredicate == null) {
            return super.m_6898_(pStack);
        }
        ContextUtils.EntityItemStackContext context = new ContextUtils.EntityItemStackContext(pStack, (LivingEntity)this);
        Object obj = this.builder.isFoodPredicate.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFoodPredicate from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6898_(pStack));
        return super.m_6898_(pStack);
    }

    public boolean m_35506_() {
        if (this.builder.canBreed == null) {
            return super.m_35506_();
        }
        Object obj = this.builder.canBreed.apply(this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBreed from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to super method: " + super.m_35506_());
        return super.m_35506_();
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        if (this.builder.canMate == null) {
            return super.m_7848_(pOtherAnimal);
        }
        ContextUtils.EntityAnimalContext context = new ContextUtils.EntityAnimalContext((Animal)this, pOtherAnimal);
        Object obj = this.builder.canMate.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canMate from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7848_(pOtherAnimal));
        return super.m_7848_(pOtherAnimal);
    }

    public void m_27563_(ServerLevel pLevel, Animal pMate) {
        if (this.builder.onSpawnChildFromBreeding != null) {
            ContextUtils.LevelAnimalContext context = new ContextUtils.LevelAnimalContext(pMate, (Animal)this, pLevel);
            EntityJSHelperClass.consumerCallback(this.builder.onSpawnChildFromBreeding, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onSpawnChildFromBreeding.");
            super.m_27563_(pLevel, pMate);
        } else {
            super.m_27563_(pLevel, pMate);
        }
    }

    private InteractionResult superMobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.m_6898_(itemstack)) {
            int i = this.m_146764_();
            if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_27595_(pPlayer);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_146740_(WolfEntityJS.m_216967_((int)(-i)), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (this.builder.onInteract != null) {
            ContextUtils.MobInteractContext context = new ContextUtils.MobInteractContext((LivingEntity)this, pPlayer, pHand);
            EntityJSHelperClass.consumerCallback(this.builder.onInteract, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onInteract.");
        }
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)pPlayer) || this.m_21824_() || itemstack.m_150930_(Items.f_42500_) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            InteractionResult interactionresult;
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeItem dyeitem = (DyeItem)item;
                if (this.m_21830_((LivingEntity)pPlayer)) {
                    DyeColor dyecolor = dyeitem.m_41089_();
                    if (dyecolor != this.m_30428_()) {
                        this.m_30397_(dyecolor);
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return this.superMobInteract(pPlayer, pHand);
                }
            }
            if ((!(interactionresult = this.superMobInteract(pPlayer, pHand)).m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)pPlayer)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (this.tamableFood(itemstack) && !this.m_21660_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return this.superMobInteract(pPlayer, pHand);
    }

    public boolean m_7327_(Entity pEntity) {
        if (this.builder != null && this.builder.onHurtTarget != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onHurtTarget, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurtTarget.");
        }
        return super.m_7327_(pEntity);
    }

    public void onJump() {
        if (this.builder.onLivingJump != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onLivingJump, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingJump.");
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.canJump() && this.m_20096_() && this.m_21573_().m_26572_() && this.shouldJump()) {
            this.jump();
        }
        if (this.builder.aiStep != null) {
            EntityJSHelperClass.consumerCallback(this.builder.aiStep, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: aiStep.");
        }
    }

    protected void m_6153_() {
        if (this.builder.tickDeath != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tickDeath, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tickDeath.");
        } else {
            super.m_6153_();
        }
    }

    protected void m_6119_() {
        super.m_6119_();
        if (this.builder.tickLeash != null) {
            Player $$0 = (Player)this.m_21524_();
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext($$0, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.tickLeash, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: tickLeash.");
        }
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        if (this.builder.onTargetChanged != null) {
            ContextUtils.TargetChangeContext context = new ContextUtils.TargetChangeContext(target, (Mob)this);
            EntityJSHelperClass.consumerCallback(this.builder.onTargetChanged, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onTargetChanged.");
        }
    }

    public void m_8035_() {
        super.m_8035_();
        if (this.builder.ate != null) {
            EntityJSHelperClass.consumerCallback(this.builder.ate, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: ate.");
        }
    }

    protected PathNavigation m_6037_(Level pLevel) {
        if (this.builder == null || this.builder.createNavigation == null) {
            return super.m_6037_(pLevel);
        }
        ContextUtils.EntityLevelContext context = new ContextUtils.EntityLevelContext(pLevel, (LivingEntity)this);
        Object obj = this.builder.createNavigation.apply(context);
        if (obj instanceof PathNavigation) {
            PathNavigation p = (PathNavigation)obj;
            return p;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for createNavigation from entity: " + this.entityName() + ". Value: " + obj + ". Must be PathNavigation. Defaulting to super method.");
        return super.m_6037_(pLevel);
    }

    public boolean m_6573_(Player pPlayer) {
        if (this.builder.canBeLeashed != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(pPlayer, (LivingEntity)this);
            Object obj = this.builder.canBeLeashed.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeLeashed from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6573_(pPlayer));
        }
        return super.m_6573_(pPlayer);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        if (this.builder.removeWhenFarAway == null) {
            return super.m_6785_(pDistanceToClosestPlayer);
        }
        ContextUtils.EntityDistanceToPlayerContext context = new ContextUtils.EntityDistanceToPlayerContext(pDistanceToClosestPlayer, (LivingEntity)this);
        Object obj = this.builder.removeWhenFarAway.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for removeWhenFarAway from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6785_(pDistanceToClosestPlayer));
        return super.m_6785_(pDistanceToClosestPlayer);
    }

    protected double m_5823_() {
        return Objects.requireNonNullElseGet(this.builder.followLeashSpeed, () -> super.m_5823_());
    }

    public int m_8100_() {
        if (this.builder.ambientSoundInterval != null) {
            return (Integer)this.builder.ambientSoundInterval;
        }
        return super.m_8100_();
    }

    public double m_6049_() {
        if (this.builder.myRidingOffset == null) {
            return super.m_6049_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.myRidingOffset.apply(this), "double");
        if (obj != null) {
            return (Double)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for myRidingOffset from entity: " + this.entityName() + ". Value: " + this.builder.myRidingOffset.apply(this) + ". Must be a double. Defaulting to " + super.m_6049_());
        return super.m_6049_();
    }

    public MobType m_6336_() {
        if (this.builder != null) {
            return this.builder.mobType;
        }
        return super.m_6336_();
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, pDistanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }

    public boolean canJump() {
        return Objects.requireNonNullElse(this.builder.canJump, true);
    }

    public void jump() {
        double jumpPower = this.m_6118_() + this.m_285755_();
        Vec3 currentVelocity = this.m_20184_();
        this.m_20334_(currentVelocity.f_82479_, jumpPower, currentVelocity.f_82481_);
        this.f_19812_ = true;
        if (this.m_20142_()) {
            float yawRadians = this.m_146908_() * ((float)Math.PI / 180);
            this.m_20256_(this.m_20184_().m_82520_(-Math.sin(yawRadians) * 0.2, 0.0, Math.cos(yawRadians) * 0.2));
        }
        this.f_19812_ = true;
        this.onJump();
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    public boolean shouldJump() {
        BlockPos forwardPos = this.m_20183_().m_121945_(this.m_6350_());
        return this.m_9236_().m_46575_(forwardPos, (Entity)this) && (double)this.getStepHeight() < this.m_9236_().m_8055_(forwardPos).m_60808_((BlockGetter)this.m_9236_(), forwardPos).m_83297_(Direction.Axis.Y);
    }

    public HumanoidArm m_5737_() {
        if (this.builder.mainArm != null) {
            return (HumanoidArm)this.builder.mainArm;
        }
        return super.m_5737_();
    }

    public float m_5610_(BlockPos pos, LevelReader levelReader) {
        if (this.builder.walkTargetValue == null) {
            return super.m_5610_(pos, levelReader);
        }
        ContextUtils.EntityBlockPosLevelContext context = new ContextUtils.EntityBlockPosLevelContext(pos, levelReader, (LivingEntity)this);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.walkTargetValue.apply(context), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for walkTargetValue from entity: " + this.entityName() + ". Value: " + this.builder.walkTargetValue.apply(context) + ". Must be a float. Defaulting to " + super.m_5610_(pos, levelReader));
        return super.m_5610_(pos, levelReader);
    }

    protected boolean m_213814_() {
        if (this.builder.shouldStayCloseToLeashHolder == null) {
            return super.m_213814_();
        }
        Object value = this.builder.shouldStayCloseToLeashHolder.apply(this);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldStayCloseToLeashHolder from entity: " + this.entityName() + ". Value: " + value + ". Must be a boolean. Defaulting to " + super.m_213814_());
        return super.m_213814_();
    }

    public boolean canFireProjectileWeaponPredicate(ProjectileWeaponItem projectileWeapon) {
        if (this.builder.canFireProjectileWeaponPredicate != null) {
            ContextUtils.EntityProjectileWeaponContext context = new ContextUtils.EntityProjectileWeaponContext(projectileWeapon, (LivingEntity)this);
            Object obj = this.builder.canFireProjectileWeaponPredicate.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFireProjectileWeaponPredicate from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to false.");
        }
        return false;
    }

    public boolean canFireProjectileWeapons(ProjectileWeaponItem projectileWeapon) {
        if (this.builder.canFireProjectileWeapon != null) {
            return this.builder.canFireProjectileWeapon.test(projectileWeapon.m_7968_()) && projectileWeapon instanceof ProjectileWeaponItem;
        }
        return super.m_5886_(projectileWeapon);
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeapon) {
        if (this.canFireProjectileWeapons(projectileWeapon) || this.canFireProjectileWeaponPredicate(projectileWeapon)) {
            return this.canFireProjectileWeapons(projectileWeapon) && this.canFireProjectileWeaponPredicate(projectileWeapon);
        }
        return super.m_5886_(projectileWeapon);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.builder.setAmbientSound != null) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setAmbientSound);
        }
        return super.m_7515_();
    }

    public boolean m_7252_(ItemStack stack) {
        if (this.builder.canHoldItem != null) {
            ContextUtils.EntityItemStackContext context = new ContextUtils.EntityItemStackContext(stack, (LivingEntity)this);
            Object obj = this.builder.canHoldItem.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canHoldItem from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7252_(stack));
        }
        return super.m_7252_(stack);
    }

    protected boolean m_8028_() {
        return Objects.requireNonNullElseGet(this.builder.shouldDespawnInPeaceful, () -> super.m_8028_());
    }

    public boolean m_21532_() {
        return Objects.requireNonNullElseGet(this.builder.isPersistenceRequired, () -> super.m_21532_());
    }

    public double m_142593_(LivingEntity entity) {
        if (this.builder.meleeAttackRangeSqr != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.meleeAttackRangeSqr.apply(this), "double");
            if (obj != null) {
                return (Double)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for meleeAttackRangeSqr from entity: " + this.entityName() + ". Value: " + this.builder.meleeAttackRangeSqr.apply(this) + ". Must be a double. Defaulting to " + super.m_142593_(entity));
        }
        return super.m_142593_(entity);
    }

    public boolean m_7307_(Entity pEntity) {
        if (this.builder.isAlliedTo != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (Entity)this);
            Object obj = this.builder.isAlliedTo.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAlliedTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7307_(pEntity));
        }
        return super.m_7307_(pEntity);
    }

    public void m_7023_(Vec3 pTravelVector) {
        LivingEntity livingentity = this.m_6688_();
        if (this.m_6084_() && this.m_20160_() && this.builder.canSteer.booleanValue() && livingentity != null) {
            if (this.m_6688_() instanceof Player && this.builder.mountJumpingEnabled) {
                if (this.ableToJump()) {
                    this.setThisJumping(true);
                }
                if (this.thisJumping) {
                    this.setThisJumping(false);
                    double jumpPower = this.m_6118_() + this.m_285755_();
                    Vec3 currentVelocity = this.m_20184_();
                    double newVelocityX = currentVelocity.f_82479_;
                    double newVelocityY = currentVelocity.f_82480_ + jumpPower;
                    double newVelocityZ = currentVelocity.f_82481_;
                    this.m_20334_(newVelocityX, newVelocityY, newVelocityZ);
                    this.onJump();
                    ForgeHooks.onLivingJump((LivingEntity)this);
                }
            }
            LivingEntity passenger = this.m_6688_();
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
            this.m_146922_(passenger.m_146908_());
            this.m_146926_(passenger.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            float x = passenger.f_20900_ * 0.5f;
            float z = passenger.f_20902_;
            if (z <= 0.0f) {
                z *= 0.25f;
            }
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
            super.m_7023_(new Vec3((double)x, pTravelVector.f_82480_, (double)z));
        } else {
            super.m_7023_(pTravelVector);
        }
        if (this.builder.travel != null) {
            ContextUtils.Vec3Context context = new ContextUtils.Vec3Context(pTravelVector, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.travel, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: travel.");
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.builder.tick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tick.");
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.builder.defaultGoals.booleanValue()) {
            super.m_8099_();
        }
        if (this.builder.onAddedToWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onAddedToWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld.");
        }
    }

    protected void m_6727_(@NotNull LivingEntity target) {
        super.m_6727_(target);
        if (this.builder.doAutoAttackOnTouch != null) {
            ContextUtils.AutoAttackContext context = new ContextUtils.AutoAttackContext((LivingEntity)this, target);
            EntityJSHelperClass.consumerCallback(this.builder.doAutoAttackOnTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: doAutoAttackOnTouch.");
        }
    }

    protected int m_7302_(int p_21303_) {
        if (this.builder.onDecreaseAirSupply != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onDecreaseAirSupply, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onDecreaseAirSupply.");
        }
        return super.m_7302_(p_21303_);
    }

    protected int m_7305_(int p_21307_) {
        if (this.builder.onIncreaseAirSupply != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onIncreaseAirSupply, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onIncreaseAirSupply.");
        }
        return super.m_7305_(p_21307_);
    }

    protected void m_6731_(@NotNull LivingEntity p_21246_) {
        super.m_6731_(p_21246_);
        if (this.builder.onBlockedByShield != null) {
            ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext((LivingEntity)this, p_21246_);
            EntityJSHelperClass.consumerCallback(this.builder.onBlockedByShield, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onDecreaseAirSupply.");
        }
    }

    public void m_238392_(EquipmentSlot slot, ItemStack previous, ItemStack current) {
        super.m_238392_(slot, previous, current);
        if (this.builder.onEquipItem != null) {
            ContextUtils.EntityEquipmentContext context = new ContextUtils.EntityEquipmentContext(slot, previous, current, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onEquipItem, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEquipItem.");
        }
    }

    public void m_142540_(@NotNull MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (this.builder.onEffectAdded != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onEffectAdded, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEffectAdded.");
        } else {
            super.m_142540_(effectInstance, entity);
        }
    }

    protected void m_7285_(@NotNull MobEffectInstance effectInstance) {
        if (this.builder.onEffectRemoved != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onEffectRemoved, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEffectRemoved.");
        } else {
            super.m_7285_(effectInstance);
        }
    }

    public void m_5634_(float amount) {
        super.m_5634_(amount);
        if (this.builder.onLivingHeal != null) {
            ContextUtils.EntityHealContext context = new ContextUtils.EntityHealContext((LivingEntity)this, amount);
            EntityJSHelperClass.consumerCallback(this.builder.onLivingHeal, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingHeal.");
        }
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (this.builder.onDeath != null) {
            ContextUtils.DeathContext context = new ContextUtils.DeathContext((LivingEntity)this, damageSource);
            EntityJSHelperClass.consumerCallback(this.builder.onDeath, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onDeath.");
        }
    }

    protected void m_7472_(@NotNull DamageSource damageSource, int lootingMultiplier, boolean allowDrops) {
        if (this.builder.dropCustomDeathLoot != null) {
            ContextUtils.EntityLootContext context = new ContextUtils.EntityLootContext(damageSource, lootingMultiplier, allowDrops, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.dropCustomDeathLoot, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: dropCustomDeathLoot.");
        } else {
            super.m_7472_(damageSource, lootingMultiplier, allowDrops);
        }
    }

    protected void m_142043_() {
        if (this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onFlap, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap.");
        }
        super.m_142043_();
    }

    public boolean ableToJump() {
        return ModKeybinds.mount_jump.m_90857_() && this.m_20096_();
    }

    public void setThisJumping(boolean value) {
        this.thisJumping = value;
    }

    public LivingEntity m_6688_() {
        LivingEntity entity;
        Entity var2 = this.m_146895_();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    @Info(value="Calls a triggerable animation to be played anywhere.\n")
    public void triggerAnimation(String controllerName, String animName) {
        this.triggerAnim(controllerName, animName);
    }

    public boolean m_7337_(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.CollidingEntityContext context = new ContextUtils.CollidingEntityContext((LivingEntity)this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7337_(pEntity));
        }
        return super.m_7337_(pEntity);
    }

    protected float m_6121_() {
        return Objects.requireNonNullElseGet(this.builder.setSoundVolume, () -> Float.valueOf(super.m_6121_())).floatValue();
    }

    protected float m_6108_() {
        return Objects.requireNonNullElseGet(this.builder.setWaterSlowDown, () -> Float.valueOf(super.m_6108_())).floatValue();
    }

    protected float m_20098_() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.m_20098_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + this.builder.setBlockJumpFactor.apply(this) + ". Must be a float. Defaulting to " + super.m_20098_());
        return super.m_20098_();
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        if (this.builder == null || this.builder.setStandingEyeHeight == null) {
            return super.m_6431_(pPose, pDimensions);
        }
        ContextUtils.EntityPoseDimensionsContext context = new ContextUtils.EntityPoseDimensionsContext(pPose, pDimensions, (LivingEntity)this);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setStandingEyeHeight.apply(context), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setStandingEyeHeight from entity: " + this.entityName() + ". Value: " + this.builder.setStandingEyeHeight.apply(context) + ". Must be a float. Defaulting to " + super.m_6431_(pPose, pDimensions));
        return super.m_6431_(pPose, pDimensions);
    }

    public boolean m_6094_() {
        return this.builder.isPushable;
    }

    protected float m_6041_() {
        if (this.builder.blockSpeedFactor == null) {
            return super.m_6041_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), "float");
        if (this.builder.blockSpeedFactor == null) {
            return super.m_6041_();
        }
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.builder.get() + ". Value: " + this.builder.blockSpeedFactor.apply(this) + ". Must be a float, defaulting to " + super.m_6041_());
        return super.m_6041_();
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((Entity)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback(this.builder.positionRider, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider.");
            return;
        }
        super.m_19956_(pPassenger, pCallback);
    }

    protected boolean m_7310_(@NotNull Entity entity) {
        if (this.builder.canAddPassenger == null) {
            return super.m_7310_(entity);
        }
        ContextUtils.PassengerEntityContext context = new ContextUtils.PassengerEntityContext(entity, (LivingEntity)this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.m_7310_(entity));
        return super.m_7310_(entity);
    }

    protected boolean m_6125_() {
        if (this.builder.shouldDropLoot != null) {
            Object obj = this.builder.shouldDropLoot.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldDropLoot from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.m_6125_());
        }
        return super.m_6125_();
    }

    protected boolean m_6129_() {
        if (this.builder.isAffectedByFluids != null) {
            Object obj = this.builder.isAffectedByFluids.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAffectedByFluids from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6129_());
        }
        return super.m_6129_();
    }

    protected boolean m_6124_() {
        return this.builder.isAlwaysExperienceDropper;
    }

    protected boolean m_6107_() {
        if (this.builder.isImmobile != null) {
            Object obj = this.builder.isImmobile.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isImmobile from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6107_());
        }
        return super.m_6107_();
    }

    protected boolean m_142039_() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142039_());
        }
        return super.m_142039_();
    }

    public int m_5639_(float fallDistance, float pDamageMultiplier) {
        if (this.builder.calculateFallDamage == null) {
            return super.m_5639_(fallDistance, pDamageMultiplier);
        }
        ContextUtils.CalculateFallDamageContext context = new ContextUtils.CalculateFallDamageContext(fallDistance, pDamageMultiplier, (LivingEntity)this);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.calculateFallDamage.apply(context), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for calculateFallDamage from entity: " + this.entityName() + ". Value: " + this.builder.calculateFallDamage.apply(context) + ". Must be an int, defaulting to " + super.m_5639_(fallDistance, pDamageMultiplier));
        return super.m_5639_(fallDistance, pDamageMultiplier);
    }

    protected boolean m_6093_() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.m_6093_());
    }

    protected float m_6059_() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + this.builder.nextStep.apply(this) + ". Must be a float, defaulting to " + super.m_6059_());
        }
        return super.m_6059_();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        if (this.builder.setHurtSound == null) {
            return super.m_7975_(p_21239_);
        }
        ContextUtils.HurtContext context = new ContextUtils.HurtContext((LivingEntity)this, p_21239_);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setHurtSound.apply(context), "resourcelocation");
        if (obj != null) {
            return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)obj));
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setHurtSound from entity: " + this.entityName() + ". Value: " + this.builder.setHurtSound.apply(context) + ". Must be a ResourceLocation or String. Defaulting to \"minecraft:entity.generic.hurt\"");
        return super.m_7975_(p_21239_);
    }

    protected SoundEvent m_5509_() {
        if (this.builder.setSwimSplashSound == null) {
            return super.m_5509_();
        }
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent m_5501_() {
        if (this.builder.setSwimSound == null) {
            return super.m_5501_();
        }
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setSwimSound));
    }

    public boolean m_6549_(@NotNull EntityType<?> entityType) {
        if (this.builder.canAttackType != null) {
            ContextUtils.EntityTypeEntityContext context = new ContextUtils.EntityTypeEntityContext((LivingEntity)this, entityType);
            Object obj = this.builder.canAttackType.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAttackType from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6549_(entityType));
        }
        return super.m_6549_(entityType);
    }

    public float m_6134_() {
        if (this.builder.scale == null) {
            return super.m_6134_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.scale.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for scale from entity: " + this.entityName() + ". Value: " + this.builder.scale.apply(this) + ". Must be a float. Defaulting to " + super.m_6134_());
        return super.m_6134_();
    }

    public boolean m_6149_() {
        if (this.builder.shouldDropExperience != null) {
            Object obj = this.builder.shouldDropExperience.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldDropExperience from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6149_());
        }
        return super.m_6149_();
    }

    public double m_20968_(@Nullable Entity p_20969_) {
        if (this.builder.visibilityPercent != null) {
            ContextUtils.VisualContext context = new ContextUtils.VisualContext(p_20969_, (LivingEntity)this);
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.visibilityPercent.apply(context), "double");
            if (obj != null) {
                return (Double)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for visibilityPercent from entity: " + this.entityName() + ". Value: " + this.builder.visibilityPercent.apply(context) + ". Must be a double. Defaulting to " + super.m_20968_(p_20969_));
            return super.m_20968_(p_20969_);
        }
        return super.m_20968_(p_20969_);
    }

    public boolean m_6779_(@NotNull LivingEntity entity) {
        if (this.builder.canAttack != null) {
            ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext((LivingEntity)this, entity);
            Object obj = this.builder.canAttack.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj != false && super.m_6779_(entity);
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAttack from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6779_(entity));
        }
        return super.m_6779_(entity);
    }

    public boolean m_7301_(@NotNull MobEffectInstance effectInstance) {
        if (this.builder.canBeAffected == null) {
            return super.m_7301_(effectInstance);
        }
        ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
        Object result = this.builder.canBeAffected.apply(context);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeAffected from entity: " + this.entityName() + ". Value: " + result + ". Must be a boolean. Defaulting to " + super.m_7301_(effectInstance));
        return super.m_7301_(effectInstance);
    }

    public boolean m_21222_() {
        if (this.builder.invertedHealAndHarm == null) {
            return super.m_21222_();
        }
        Object obj = this.builder.invertedHealAndHarm.apply(this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for invertedHealAndHarm from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_21222_());
        return super.m_21222_();
    }

    protected SoundEvent m_5592_() {
        if (this.builder.setDeathSound == null) {
            return super.m_5592_();
        }
        return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.setDeathSound));
    }

    @NotNull
    public LivingEntity.Fallsounds m_196493_() {
        if (this.builder.fallSounds != null) {
            return new LivingEntity.Fallsounds(Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.smallFallSound)), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.largeFallSound)));
        }
        return super.m_196493_();
    }

    @NotNull
    public SoundEvent m_7866_(@NotNull ItemStack itemStack) {
        if (this.builder.eatingSound != null) {
            return Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue((ResourceLocation)this.builder.eatingSound));
        }
        return super.m_7866_(itemStack);
    }

    public boolean m_6147_() {
        if (this.builder.onClimbable == null) {
            return super.m_6147_();
        }
        Object obj = this.builder.onClimbable.apply(this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for onClimbable from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to super.onClimbable(): " + super.m_6147_());
        return super.m_6147_();
    }

    public boolean m_6040_() {
        return Objects.requireNonNullElseGet(this.builder.canBreatheUnderwater, () -> super.m_6040_());
    }

    public boolean m_142535_(float distance, float damageMultiplier, @NotNull DamageSource damageSource) {
        if (this.builder.onLivingFall != null) {
            ContextUtils.EntityFallDamageContext context = new ContextUtils.EntityFallDamageContext((LivingEntity)this, damageMultiplier, distance, damageSource);
            EntityJSHelperClass.consumerCallback(this.builder.onLivingFall, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall.");
        }
        return super.m_142535_(distance, damageMultiplier, damageSource);
    }

    public void m_6858_(boolean sprinting) {
        if (this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onSprint, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint.");
        }
        super.m_6858_(sprinting);
    }

    public float m_285755_() {
        if (this.builder.jumpBoostPower == null) {
            return super.m_285755_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.jumpBoostPower.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for jumpBoostPower from entity: " + this.entityName() + ". Value: " + this.builder.jumpBoostPower.apply(this) + ". Must be a float. Defaulting to " + super.m_285755_());
        return super.m_285755_();
    }

    public boolean m_203441_(@NotNull FluidState fluidState) {
        if (this.builder.canStandOnFluid != null) {
            ContextUtils.EntityFluidStateContext context = new ContextUtils.EntityFluidStateContext((LivingEntity)this, fluidState);
            Object obj = this.builder.canStandOnFluid.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canStandOnFluid from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_203441_(fluidState));
        }
        return super.m_203441_(fluidState);
    }

    public boolean m_6126_() {
        if (this.builder.isSensitiveToWater != null) {
            Object obj = this.builder.isSensitiveToWater.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isSensitiveToWater from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6126_());
        }
        return super.m_6126_();
    }

    public void m_8127_() {
        super.m_8127_();
        if (this.builder.onStopRiding != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopRiding, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding.");
        }
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.rideTick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick.");
        }
    }

    public void m_21053_(@NotNull ItemEntity p_21054_) {
        super.m_21053_(p_21054_);
        if (this.builder.onItemPickup != null) {
            ContextUtils.EntityItemEntityContext context = new ContextUtils.EntityItemEntityContext((LivingEntity)this, p_21054_);
            EntityJSHelperClass.consumerCallback(this.builder.onItemPickup, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onItemPickup.");
        }
    }

    public boolean m_142582_(@NotNull Entity entity) {
        if (this.builder.hasLineOfSight != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(entity, (Entity)this);
            Object obj = this.builder.hasLineOfSight.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for hasLineOfSight from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142582_(entity));
        }
        return super.m_142582_(entity);
    }

    public void m_8108_() {
        if (this.builder.onEnterCombat != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onEnterCombat, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEnterCombat.");
        } else {
            super.m_8108_();
        }
    }

    public void m_8098_() {
        if (this.builder.onLeaveCombat != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onLeaveCombat, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLeaveCombat.");
        }
        super.m_8098_();
    }

    public boolean m_5801_() {
        if (this.builder.isAffectedByPotions != null) {
            Object obj = this.builder.isAffectedByPotions.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAffectedByPotions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_5801_());
        }
        return super.m_5801_();
    }

    public boolean m_5789_() {
        if (this.builder.isAttackable != null) {
            Object obj = this.builder.isAttackable.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAttackable from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_5789_());
        }
        return super.m_5789_();
    }

    public boolean m_7066_(@NotNull ItemStack itemStack) {
        if (this.builder.canTakeItem != null) {
            ContextUtils.EntityItemLevelContext context = new ContextUtils.EntityItemLevelContext((LivingEntity)this, itemStack, this.m_9236_());
            Object obj = this.builder.canTakeItem.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTakeItem from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_7066_(itemStack));
        }
        return super.m_7066_(itemStack);
    }

    public boolean m_5803_() {
        if (this.builder.isSleeping != null) {
            Object obj = this.builder.isSleeping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isSleeping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_5803_());
        }
        return super.m_5803_();
    }

    public void m_5802_(@NotNull BlockPos blockPos) {
        if (this.builder.onStartSleeping != null) {
            ContextUtils.EntityBlockPosContext context = new ContextUtils.EntityBlockPosContext((LivingEntity)this, blockPos);
            EntityJSHelperClass.consumerCallback(this.builder.onStartSleeping, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStartSleeping.");
        }
        super.m_5802_(blockPos);
    }

    public void m_5796_() {
        if (this.builder.onStopSleeping != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopSleeping, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopSleeping.");
        }
        super.m_5796_();
    }

    @NotNull
    public ItemStack m_5584_(@NotNull Level level, @NotNull ItemStack itemStack) {
        if (this.builder.eat != null) {
            ContextUtils.EntityItemLevelContext context = new ContextUtils.EntityItemLevelContext((LivingEntity)this, itemStack, level);
            EntityJSHelperClass.consumerCallback(this.builder.eat, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: eat.");
            return itemStack;
        }
        return super.m_5584_(level, itemStack);
    }

    public boolean shouldRiderFaceForward(@NotNull Player player) {
        if (this.builder.shouldRiderFaceForward != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(player, (LivingEntity)this);
            Object obj = this.builder.shouldRiderFaceForward.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldRiderFaceForward from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.shouldRiderFaceForward(player));
        }
        return super.shouldRiderFaceForward(player);
    }

    public boolean m_142079_() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142079_());
        }
        return super.m_142079_();
    }

    public boolean m_203117_() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_203117_());
        }
        return super.m_203117_();
    }

    public boolean m_142038_() {
        if (this.builder.isCurrentlyGlowing != null) {
            Object obj = this.builder.isCurrentlyGlowing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142038_());
        }
        return super.m_142038_();
    }

    public boolean m_213824_() {
        if (this.builder.canDisableShield != null) {
            Object obj = this.builder.canDisableShield.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canDisableShield from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_213824_());
        }
        return super.m_213824_();
    }

    public void m_142036_() {
        if (this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onClientRemoval, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval.");
        }
        super.m_142036_();
    }

    public void m_6475_(DamageSource pDamageSource, float pDamageAmount) {
        if (this.builder.onHurt != null) {
            ContextUtils.EntityDamageContext context = new ContextUtils.EntityDamageContext(pDamageSource, pDamageAmount, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onHurt, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt.");
        }
        super.m_6475_(pDamageSource, pDamageAmount);
    }

    public void m_20093_() {
        if (this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback(this.builder.lavaHurt, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt.");
        }
        super.m_20093_();
    }

    public int m_213860_() {
        if (this.builder.experienceReward != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.experienceReward.apply(this), "integer");
            if (obj != null) {
                return (Integer)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for experienceReward from entity: " + this.entityName() + ". Value: " + this.builder.experienceReward.apply(this) + ". Must be an integer. Defaulting to " + super.m_213860_());
        }
        return super.m_213860_();
    }

    public boolean m_213854_() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_213854_());
        }
        return super.m_213854_();
    }

    public void m_6123_(Player p_20081_) {
        if (this.builder.playerTouch != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(p_20081_, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.playerTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch.");
        } else {
            super.m_6123_(p_20081_);
        }
    }

    public boolean m_20152_() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_20152_());
        }
        return super.m_20152_();
    }

    public void m_8038_(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder.thunderHit != null) {
            super.m_8038_(p_19927_, p_19928_);
            ContextUtils.ThunderHitContext context = new ContextUtils.ThunderHitContext(p_19927_, p_19928_, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.thunderHit, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit.");
        }
    }

    public boolean m_6673_(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.DamageContext context = new ContextUtils.DamageContext((LivingEntity)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6673_(p_20122_));
        }
        return super.m_6673_(p_20122_);
    }

    public boolean m_6072_() {
        if (this.builder.canChangeDimensions != null) {
            Object obj = this.builder.canChangeDimensions.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_6072_());
        }
        return super.m_6072_();
    }

    public boolean m_142265_(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.MayInteractContext context = new ContextUtils.MayInteractContext(p_146843_, p_146844_, (LivingEntity)this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_142265_(p_146843_, p_146844_));
        }
        return super.m_142265_(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.CanTrampleContext context = new ContextUtils.CanTrampleContext(state, pos, fallDistance, (LivingEntity)this);
            Object obj = this.builder.canTrample.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance));
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public void onRemovedFromWorld() {
        if (this.builder != null && this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovedFromWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld.");
        }
        super.onRemovedFromWorld();
    }

    public int m_6056_() {
        if (this.builder.setMaxFallDistance == null) {
            return super.m_6056_();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + this.builder.setMaxFallDistance.apply(this) + ". Must be an integer. Defaulting to " + super.m_6056_());
        return super.m_6056_();
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.m_6453_(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, teleport, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.lerpTo, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo.");
        }
    }

    public boolean m_6783_(double distance) {
        if (this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, (Entity)this);
            Object obj = this.builder.shouldRenderAtSqrDistance.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for builder: " + obj + ". Must be a boolean. Defaulting to super method: " + super.m_6783_(distance));
        }
        return super.m_6783_(distance);
    }

    public boolean m_5829_() {
        if (this.builder.canBeCollidedWith == null) {
            return super.m_5829_();
        }
        Object obj = this.builder.canBeCollidedWith.apply(this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeCollidedWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.m_5829_());
        return super.m_5829_();
    }

    protected boolean m_7341_(Entity pVehicle) {
        if (this.builder.canRide == null) {
            return super.m_7341_(pVehicle);
        }
        ContextUtils.PassengerVehicleContext context = new ContextUtils.PassengerVehicleContext(pVehicle, (LivingEntity)this);
        Boolean obj = this.builder.canRide.test(context);
        if (obj instanceof Boolean) {
            return obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canRide from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to super method.");
        return super.m_7341_(pVehicle);
    }
}

