/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.item;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.typings.Info;
import net.liopyu.entityjs.builders.nonliving.vanilla.TridentJSBuilder;
import net.liopyu.entityjs.entities.nonliving.vanilla.TridentEntityJS;
import net.liopyu.entityjs.item.ProjectileItemBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class TridentItemBuilder
extends ProjectileItemBuilder {
    public transient SoundEvent throwSound;
    public transient SoundEvent riptide1Sound;
    public transient SoundEvent riptide2Sound;
    public transient SoundEvent riptide3Sound;

    public TridentItemBuilder(ResourceLocation i, BuilderBase<?> parent) {
        super(i, parent);
        this.maxDamage = 250;
        this.throwSound = SoundEvents.f_12520_;
        this.projectileVelocity = 0.0f;
        this.riptide1Sound = SoundEvents.f_12517_;
        this.riptide2Sound = SoundEvents.f_12518_;
        this.riptide3Sound = SoundEvents.f_12519_;
        this.use = (p, l, h) -> true;
        this.useAnimation(UseAnim.SPEAR);
        this.maxStackSize = 1;
        ResourceLocation tag = ItemTags.f_271470_.f_203868_();
        ResourceLocation tag2 = Tags.Items.TOOLS_TRIDENTS.f_203868_();
        ResourceLocation tag3 = Tags.Items.TOOLS.f_203868_();
        ResourceLocation tag4 = ItemTags.f_271540_.f_203868_();
        this.tag(tag);
        this.tag(tag2);
        this.tag(tag3);
        this.tag(tag4);
    }

    @Info(value="Sets the sound event for the riptide level 3")
    public void setRiptide3Sound(SoundEvent riptide3Sound) {
        this.riptide3Sound = riptide3Sound;
    }

    @Info(value="Sets the sound event for the riptide level 2")
    public void setRiptide2Sound(SoundEvent riptide2Sound) {
        this.riptide2Sound = riptide2Sound;
    }

    @Info(value="Sets the sound event for the riptide level 1")
    public void setRiptide1Sound(SoundEvent riptide1Sound) {
        this.riptide1Sound = riptide1Sound;
    }

    @Info(value="Sets the sound event for throwing the item")
    public void setThrowSound(SoundEvent throwSound) {
        this.throwSound = throwSound;
    }

    @Override
    public Item createObject() {
        return new TridentItem(this.createItemProperties()){

            public int m_8105_(ItemStack pStack) {
                return TridentItemBuilder.this.useDuration != null ? TridentItemBuilder.this.useDuration.applyAsInt(pStack) : 72000;
            }

            public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
                if (TridentItemBuilder.this.use != null && TridentItemBuilder.this.use.use(pLevel, pPlayer, pHand)) {
                    ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
                }
                ItemStack $$3 = pPlayer.m_21120_(pHand);
                if (TridentItemBuilder.this.canThrow) {
                    if (!pLevel.f_46443_) {
                        float pZ = TridentItemBuilder.this.projectileZ;
                        float pVelocity = TridentItemBuilder.this.projectileVelocity;
                        float pInaccuracy = TridentItemBuilder.this.projectileInaccuracy;
                        BuilderBase builderBase = TridentItemBuilder.this.parent;
                        if (builderBase instanceof TridentJSBuilder) {
                            TridentJSBuilder builder = (TridentJSBuilder)builderBase;
                            TridentEntityJS $$4 = new TridentEntityJS(builder, (EntityType<? extends TridentEntityJS>)((EntityType)builder.get()), (LivingEntity)pPlayer, pLevel, $$3);
                            $$4.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), pZ, pVelocity, pInaccuracy);
                            pLevel.m_7967_((Entity)$$4);
                        }
                    }
                    pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    if (!pPlayer.m_150110_().f_35937_) {
                        $$3.m_41774_(1);
                    }
                    return InteractionResultHolder.m_19092_((Object)$$3, (boolean)pLevel.m_5776_());
                }
                if ($$3.m_41773_() >= $$3.m_41776_() - 1) {
                    return InteractionResultHolder.m_19100_((Object)$$3);
                }
                if (EnchantmentHelper.m_44932_((ItemStack)$$3) > 0 && !pPlayer.m_20070_()) {
                    return InteractionResultHolder.m_19100_((Object)$$3);
                }
                pPlayer.m_6672_(pHand);
                return InteractionResultHolder.m_19096_((Object)$$3);
            }

            public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
                if (TridentItemBuilder.this.releaseUsing != null) {
                    TridentItemBuilder.this.releaseUsing.releaseUsing(pStack, pLevel, pEntityLiving, pTimeLeft);
                }
                if (pEntityLiving instanceof Player) {
                    int $$6;
                    Player $$4 = (Player)pEntityLiving;
                    int $$5 = this.m_8105_(pStack) - pTimeLeft;
                    if ($$5 >= 10 && (($$6 = EnchantmentHelper.m_44932_((ItemStack)pStack)) <= 0 || $$4.m_20070_())) {
                        if (!pLevel.f_46443_) {
                            pStack.m_41622_(1, (LivingEntity)$$4, p_43388_ -> p_43388_.m_21190_(pEntityLiving.m_7655_()));
                            if ($$6 == 0) {
                                float pZ = TridentItemBuilder.this.projectileZ;
                                float pVelocity = TridentItemBuilder.this.projectileVelocity;
                                float pInaccuracy = TridentItemBuilder.this.projectileInaccuracy;
                                TridentEntityJS $$7 = new TridentEntityJS((TridentJSBuilder)TridentItemBuilder.this.parent, (EntityType<? extends TridentEntityJS>)((EntityType)TridentItemBuilder.this.parent.get()), pEntityLiving, pLevel, pStack);
                                $$7.m_37251_((Entity)$$4, $$4.m_146909_(), $$4.m_146908_(), pZ, 2.5f + (float)$$6 * 0.5f + pVelocity, pInaccuracy);
                                if ($$4.m_150110_().f_35937_) {
                                    $$7.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                                }
                                pLevel.m_7967_((Entity)$$7);
                                pLevel.m_6269_((Player)null, (Entity)$$7, TridentItemBuilder.this.throwSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                                if (!$$4.m_150110_().f_35937_) {
                                    $$4.m_150109_().m_36057_(pStack);
                                }
                            }
                        }
                        $$4.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        if ($$6 > 0) {
                            float $$8 = $$4.m_146908_();
                            float $$9 = $$4.m_146909_();
                            float $$10 = -Mth.m_14031_((float)($$8 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$9 * ((float)Math.PI / 180)));
                            float $$11 = -Mth.m_14031_((float)($$9 * ((float)Math.PI / 180)));
                            float $$12 = Mth.m_14089_((float)($$8 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$9 * ((float)Math.PI / 180)));
                            float $$13 = Mth.m_14116_((float)($$10 * $$10 + $$11 * $$11 + $$12 * $$12));
                            float $$14 = 3.0f * ((1.0f + (float)$$6) / 4.0f);
                            $$4.m_5997_((double)($$10 *= $$14 / $$13), (double)($$11 *= $$14 / $$13), (double)($$12 *= $$14 / $$13));
                            $$4.m_204079_(20);
                            if ($$4.m_20096_()) {
                                float $$15 = 1.1999999f;
                                $$4.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                            }
                            SoundEvent $$18 = $$6 >= 3 ? TridentItemBuilder.this.riptide3Sound : ($$6 == 2 ? TridentItemBuilder.this.riptide2Sound : TridentItemBuilder.this.riptide1Sound);
                            pLevel.m_6269_((Player)null, (Entity)$$4, $$18, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    }
                }
            }
        };
    }
}

