/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryEventJS;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import java.util.List;
import java.util.function.Consumer;
import net.liopyu.entityjs.builders.misc.CustomEntityBuilder;
import net.liopyu.entityjs.builders.modification.ModifyEntityBuilder;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.implementation.IRegistryJS;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RegistryEventJS.class})
public class RegistryEventJSMixin<T>
implements IRegistryJS {
    @Final
    @Shadow
    private RegistryInfo<T> registry;
    @Final
    @Shadow
    public List<BuilderBase<? extends T>> created;

    @Override
    @Info(value="Creates a new custom entity based on an existing entity class.\nThis allows extending or modifying behavior of vanilla or modded entities dynamically.\n\nThe builder provided in the callback can be used to directly access the respective entity's modification builder.\n\nExample usage:\n```javascript\nlet Villager = Java.loadClass(\"net.minecraft.world.entity.npc.Villager\")\nevent.createCustom('wyrm', Villager, modifyBuilder => {\n    modifyBuilder.tick(entity => {\n        console.log(entity.type)\n    })\n})\n```\n")
    public CustomEntityBuilder entityJs$createCustom(String id, Class<? extends Entity> entityClass, Consumer<ModifyEntityBuilder> consumer) {
        if (!Entity.class.isAssignableFrom(entityClass)) {
            throw new IllegalArgumentException("Tried to create entity from a class that does not extend Entity. Id: " + id);
        }
        ResourceLocation rl = UtilsJS.getMCID((Context)((ScriptManager)ScriptType.STARTUP.manager.get()).context, (Object)KubeJS.appendModId((String)id));
        CustomEntityBuilder b = null;
        if (LivingEntity.class.isAssignableFrom(entityClass)) {
            b = new CustomEntityBuilder(rl, entityClass);
        }
        if (b == null) {
            throw new IllegalArgumentException("CustomEntityBuilder is null for entity id: " + id);
        }
        this.registry.addBuilder((BuilderBase)b);
        this.created.add(b);
        EntityModificationEventJS.createCustomMap.put(rl, consumer);
        return b;
    }
}

