/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.PalladiumConfig;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.block.IAddonBlock;
import net.threetag.palladium.block.PalladiumBlocks;
import net.threetag.palladium.client.PalladiumKeyMappings;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.client.energybeam.EnergyBeamManager;
import net.threetag.palladium.client.model.SuitStandBasePlateModel;
import net.threetag.palladium.client.model.SuitStandModel;
import net.threetag.palladium.client.model.animation.AimAnimation;
import net.threetag.palladium.client.model.animation.FlightAnimation;
import net.threetag.palladium.client.model.animation.HoveringAnimation;
import net.threetag.palladium.client.model.animation.LevitationAnimation;
import net.threetag.palladium.client.model.animation.PalladiumAnimationRegistry;
import net.threetag.palladium.client.particleemitter.ParticleEmitterManager;
import net.threetag.palladium.client.renderer.WatcherRenderer;
import net.threetag.palladium.client.renderer.entity.CustomProjectileRenderer;
import net.threetag.palladium.client.renderer.entity.EffectEntityRenderer;
import net.threetag.palladium.client.renderer.entity.SuitStandRenderer;
import net.threetag.palladium.client.renderer.entity.TrailSegmentEntityRenderer;
import net.threetag.palladium.client.renderer.item.armor.ArmorRendererManager;
import net.threetag.palladium.client.renderer.renderlayer.AccessoryRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.client.screen.AbilityBarRenderer;
import net.threetag.palladium.client.screen.AbilityWheelRenderer;
import net.threetag.palladium.client.screen.AccessoryScreen;
import net.threetag.palladium.client.screen.AddonPackLogScreen;
import net.threetag.palladium.client.screen.components.IconButton;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.compat.geckolib.GeckoLibCompat;
import net.threetag.palladium.compat.mermod.MermodClientCompatImpl;
import net.threetag.palladium.energy.EnergyHelper;
import net.threetag.palladium.energy.IEnergyStorage;
import net.threetag.palladium.entity.PalladiumEntityTypes;
import net.threetag.palladium.event.PalladiumClientEvents;
import net.threetag.palladium.item.AddonBowItem;
import net.threetag.palladium.item.AddonCrossbowItem;
import net.threetag.palladium.item.AddonShieldItem;
import net.threetag.palladium.item.EnergyItem;
import net.threetag.palladium.item.Openable;
import net.threetag.palladium.item.PalladiumItems;
import net.threetag.palladium.power.ability.AbilityClientEventHandler;
import net.threetag.palladium.power.ability.GuiOverlayAbility;
import net.threetag.palladium.util.SupporterHandler;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.TexturedIcon;
import net.threetag.palladiumcore.event.LifecycleEvents;
import net.threetag.palladiumcore.event.ScreenEvents;
import net.threetag.palladiumcore.registry.ReloadListenerRegistry;
import net.threetag.palladiumcore.registry.client.ColorHandlerRegistry;
import net.threetag.palladiumcore.registry.client.EntityRendererRegistry;
import net.threetag.palladiumcore.registry.client.ItemPropertyRegistry;
import net.threetag.palladiumcore.registry.client.OverlayRegistry;
import net.threetag.palladiumcore.registry.client.RenderTypeRegistry;
import net.threetag.palladiumcore.util.Platform;

public class PalladiumClient {
    public static final IIcon ICON = new TexturedIcon(Palladium.id("textures/icon/palladium.png"));

    public static void init() {
        PalladiumClient.colorHandlers();
        PalladiumKeyMappings.init();
        PowersScreen.register();
        AccessoryScreen.addButton();
        SupporterHandler.clientInit();
        PalladiumClient.setupDevLogButton();
        AbilityClientEventHandler.init();
        WatcherRenderer.init();
        LifecycleEvents.SETUP.register(() -> {
            PalladiumClient.blockRenderTypes();
            PalladiumClient.itemModelPredicates();
        });
        EntityRendererRegistry.register(PalladiumEntityTypes.EFFECT, EffectEntityRenderer::new);
        EntityRendererRegistry.register(PalladiumEntityTypes.TRAIL_SEGMENT, TrailSegmentEntityRenderer::new);
        EntityRendererRegistry.register(PalladiumEntityTypes.CUSTOM_PROJECTILE, CustomProjectileRenderer::new);
        EntityRendererRegistry.register(PalladiumEntityTypes.SUIT_STAND, SuitStandRenderer::new);
        EntityRendererRegistry.registerModelLayer((ModelLayerLocation)SuitStandModel.MODEL_LAYER_LOCATION, SuitStandModel::createBodyLayer);
        EntityRendererRegistry.registerModelLayer((ModelLayerLocation)SuitStandBasePlateModel.MODEL_LAYER_LOCATION, SuitStandBasePlateModel::createLayer);
        EntityRendererRegistry.addRenderLayer(e -> true, renderLayerParent -> new PackRenderLayerRenderer((RenderLayerParent<Entity, EntityModel<Entity>>)renderLayerParent));
        EntityRendererRegistry.addRenderLayerToPlayer(renderLayerParent -> new AccessoryRenderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderLayerParent));
        PalladiumClientEvents.REGISTER_ANIMATIONS.register(registry -> {
            registry.accept(Palladium.id("hovering"), new HoveringAnimation(-30));
            registry.accept(Palladium.id("levitation"), new LevitationAnimation(-20));
            registry.accept(Palladium.id("flight"), new FlightAnimation(-10));
            registry.accept(Palladium.id("aim"), new AimAnimation(100));
        });
        OverlayRegistry.registerOverlay((String)"palladium/ability_bar", (OverlayRegistry.IngameOverlay)new AbilityBarRenderer());
        OverlayRegistry.registerOverlay((String)"palladium/gui_overlay_abilities", (OverlayRegistry.IngameOverlay)new GuiOverlayAbility.Renderer());
        OverlayRegistry.registerOverlay((String)"palladium/ability_wheel", (OverlayRegistry.IngameOverlay)new AbilityWheelRenderer());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (ResourceLocation)Palladium.id("dynamic_textures"), (PreparableReloadListener)new DynamicTextureManager());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (ResourceLocation)Palladium.id("pack_render_layers"), (PreparableReloadListener)new PackRenderLayerManager());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (ResourceLocation)Palladium.id("armor_renderers"), (PreparableReloadListener)new ArmorRendererManager());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (ResourceLocation)Palladium.id("accessory_renderers"), (PreparableReloadListener)new Accessory.ReloadManager());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (ResourceLocation)Palladium.id("humanoid_animations"), (PreparableReloadListener)PalladiumAnimationRegistry.INSTANCE);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (ResourceLocation)Palladium.id("trail_renderers"), (PreparableReloadListener)TrailRendererManager.INSTANCE);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (ResourceLocation)Palladium.id("particle_emitters"), (PreparableReloadListener)ParticleEmitterManager.INSTANCE);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (ResourceLocation)Palladium.id("energy_beams"), (PreparableReloadListener)EnergyBeamManager.INSTANCE);
        if (Platform.isModLoaded((String)"geckolib")) {
            GeckoLibCompat.initClient();
        }
        if (Platform.isModLoaded((String)"mermod")) {
            MermodClientCompatImpl.init();
        }
    }

    public static void blockRenderTypes() {
        RenderTypeRegistry.registerBlock((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)PalladiumBlocks.HEART_SHAPED_HERB.get(), (Block)PalladiumBlocks.POTTED_HEART_SHAPED_HERB.get(), (Block)PalladiumBlocks.SMALL_REDSTONE_FLUX_CRYSTAL_BUD.get(), (Block)PalladiumBlocks.MEDIUM_REDSTONE_FLUX_CRYSTAL_BUD.get(), (Block)PalladiumBlocks.LARGE_REDSTONE_FLUX_CRYSTAL_BUD.get(), (Block)PalladiumBlocks.REDSTONE_FLUX_CRYSTAL_CLUSTER.get()});
        for (Block block : BuiltInRegistries.f_256975_) {
            IAddonBlock addonBlock;
            String type;
            if (!(block instanceof IAddonBlock) || (type = (addonBlock = (IAddonBlock)block).getRenderType()) == null) continue;
            if (type.equalsIgnoreCase("solid")) {
                RenderTypeRegistry.registerBlock((RenderType)RenderType.m_110451_(), (Block[])new Block[]{block});
                continue;
            }
            if (type.equalsIgnoreCase("cutout_mipped")) {
                RenderTypeRegistry.registerBlock((RenderType)RenderType.m_110457_(), (Block[])new Block[]{block});
                continue;
            }
            if (type.equalsIgnoreCase("cutout")) {
                RenderTypeRegistry.registerBlock((RenderType)RenderType.m_110463_(), (Block[])new Block[]{block});
                continue;
            }
            if (!type.equalsIgnoreCase("translucent")) continue;
            RenderTypeRegistry.registerBlock((RenderType)RenderType.m_110466_(), (Block[])new Block[]{block});
        }
    }

    public static void itemModelPredicates() {
        for (Item item : BuiltInRegistries.f_257033_) {
            if (item instanceof EnergyItem) {
                ItemPropertyRegistry.register((Item)item, (ResourceLocation)Palladium.id("energy"), (itemStack, clientLevel, livingEntity, i) -> {
                    Optional<IEnergyStorage> storage = EnergyHelper.getFromItemStack(itemStack);
                    return storage.map(energyStorage -> Math.round(13.0f * (float)energyStorage.getEnergyAmount() / (float)energyStorage.getEnergyCapacity())).orElse(0).intValue();
                });
                ItemPropertyRegistry.register((Item)item, (ResourceLocation)Palladium.id("charged"), (itemStack, clientLevel, livingEntity, i) -> itemStack.m_41784_().m_128451_("energy") > 0 ? 1.0f : 0.0f);
            }
            if (item instanceof Openable) {
                Openable openable = (Openable)item;
                ItemPropertyRegistry.register((Item)item, (ResourceLocation)Palladium.id("opened"), (itemStack, clientLevel, livingEntity, i) -> {
                    int max = openable.getOpeningTime(itemStack);
                    if (max > 0) {
                        return (float)openable.getOpeningProgress(itemStack) / (float)max;
                    }
                    return openable.isOpen(itemStack) ? 1.0f : 0.0f;
                });
            }
            if (item instanceof AddonShieldItem) {
                ItemPropertyRegistry.register((Item)item, (ResourceLocation)new ResourceLocation("blocking"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
            }
            if (item instanceof AddonBowItem) {
                ItemPropertyRegistry.register((Item)item, (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientLevel, livingEntity, i) -> {
                    if (livingEntity == null) {
                        return 0.0f;
                    }
                    return livingEntity.m_21211_() != itemStack ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / 20.0f;
                });
                ItemPropertyRegistry.register((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
            }
            if (!(item instanceof AddonCrossbowItem)) continue;
            ItemPropertyRegistry.register((Item)item, (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientLevel, livingEntity, i) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return CrossbowItem.m_40932_((ItemStack)itemStack) ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / (float)CrossbowItem.m_40939_((ItemStack)itemStack);
            });
            ItemPropertyRegistry.register((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack && !CrossbowItem.m_40932_((ItemStack)itemStack) ? 1.0f : 0.0f);
            ItemPropertyRegistry.register((Item)item, (ResourceLocation)new ResourceLocation("charged"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && CrossbowItem.m_40932_((ItemStack)itemStack) ? 1.0f : 0.0f);
            ItemPropertyRegistry.register((Item)item, (ResourceLocation)new ResourceLocation("firework"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && CrossbowItem.m_40932_((ItemStack)itemStack) && CrossbowItem.m_40871_((ItemStack)itemStack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
        }
    }

    public static void colorHandlers() {
        ColorHandlerRegistry.registerItemColors((itemStack, i) -> i > 0 ? -1 : ((DyeableLeatherItem)itemStack.m_41720_()).m_41121_(itemStack), (Supplier[])new Supplier[]{PalladiumItems.VIBRANIUM_WEAVE_BOOTS});
    }

    public static void setupDevLogButton() {
        ScreenEvents.INIT_POST.register(screen -> {
            if (((Boolean)PalladiumConfig.Client.ADDON_PACK_DEV_MODE.get()).booleanValue() && (screen instanceof TitleScreen || screen instanceof PauseScreen)) {
                screen.m_142416_((GuiEventListener)IconButton.builder(ICON, button -> Minecraft.m_91087_().m_91152_((Screen)new AddonPackLogScreen(AddonPackLog.getEntries(), screen))).pos(screen.f_96543_ - 30, 10).tooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.palladium.addon_pack_log"))).build());
            }
        });
    }
}

