/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.AccessoryPlayerData;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.util.SupporterHandler;
import net.threetag.palladiumcore.registry.PalladiumRegistry;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.Nullable;

public abstract class Accessory {
    public static final PalladiumRegistry<Accessory> REGISTRY = PalladiumRegistry.create(Accessory.class, (ResourceLocation)Palladium.id("accessories"));
    private boolean exclusive = false;

    public boolean isAvailable(Player entity) {
        return this.isAvailable(SupporterHandler.getPlayerData(entity.m_20148_()));
    }

    public boolean isAvailable(SupporterHandler.PlayerData data) {
        return !this.exclusive || !Platform.isProduction() || data.hasAccessory(this);
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)Util.m_137492_((String)"accessory", (ResourceLocation)REGISTRY.getKey((Object)this)));
    }

    public String toString() {
        return REGISTRY.getKey((Object)this).toString();
    }

    public Accessory setExclusive() {
        this.exclusive = true;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onReload(EntityModelSet entityModelSet) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent, AccessorySlot slot, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderArm(HumanoidArm arm, AbstractClientPlayer player, PlayerRenderer playerRenderer, ModelPart armPart, ModelPart armWearPart, AccessorySlot slot, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isVisible(AccessorySlot slot, AbstractClientPlayer player, boolean isFirstPerson) {
        return (slot.getCorrespondingEquipmentSlot() == null || player.m_6844_(slot.getCorrespondingEquipmentSlot()).m_41619_()) && !slot.wasHidden((Player)player, isFirstPerson);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canRenderAsArm(AccessorySlot slot, HumanoidArm arm, AbstractClientPlayer player) {
        if (player.m_5737_() == HumanoidArm.RIGHT) {
            if (slot == AccessorySlot.MAIN_ARM || slot == AccessorySlot.MAIN_HAND) {
                return arm == HumanoidArm.RIGHT;
            }
            if (slot == AccessorySlot.OFF_ARM || slot == AccessorySlot.OFF_HAND) {
                return arm == HumanoidArm.LEFT;
            }
        } else {
            if (slot == AccessorySlot.MAIN_ARM || slot == AccessorySlot.MAIN_HAND) {
                return arm == HumanoidArm.LEFT;
            }
            if (slot == AccessorySlot.OFF_ARM || slot == AccessorySlot.OFF_HAND) {
                return arm == HumanoidArm.RIGHT;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ModelPart getArm(PlayerModel<?> model, boolean mainHand, HumanoidArm primaryHand) {
        if (mainHand) {
            return primaryHand == HumanoidArm.RIGHT ? model.f_102811_ : model.f_102812_;
        }
        return primaryHand == HumanoidArm.RIGHT ? model.f_102812_ : model.f_102811_;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public RenderType getRenderType(AbstractClientPlayer player, ResourceLocation resourceLocation, Model model) {
        boolean flag1;
        boolean flag = !player.m_20145_();
        boolean bl = flag1 = !flag && !player.m_20177_((Player)Minecraft.m_91087_().f_91074_);
        if (flag1) {
            return RenderType.m_110473_((ResourceLocation)resourceLocation);
        }
        if (flag) {
            return model.m_103119_(resourceLocation);
        }
        return Minecraft.m_91087_().m_91314_((Entity)player) ? RenderType.m_110491_((ResourceLocation)resourceLocation) : null;
    }

    public abstract Collection<AccessorySlot> getPossibleSlots();

    public static List<Accessory> getAvailableAccessories(SupporterHandler.PlayerData data) {
        ArrayList<Accessory> list = new ArrayList<Accessory>();
        for (Accessory accessory : REGISTRY.getValues()) {
            if (!accessory.isAvailable(data)) continue;
            list.add(accessory);
        }
        return list;
    }

    public static List<Accessory> getAvailableAccessories(SupporterHandler.PlayerData data, AccessorySlot slot) {
        ArrayList<Accessory> list = new ArrayList<Accessory>();
        for (Accessory accessory : REGISTRY.getValues()) {
            if (!accessory.getPossibleSlots().contains(slot) || !accessory.isAvailable(data)) continue;
            list.add(accessory);
        }
        return list;
    }

    public static Optional<AccessoryPlayerData> getPlayerData(Player player) {
        if (player instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension ext = (PalladiumPlayerExtension)player;
            return Optional.of(ext.palladium$getAccessories());
        }
        return Optional.empty();
    }

    public static class ReloadManager
    implements ResourceManagerReloadListener {
        public void m_6213_(ResourceManager resourceManager) {
            for (Accessory accessory : REGISTRY.getValues()) {
                accessory.onReload(Minecraft.m_91087_().m_167973_());
            }
        }
    }
}

