/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.network.SyncAccessoriesMessage;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.Nullable;

public class AccessoryPlayerData {
    public Map<AccessorySlot, Collection<Accessory>> accessories = new HashMap<AccessorySlot, Collection<Accessory>>();

    public void enable(AccessorySlot slot, Accessory accessory, Player player) {
        if (slot != null && accessory != null && accessory.getPossibleSlots().contains(slot) && this.canEnable(accessory, player)) {
            if (slot.allowsMultiple()) {
                Collection accessories = this.accessories.computeIfAbsent(slot, accessorySlot -> new ArrayList());
                if (!accessories.contains(accessory)) {
                    accessories.add(accessory);
                }
            } else {
                this.accessories.put(slot, Collections.singletonList(accessory));
            }
            if (!player.m_9236_().f_46443_) {
                new SyncAccessoriesMessage(player.m_19879_(), this.accessories).sendToDimension(player.m_9236_());
            }
        }
    }

    public boolean canEnable(Accessory accessory, Player player) {
        return Platform.isClient() || accessory.isAvailable(player);
    }

    public void disable(AccessorySlot slot, @Nullable Accessory accessory, Player player) {
        if (slot != null && accessory != null) {
            if (slot.allowsMultiple()) {
                Collection accessories = this.accessories.computeIfAbsent(slot, accessorySlot -> new ArrayList());
                accessories.remove(accessory);
            } else {
                this.accessories.put(slot, new ArrayList());
            }
            if (!player.m_9236_().f_46443_) {
                new SyncAccessoriesMessage(player.m_19879_(), this.accessories).sendToDimension(player.m_9236_());
            }
        }
    }

    public void validate(Player player) {
        ArrayList disable = new ArrayList();
        this.accessories.forEach((slot, accessories) -> {
            for (Accessory accessory : accessories) {
                if (this.canEnable(accessory, player)) continue;
                disable.add(Pair.of((Object)slot, (Object)accessory));
            }
        });
        for (Pair pair : disable) {
            this.disable((AccessorySlot)pair.getFirst(), (Accessory)pair.getSecond(), player);
        }
    }

    public void clear(Player player) {
        this.accessories.clear();
        for (AccessorySlot slot : AccessorySlot.getSlots()) {
            this.accessories.put(slot, new ArrayList());
        }
        if (!player.m_9236_().f_46443_) {
            new SyncAccessoriesMessage(player.m_19879_(), this.accessories).sendToDimension(player.m_9236_());
        }
    }

    public Map<AccessorySlot, Collection<Accessory>> getSlots() {
        return this.accessories;
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        this.accessories.forEach((slot, list) -> {
            ListTag listNBT = new ListTag();
            for (Accessory accessory : list) {
                listNBT.add((Object)StringTag.m_129297_((String)Objects.requireNonNull(Accessory.REGISTRY.getKey((Object)accessory)).toString()));
            }
            nbt.m_128365_(slot.getName().toString(), (Tag)listNBT);
        });
        return nbt;
    }

    public void fromNBT(CompoundTag nbt) {
        this.accessories = new HashMap<AccessorySlot, Collection<Accessory>>();
        for (AccessorySlot slot : AccessorySlot.getSlots()) {
            ListTag listNBT = nbt.m_128437_(slot.getName().toString(), 8);
            ArrayList<Accessory> accessories = new ArrayList<Accessory>();
            for (int i = 0; i < listNBT.size(); ++i) {
                Accessory accessory = (Accessory)Accessory.REGISTRY.get(new ResourceLocation(listNBT.m_128778_(i)));
                if (accessory == null) continue;
                accessories.add(accessory);
            }
            this.accessories.put(slot, accessories);
        }
    }
}

