/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.Nullable;

public class AccessorySlot {
    private static final List<AccessorySlot> SLOTS = Lists.newArrayList();
    public static final AccessorySlot HAT = AccessorySlot.register("hat").setSortIndex(1).setIcon(Palladium.id("textures/gui/accessory_slots/hat.png")).setCorrespondingEquipmentSlot(EquipmentSlot.HEAD);
    public static final AccessorySlot HEAD = AccessorySlot.register("head").setSortIndex(2).setIcon(Palladium.id("textures/gui/accessory_slots/head.png"));
    public static final AccessorySlot FACE = AccessorySlot.register("face").setSortIndex(3).setIcon(Palladium.id("textures/gui/accessory_slots/face.png"));
    public static final AccessorySlot CHEST = AccessorySlot.register("chest").setSortIndex(4).setIcon(Palladium.id("textures/gui/accessory_slots/chest.png"));
    public static final AccessorySlot BACK = AccessorySlot.register("back").setSortIndex(5).setIcon(Palladium.id("textures/gui/accessory_slots/back.png"));
    public static final AccessorySlot MAIN_ARM = AccessorySlot.register("main_arm").setSortIndex(6).setIcon(Palladium.id("textures/gui/accessory_slots/main_arm.png"));
    public static final AccessorySlot OFF_ARM = AccessorySlot.register("off_arm").setSortIndex(7).setIcon(Palladium.id("textures/gui/accessory_slots/off_arm.png"));
    public static final AccessorySlot MAIN_HAND = AccessorySlot.register("main_hand").setSortIndex(8).setIcon(Palladium.id("textures/gui/accessory_slots/main_hand.png")).setCorrespondingEquipmentSlot(EquipmentSlot.MAINHAND);
    public static final AccessorySlot OFF_HAND = AccessorySlot.register("off_hand").setSortIndex(9).setIcon(Palladium.id("textures/gui/accessory_slots/off_hand.png")).setCorrespondingEquipmentSlot(EquipmentSlot.OFFHAND);
    public static final AccessorySlot RIGHT_LEG = AccessorySlot.register("right_leg").setSortIndex(10).setIcon(Palladium.id("textures/gui/accessory_slots/right_leg.png"));
    public static final AccessorySlot LEFT_LEG = AccessorySlot.register("left_leg").setSortIndex(11).setIcon(Palladium.id("textures/gui/accessory_slots/left_leg.png"));
    public static final AccessorySlot SPECIAL = AccessorySlot.register("special").setSortIndex(12).setIcon(Palladium.id("textures/gui/accessory_slots/special.png")).allowMultiple();
    private final ResourceLocation name;
    private boolean multiple = false;
    private EquipmentSlot equipmentSlot;
    private ResourceLocation icon;
    private List<Condition> visible = new ArrayList<Condition>();
    private int sortIndex = 20;

    private AccessorySlot(ResourceLocation name) {
        this.name = name;
    }

    public AccessorySlot allowMultiple() {
        this.multiple = true;
        return this;
    }

    public AccessorySlot setCorrespondingEquipmentSlot(EquipmentSlot slot) {
        this.equipmentSlot = slot;
        return this;
    }

    public AccessorySlot setIcon(ResourceLocation icon) {
        this.icon = icon;
        return this;
    }

    public AccessorySlot setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
        return this;
    }

    public AccessorySlot addVisibilityCondition(Condition condition) {
        if (Platform.isClient()) {
            this.visible.add(condition);
        }
        return this;
    }

    public EquipmentSlot getCorrespondingEquipmentSlot() {
        return this.equipmentSlot;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return Util.m_137492_((String)"accessory_slot", (ResourceLocation)this.name);
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    public boolean allowsMultiple() {
        return this.multiple;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public boolean isVisible(DataContext context) {
        return ConditionSerializer.checkConditions(this.visible, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean wasHidden(Player player, boolean isFirstPerson) {
        BodyPart.ModifiedBodyPartResult result = BodyPart.getModifiedBodyParts((LivingEntity)player, isFirstPerson, false);
        return this.getHiddenBodyParts(player).stream().filter(p -> !p.isOverlay()).anyMatch(result::isHiddenOrRemoved);
    }

    public Collection<BodyPart> getHiddenBodyParts(Player player) {
        if (this == HEAD) {
            return Arrays.asList(BodyPart.HEAD, BodyPart.HEAD_OVERLAY);
        }
        if (this == CHEST) {
            return Arrays.asList(BodyPart.CHEST, BodyPart.CHEST_OVERLAY);
        }
        if (this == MAIN_ARM) {
            return player.m_5737_() == HumanoidArm.RIGHT ? Arrays.asList(BodyPart.RIGHT_ARM, BodyPart.RIGHT_ARM_OVERLAY) : Arrays.asList(BodyPart.LEFT_ARM, BodyPart.LEFT_ARM_OVERLAY);
        }
        if (this == OFF_ARM) {
            return player.m_5737_() != HumanoidArm.RIGHT ? Arrays.asList(BodyPart.RIGHT_ARM, BodyPart.RIGHT_ARM_OVERLAY) : Arrays.asList(BodyPart.LEFT_ARM, BodyPart.LEFT_ARM_OVERLAY);
        }
        if (this == RIGHT_LEG) {
            return Arrays.asList(BodyPart.RIGHT_LEG, BodyPart.RIGHT_LEG_OVERLAY);
        }
        if (this == LEFT_LEG) {
            return Arrays.asList(BodyPart.LEFT_LEG, BodyPart.LEFT_LEG_OVERLAY);
        }
        return Collections.emptyList();
    }

    public static AccessorySlot register(ResourceLocation name) {
        AccessorySlot slot = new AccessorySlot(name);
        SLOTS.add(slot);
        return slot;
    }

    private static AccessorySlot register(String name) {
        AccessorySlot slot = new AccessorySlot(Palladium.id(name));
        SLOTS.add(slot);
        return slot;
    }

    @Nullable
    public static AccessorySlot getSlotByName(ResourceLocation name) {
        for (AccessorySlot slot : SLOTS) {
            if (!slot.getName().equals((Object)name)) continue;
            return slot;
        }
        return null;
    }

    public static List<AccessorySlot> getSlots() {
        return ImmutableList.copyOf(SLOTS);
    }
}

