/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.accessory.DefaultAccessory;
import net.threetag.palladium.accessory.OverlayAccessory;
import net.threetag.palladium.addonpack.parser.AccessoryParser;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.ModelLayerLocationUtil;
import net.threetag.palladium.util.PlayerUtil;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class HumanoidModelOverlayAccessory
extends OverlayAccessory {
    private final Supplier<Object> modelLayer;
    private final Supplier<Object> modelLayerSlim;
    private Object model;
    private Object modelSlim;

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, TextureReference texture, TextureReference textureSlim) {
        super(texture, textureSlim);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, TextureReference texture, TextureReference textureSlim) {
        super(texture, textureSlim);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, TextureReference texture) {
        super(texture);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, TextureReference texture) {
        super(texture);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, ResourceLocation texture, ResourceLocation textureSlim) {
        super(texture, textureSlim);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, ResourceLocation texture, ResourceLocation textureSlim) {
        super(texture, textureSlim);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, ResourceLocation texture) {
        super(texture);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, ResourceLocation texture) {
        super(texture);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, String texture, String textureSlim) {
        super(texture, textureSlim);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, String texture, String textureSlim) {
        super(texture, textureSlim);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, String texture) {
        super(texture);
        this.modelLayerSlim = modelLayer;
        this.modelLayer = this.modelLayerSlim;
    }

    public HumanoidModelOverlayAccessory(Supplier<Object> modelLayer, Supplier<Object> modelLayerSlim, String texture) {
        super(texture);
        this.modelLayer = modelLayer;
        this.modelLayerSlim = modelLayerSlim;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onReload(EntityModelSet entityModelSet) {
        ModelLayerLocation loc1;
        Object loc = this.modelLayer.get();
        Object locSlim = this.modelLayerSlim.get();
        if (loc instanceof ModelLayerLocation) {
            loc1 = (ModelLayerLocation)loc;
            this.model = new HumanoidModel(entityModelSet.m_171103_(loc1));
        }
        if (locSlim instanceof ModelLayerLocation) {
            loc1 = (ModelLayerLocation)locSlim;
            this.modelSlim = new HumanoidModel(entityModelSet.m_171103_(loc1));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent, AccessorySlot slot, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Object object = this.getModel(player);
        if (object instanceof HumanoidModel) {
            HumanoidModel model = (HumanoidModel)object;
            ((PlayerModel)renderLayerParent.m_7200_()).m_102872_(model);
            this.setVisibility(model, player, slot);
            ResourceLocation texture = (PlayerUtil.hasSmallArms((Player)player) ? this.textureSlim : this.texture).getTexture(DataContext.forEntity((Entity)player));
            RenderType renderType = this.getRenderType(player, texture, (Model)renderLayerParent.m_7200_());
            if (renderType != null) {
                VertexConsumer buffer = bufferSource.m_6299_(this.glowing ? RenderType.m_110488_((ResourceLocation)texture) : renderType);
                model.m_7695_(poseStack, buffer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderArm(HumanoidArm arm, AbstractClientPlayer player, PlayerRenderer playerRenderer, ModelPart armPart, ModelPart armWearPart, AccessorySlot slot, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Object object = this.getModel(player);
        if (object instanceof HumanoidModel) {
            HumanoidModel model = (HumanoidModel)object;
            ResourceLocation texture = (PlayerUtil.hasSmallArms((Player)player) ? this.textureSlim : this.texture).getTexture(DataContext.forEntity((Entity)player));
            VertexConsumer buffer = bufferSource.m_6299_(this.glowing ? RenderType.m_110488_((ResourceLocation)texture) : Objects.requireNonNull(this.getRenderType(player, texture, (Model)playerRenderer.m_7200_())));
            model.f_102811_.m_104315_(armPart);
            model.f_102811_.f_104207_ = true;
            model.f_102811_.m_104301_(poseStack, buffer, packedLight, OverlayTexture.f_118083_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getModel(AbstractClientPlayer player) {
        return PlayerUtil.hasSmallArms((Player)player) ? this.modelSlim : this.model;
    }

    public static class Serializer
    implements AccessoryParser.TypeSerializer {
        @Override
        public DefaultAccessory parse(JsonObject json) {
            SkinTypedValue<TextureReference> texture = SkinTypedValue.fromJSON(json.get("texture"), j -> TextureReference.parse(j.getAsString()));
            SkinTypedValue<ModelLayerLocationUtil> modelLayer = SkinTypedValue.fromJSON(json.get("model_layer"), j -> GsonUtil.convertToModelLayerLocationUtil(j, "model_layer"));
            HumanoidModelOverlayAccessory accessory = new HumanoidModelOverlayAccessory(modelLayer::getNormal, modelLayer::getSlim, texture.getNormal(), texture.getSlim());
            if (GsonHelper.m_13855_((JsonObject)json, (String)"glowing", (boolean)false)) {
                accessory.glowing();
            }
            if (GsonHelper.m_13855_((JsonObject)json, (String)"only_render_for_slot", (boolean)false)) {
                accessory.onlyRenderSlot();
            }
            if (GsonHelper.m_13855_((JsonObject)json, (String)"hand_visibility_fix", (boolean)false)) {
                accessory.handVisibilityFix();
            }
            return accessory;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Humanoid Model Layer");
            builder.setDescription("Renders a humanoid model layer on the player");
            builder.addProperty("texture", TextureReference.class).description("Texture for the accessory. Can be skin-typed by specifying 'normal' and 'slim' in a json object.").required().exampleJson((JsonElement)new JsonPrimitive("example:textures/accessory/test.png"));
            builder.addProperty("model_layer", ModelLayerLocationUtil.class).description("Model layer for the accessory. Can be skin-typed by specifying 'normal' and 'slim' in a json object.").required().exampleJson((JsonElement)new JsonPrimitive("example:textures/accessory/test.png"));
            builder.addProperty("glowing", Boolean.class).description("Makes the overlay glow").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            builder.addProperty("only_render_for_slot", Boolean.class).description("If set to true, the texture will only render for the specified slot of the accessory. Example: The texture has a full player skin and the slot is set to 'head', only the head part of it will render.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            builder.addProperty("hand_visibility_fix", Boolean.class).description("If 'only_render_for_slot' is set to true while the slot is for a hand but you want to have the accessory on the arm, set this to true.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            AccessoryParser.addSlotDocumentation(builder);
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("humanoid_model_layer");
        }
    }
}

