/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.accessory.DefaultAccessory;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AccessoryParser;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class RenderLayerAccessory
extends DefaultAccessory {
    public final ResourceLocation renderLayerId;
    private Object renderLayer;
    private boolean disableRendering = false;

    public RenderLayerAccessory(ResourceLocation renderLayerId) {
        this.renderLayerId = renderLayerId;
    }

    public RenderLayerAccessory disableRendering() {
        this.disableRendering = true;
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onReload(EntityModelSet entityModelSet) {
        this.renderLayer = PackRenderLayerManager.getInstance().getLayer(this.renderLayerId);
        if (this.renderLayer == null) {
            AddonPackLog.warning("Unknown render layer used in accessory: " + String.valueOf(this.renderLayerId), new Object[0]);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent, AccessorySlot slot, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Object object;
        if (!this.disableRendering && (object = this.renderLayer) instanceof IPackRenderLayer) {
            IPackRenderLayer layer = (IPackRenderLayer)object;
            EntityModel entityModel = renderLayerParent.m_7200_();
            layer.render(DataContext.forEntity((Entity)player), poseStack, bufferSource, (EntityModel<Entity>)entityModel, packedLightIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderArm(HumanoidArm arm, AbstractClientPlayer player, PlayerRenderer playerRenderer, ModelPart armPart, ModelPart armWearPart, AccessorySlot slot, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Object object;
        if (!this.disableRendering && (object = this.renderLayer) instanceof IPackRenderLayer) {
            IPackRenderLayer layer = (IPackRenderLayer)object;
            layer.renderArm(DataContext.forEntity((Entity)player), arm, playerRenderer, poseStack, bufferSource, packedLight);
        }
    }

    public static class Serializer
    implements AccessoryParser.TypeSerializer {
        @Override
        public DefaultAccessory parse(JsonObject json) {
            RenderLayerAccessory accessory = new RenderLayerAccessory(GsonUtil.getAsResourceLocation(json, "render_layer"));
            if (GsonHelper.m_13855_((JsonObject)json, (String)"disable_rendering", (boolean)false)) {
                accessory.disableRendering();
            }
            return accessory;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Render Layer");
            builder.setDescription("Let's you use a render layer as an accessory");
            builder.addProperty("render_layer", ResourceLocation.class).description("ID of the render layer that's being used").required().exampleJson((JsonElement)new JsonPrimitive("namespace:example_layer"));
            builder.addProperty("disable_rendering", Boolean.class).description("Disables the rendering of the accessory, in case you want to hook it up to a render_layer_from_accessory ability").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            AccessoryParser.addSlotDocumentation(builder);
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("render_layer");
        }
    }
}

