/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.entity.BodyPart;

public class WoodenLegAccessory
extends Accessory {
    public static final ResourceLocation TEXTURE = Palladium.id("textures/models/accessories/wooden_leg.png");
    private Object woodenLegModel;
    private Object shortenedLegsModel;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onReload(EntityModelSet entityModelSet) {
        this.shortenedLegsModel = new PlayerModel(entityModelSet.m_171103_(new ModelLayerLocation(Palladium.id("player"), "shortened_legs")), false);
        this.woodenLegModel = new PlayerModel(entityModelSet.m_171103_(new ModelLayerLocation(Palladium.id("humanoid"), "wooden_legs")), false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent, AccessorySlot slot, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Object object = this.woodenLegModel;
        if (object instanceof HumanoidModel) {
            HumanoidModel woodLegs = (HumanoidModel)object;
            object = this.shortenedLegsModel;
            if (object instanceof PlayerModel) {
                PlayerModel shortened = (PlayerModel)object;
                ((PlayerModel)renderLayerParent.m_7200_()).m_102872_(woodLegs);
                ((PlayerModel)renderLayerParent.m_7200_()).m_102872_((HumanoidModel)shortened);
                woodLegs.m_8009_(false);
                shortened.m_8009_(false);
                for (BodyPart p : slot.getHiddenBodyParts((Player)player)) {
                    p.setVisibility(woodLegs, true);
                    p.setVisibility((HumanoidModel<?>)shortened, true);
                }
                VertexConsumer buffer = bufferSource.m_6299_(Objects.requireNonNull(this.getRenderType(player, player.m_108560_(), (Model)renderLayerParent.m_7200_())));
                shortened.m_7695_(poseStack, buffer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                buffer = bufferSource.m_6299_(Objects.requireNonNull(this.getRenderType(player, TEXTURE, (Model)renderLayerParent.m_7200_())));
                woodLegs.m_7695_(poseStack, buffer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public Collection<AccessorySlot> getPossibleSlots() {
        return Arrays.asList(AccessorySlot.LEFT_LEG, AccessorySlot.RIGHT_LEG);
    }
}

