/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.builder;

import java.util.LinkedList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladiumcore.registry.CreativeModeTabRegistry;

public class CreativeModeTabBuilder
extends AddonBuilder<CreativeModeTab> {
    private ResourceLocation iconItemId;
    private Component title;
    private final LinkedList<ResourceLocation> itemIds = new LinkedList();

    public CreativeModeTabBuilder(ResourceLocation id) {
        super(id);
        this.title = Component.m_237115_((String)("itemGroup." + id.m_135827_() + "." + id.m_135815_()));
    }

    @Override
    protected CreativeModeTab create() {
        return CreativeModeTabRegistry.create(builder -> {
            builder.m_257737_(() -> new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(this.iconItemId)));
            builder.m_257941_(this.title);
            builder.m_257501_((itemDisplayParameters, output) -> {
                for (ResourceLocation itemId : this.itemIds) {
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
                    if (item != Items.f_41852_) {
                        output.m_246326_((ItemLike)item);
                        continue;
                    }
                    AddonPackLog.warning("Tried to add unknown item '" + String.valueOf(itemId) + "' to creative mode tab '" + String.valueOf(this.getId()) + "'", new Object[0]);
                }
            });
        });
    }

    public CreativeModeTabBuilder itemIconId(ResourceLocation iconItemId) {
        this.iconItemId = iconItemId;
        return this;
    }

    public CreativeModeTabBuilder title(Component title) {
        this.title = title;
        return this;
    }

    public CreativeModeTabBuilder addItem(ResourceLocation itemId) {
        this.itemIds.add(itemId);
        return this;
    }
}

