/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.forge;

import com.google.common.base.Charsets;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.resource.ResourcePackLoader;
import net.threetag.palladium.addonpack.AddonPackManager;
import net.threetag.palladium.mixin.forge.PathPackResourcesAccessor;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddonPackManagerImpl {
    public static RepositorySource getModRepositorySource() {
        return new ModPackSource(Objects.requireNonNull(AddonPackManager.getPackType()));
    }

    public static class ModPackSource
    implements RepositorySource {
        private final PackType type;

        public ModPackSource(PackType type) {
            this.type = type;
        }

        public void m_7686_(Consumer<Pack> onLoad) {
            for (IModInfo modInfo : ModList.get().getMods()) {
                String name;
                Pack packInfo;
                PathPackResources pack = ResourcePackLoader.createPackForMod((IModFileInfo)modInfo.getOwningFile());
                if (Objects.equals(pack.m_5542_(), "minecraft") || (packInfo = Pack.m_245429_((String)(name = "mod:" + modInfo.getModId()), (Component)Component.m_237113_((String)pack.m_5542_()), (boolean)false, id -> new ModResourcePack(pack, modInfo), (PackType)AddonPackManager.getPackType(), (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_)) == null) continue;
                onLoad.accept(packInfo);
            }
        }
    }

    public static class ModResourcePack
    extends PathPackResources {
        private final PathPackResources parent;
        private final IModInfo mod;

        public ModResourcePack(PathPackResources parent, IModInfo mod) {
            super(parent.m_5542_(), parent.m_246538_(), parent.getSource());
            this.parent = parent;
            this.mod = mod;
        }

        @Nullable
        public IoSupplier<InputStream> m_8017_(String ... paths) {
            String fileName = String.join((CharSequence)"/", paths);
            Path path = this.resolve(paths);
            if ("pack.mcmeta".equals(fileName) && (path == null || !Files.exists(path, new LinkOption[0]))) {
                String id = this.mod.getModId();
                String version = MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)this.mod.getVersion());
                String description = this.mod.getDescription();
                String pack = String.format("{\"pack\":{\"id\": \"%s\", \"version\": \"%s\", \"description\":\"%s\"}}", id, version, description);
                return () -> IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
            }
            return super.m_8017_(paths);
        }

        @NotNull
        protected Path resolve(String ... paths) {
            Path path;
            PathPackResources pathPackResources = this.parent;
            if (pathPackResources instanceof PathPackResourcesAccessor) {
                PathPackResourcesAccessor acc = (PathPackResourcesAccessor)pathPackResources;
                path = acc.invokeResolve(paths);
            } else {
                path = super.resolve(paths);
            }
            return path;
        }
    }
}

