/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.accessory.DefaultAccessory;
import net.threetag.palladium.accessory.HumanoidModelOverlayAccessory;
import net.threetag.palladium.accessory.OverlayAccessory;
import net.threetag.palladium.accessory.RenderLayerAccessory;
import net.threetag.palladium.addonpack.builder.AccessoryBuilder;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.IDocumentedConfigurable;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.json.GsonUtil;

public class AccessoryParser
extends AddonParser<Accessory> {
    private static final Map<ResourceLocation, TypeSerializer> TYPE_SERIALIZERS = new LinkedHashMap<ResourceLocation, TypeSerializer>();

    public AccessoryParser() {
        super(GSON, "accessories", Accessory.REGISTRY.getRegistryKey());
    }

    @Override
    public AddonBuilder<Accessory> parse(ResourceLocation id, JsonElement jsonElement) {
        JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"$");
        AccessoryBuilder builder = new AccessoryBuilder(id, json);
        builder.type(TYPE_SERIALIZERS.get(GsonUtil.getAsResourceLocation(json, "type", null)));
        JsonElement slotJson = json.get("slot");
        if (slotJson.isJsonPrimitive()) {
            builder.addSlot(AccessorySlot.getSlotByName(GsonUtil.getAsResourceLocation(json, "slot")));
        } else if (slotJson.isJsonArray()) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"slot");
            for (JsonElement element : array) {
                builder.addSlot(AccessorySlot.getSlotByName(GsonUtil.convertToResourceLocation(element, "slot[].$")));
            }
        }
        return builder;
    }

    public static void registerTypeSerializer(TypeSerializer serializer) {
        TYPE_SERIALIZERS.put(serializer.getId(), serializer);
    }

    public static HTMLBuilder documentationBuilder() {
        return new HTMLBuilder(new ResourceLocation("palladium", "accessories"), "Accessories").add(HTMLBuilder.heading("Accessories")).addDocumentationSettings(new ArrayList<IDocumentedConfigurable>(TYPE_SERIALIZERS.values()));
    }

    public static void addSlotDocumentation(JsonDocumentationBuilder builder) {
        builder.addProperty("slot", ResourceLocation.class).description("ID of the slot the accessory will be in. Can be one or many. Possible values: " + Arrays.toString(AccessorySlot.getSlots().stream().map(AccessorySlot::getName).toArray())).required().exampleJson((JsonElement)new JsonPrimitive("palladium:head"));
    }

    static {
        AccessoryParser.registerTypeSerializer(new DefaultAccessory.Serializer());
        AccessoryParser.registerTypeSerializer(new RenderLayerAccessory.Serializer());
        AccessoryParser.registerTypeSerializer(new OverlayAccessory.Serializer());
        AccessoryParser.registerTypeSerializer(new HumanoidModelOverlayAccessory.Serializer());
    }

    public static interface TypeSerializer
    extends IDocumentedConfigurable {
        public DefaultAccessory parse(JsonObject var1);
    }
}

