/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.crafting.Ingredient;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.item.SimpleArmorMaterial;

public class ArmorMaterialParser
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, ArmorMaterial> ARMOR_MATERIALS = new HashMap<ResourceLocation, ArmorMaterial>();

    public ArmorMaterialParser() {
        super(AddonParser.GSON, "armor_materials");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ArmorMaterialParser.registerArmorMaterial(new ResourceLocation("leather"), (ArmorMaterial)ArmorMaterials.LEATHER);
        ArmorMaterialParser.registerArmorMaterial(new ResourceLocation("chainmail"), (ArmorMaterial)ArmorMaterials.CHAIN);
        ArmorMaterialParser.registerArmorMaterial(new ResourceLocation("iron"), (ArmorMaterial)ArmorMaterials.IRON);
        ArmorMaterialParser.registerArmorMaterial(new ResourceLocation("gold"), (ArmorMaterial)ArmorMaterials.GOLD);
        ArmorMaterialParser.registerArmorMaterial(new ResourceLocation("diamond"), (ArmorMaterial)ArmorMaterials.DIAMOND);
        ArmorMaterialParser.registerArmorMaterial(new ResourceLocation("turtle"), (ArmorMaterial)ArmorMaterials.TURTLE);
        ArmorMaterialParser.registerArmorMaterial(new ResourceLocation("netherite"), (ArmorMaterial)ArmorMaterials.NETHERITE);
        AtomicInteger i = new AtomicInteger();
        object.forEach((id, jsonElement) -> {
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"$");
                SimpleArmorMaterial armorMaterial = ArmorMaterialParser.parse(id, json);
                ArmorMaterialParser.registerArmorMaterial(id, (ArmorMaterial)armorMaterial);
                i.getAndIncrement();
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)("Error while parsing addonpack armor material  '" + String.valueOf(id) + "'"));
                CrashReportCategory reportCategory = crashReport.m_127516_("Addon Armor Material", 1);
                reportCategory.m_128159_("Resource name", id);
                throw new ReportedException(crashReport);
            }
        });
        AddonPackLog.info("Registered " + i.get() + " addonpack armor materials", new Object[0]);
    }

    public static void registerArmorMaterial(ResourceLocation id, ArmorMaterial armorMaterial) {
        ARMOR_MATERIALS.put(id, armorMaterial);
    }

    public static ArmorMaterial getArmorMaterial(ResourceLocation id) {
        return ARMOR_MATERIALS.get(id);
    }

    public static Set<ResourceLocation> getIds() {
        return ARMOR_MATERIALS.keySet();
    }

    public static SimpleArmorMaterial parse(ResourceLocation id, JsonObject json) {
        return new SimpleArmorMaterial(id.m_135815_(), GsonUtil.getAsIntMin(json, "durability_multiplier", 0), ArmorMaterialParser.parseArmorProtectionMap(json.get("slot_protections")), GsonUtil.getAsIntMin(json, "enchantment_value", 0), () -> (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(GsonUtil.getAsResourceLocation(json, "equip_sound")), GsonHelper.m_13820_((JsonObject)json, (String)"toughness", (float)0.0f), GsonHelper.m_13820_((JsonObject)json, (String)"knockback_resistance", (float)0.0f), () -> json.has("repair_ingredient") ? Ingredient.m_43917_((JsonElement)json.get("repair_ingredient")) : Ingredient.f_43901_);
    }

    public static EnumMap<ArmorItem.Type, Integer> parseArmorProtectionMap(JsonElement jsonElement) {
        EnumMap<ArmorItem.Type, Integer> map = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        if (jsonElement.isJsonArray()) {
            JsonArray array = jsonElement.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                ArmorItem.Type type = ArmorItem.Type.values()[3 - i];
                map.put(type, array.get(i).getAsInt());
            }
        } else if (jsonElement.isJsonObject()) {
            JsonObject object = jsonElement.getAsJsonObject();
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                if (!GsonHelper.m_13900_((JsonObject)object, (String)type.m_266355_())) continue;
                map.put(type, GsonUtil.getAsIntMin(object, type.m_266355_(), 0));
            }
        } else {
            throw new JsonParseException("slot_protections must be json array or object");
        }
        return map;
    }

    public static HTMLBuilder documentationBuilder() {
        JsonDocumentationBuilder builder = new JsonDocumentationBuilder().setDescription("Each armor material goes into a seperate file into the 'addon/[namespace]/armor_materials' folder, which can then be used for custom armor items/suit sets.");
        builder.addProperty("durability_multiplier", Integer.class).description("A value that gets multiplied with 13, 15, 16 or 11 (feet, legs, chest, head) depending on the slot. Used for the durability value of the item.").required().exampleJson((JsonElement)new JsonPrimitive((Number)12));
        JsonObject slotProtections = new JsonObject();
        slotProtections.addProperty(ArmorItem.Type.HELMET.m_266355_(), (Number)3);
        slotProtections.addProperty(ArmorItem.Type.CHESTPLATE.m_266355_(), (Number)8);
        slotProtections.addProperty(ArmorItem.Type.LEGGINGS.m_266355_(), (Number)6);
        slotProtections.addProperty(ArmorItem.Type.BOOTS.m_266355_(), (Number)3);
        builder.addProperty("slot_protections", JsonObject.class).description("Protection values for the armor pieces, determines the defense value of each slot. For reference (Order: feet, legs, chest, head), iron has [2, 5, 6, 2], diamond is in the example.").required().exampleJson((JsonElement)slotProtections);
        builder.addProperty("enchantment_value", Integer.class).description("Determines the enchantibility of the item. For reference: iron has 9, diamond 10, gold 25.").required().exampleJson((JsonElement)new JsonPrimitive((Number)12));
        builder.addProperty("equip_sound", ResourceLocation.class).description("Sound that is played when equipping the item into the slot.").required().exampleJson((JsonElement)new JsonPrimitive(Objects.requireNonNull(BuiltInRegistries.f_256894_.m_7981_((Object)SoundEvents.f_11677_)).toString()));
        builder.addProperty("toughness", Float.class).description("Adds additional armor toughness. For reference: diamond has 2.0, netherite has 3.0, rest has 0.").fallback(Float.valueOf(0.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.5f)));
        builder.addProperty("knockback_resistance", Float.class).description("Adds knockback resistance. For reference: netherite has 0.1, rest has 0.").fallback(Float.valueOf(0.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.1f)));
        builder.addProperty("repair_ingredient", Ingredient.class).description("Ingredient definition for repairing the item in an anvil. Can be defined like in recipes.").fallback(Ingredient.f_43901_, "empty ingredient").exampleJson(Ingredient.m_204132_((TagKey)ItemTags.f_198160_).m_43942_());
        return new HTMLBuilder(new ResourceLocation("palladium", "armor_materials"), "Armor Materials").add(HTMLBuilder.heading("Armor Materials")).addDocumentation(builder);
    }
}

