/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.builder.ItemBuilder;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.IDocumentedConfigurable;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonArmorItem;
import net.threetag.palladium.item.AddonAxeItem;
import net.threetag.palladium.item.AddonBlockItem;
import net.threetag.palladium.item.AddonBowItem;
import net.threetag.palladium.item.AddonCrossbowItem;
import net.threetag.palladium.item.AddonHoeItem;
import net.threetag.palladium.item.AddonItem;
import net.threetag.palladium.item.AddonPickaxeItem;
import net.threetag.palladium.item.AddonProjectileItem;
import net.threetag.palladium.item.AddonShieldItem;
import net.threetag.palladium.item.AddonShovelItem;
import net.threetag.palladium.item.AddonSwordItem;
import net.threetag.palladium.item.FluxCapacitorItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.power.ability.AttributeModifierAbility;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.registry.CreativeModeTabRegistry;
import net.threetag.palladiumcore.util.Platform;

public class ItemParser
extends AddonParser<Item> {
    public static final ResourceLocation FALLBACK_SERIALIZER = Palladium.id("default");
    private static final Map<ResourceLocation, ItemTypeSerializer> TYPE_SERIALIZERS = new LinkedHashMap<ResourceLocation, ItemTypeSerializer>();
    public final Map<ResourceLocation, List<PlacedTabPlacement>> autoRegisteredBlockItems = new HashMap<ResourceLocation, List<PlacedTabPlacement>>();

    public ItemParser() {
        super(GSON, "items", Registries.f_256913_);
    }

    @Override
    public void injectJsons(Map<ResourceLocation, JsonElement> map) {
        for (ResourceLocation id : this.autoRegisteredBlockItems.keySet()) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "palladium:block_item");
            json.addProperty("block", id.toString());
            JsonArray jsonArray = new JsonArray();
            if (this.autoRegisteredBlockItems.get(id) != null) {
                for (PlacedTabPlacement tabPlacement : this.autoRegisteredBlockItems.get(id)) {
                    jsonArray.add(tabPlacement.toJson());
                }
            }
            json.add("creative_mode_tab", (JsonElement)jsonArray);
            map.put(id, (JsonElement)json);
        }
    }

    @Override
    public AddonBuilder<Item> parse(ResourceLocation id, JsonElement jsonElement) {
        JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"$");
        ItemBuilder builder = new ItemBuilder(id, json);
        builder.type(GsonUtil.getAsResourceLocation(json, "type", null)).maxStackSize(GsonUtil.getAsIntRanged(json, "max_stack_size", 1, 64, 64)).maxDamage(GsonUtil.getAsIntMin(json, "max_damage", 1, 0)).rarity(ItemParser.getRarity(GsonHelper.m_13851_((JsonObject)json, (String)"rarity", null))).fireResistant(GsonHelper.m_13855_((JsonObject)json, (String)"is_fire_resistant", (boolean)false)).tooltipLines(GsonUtil.getAsComponentList(json, "tooltip", null)).shouldRenderModel(GsonHelper.m_13855_((JsonObject)json, (String)"should_render_model", (boolean)true));
        GsonUtil.ifHasKey(json, "creative_mode_tab", je -> {
            for (PlacedTabPlacement placedTabPlacement : GsonUtil.fromListOrPrimitive(je, PlacedTabPlacement::fromJson)) {
                builder.creativeModeTab(placedTabPlacement);
            }
        });
        GsonUtil.ifHasKey(json, "attribute_modifiers", je -> ItemParser.parseAttributeModifiers(builder, je));
        if (Platform.isClient()) {
            GsonUtil.ifHasObject(json, "render_layers", jsonObject -> {
                IAddonItem.RenderLayerContainer container = new IAddonItem.RenderLayerContainer();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    GsonUtil.forEachInListOrPrimitive((JsonElement)entry.getValue(), idElement -> container.addLayer(key, new ResourceLocation(idElement.getAsString())));
                }
                builder.setRenderLayerContainer(container);
            });
        }
        GsonUtil.ifHasObject(json, "food", foodJson -> {
            FoodProperties.Builder properties = new FoodProperties.Builder();
            GsonUtil.ifHasKey(foodJson, "nutrition", el -> properties.m_38760_(GsonHelper.m_13897_((JsonElement)el, (String)"$.food.nutrition")));
            GsonUtil.ifHasKey(foodJson, "saturation_modifier", el -> properties.m_38758_(GsonHelper.m_13888_((JsonElement)el, (String)"$.food.saturation_modifier")));
            if (GsonHelper.m_13855_((JsonObject)foodJson, (String)"meat", (boolean)false)) {
                properties.m_38757_();
            }
            if (GsonHelper.m_13855_((JsonObject)foodJson, (String)"can_always_eat", (boolean)false)) {
                properties.m_38765_();
            }
            if (GsonHelper.m_13855_((JsonObject)foodJson, (String)"fast", (boolean)false)) {
                properties.m_38766_();
            }
            GsonUtil.ifHasArray(foodJson, "effects", effectEl -> {
                JsonObject effect = GsonHelper.m_13918_((JsonElement)effectEl, (String)"$.food.effects");
                ResourceLocation mobEffect = GsonUtil.getAsResourceLocation(effect, "mob_effect");
                if (!BuiltInRegistries.f_256974_.m_7804_(mobEffect)) {
                    throw new JsonParseException("Mob effect type '" + mobEffect.toString() + "' does not exist");
                }
                int duration = GsonHelper.m_13824_((JsonObject)effect, (String)"duration", (int)0);
                int amplifier = GsonHelper.m_13824_((JsonObject)effect, (String)"amplifier", (int)0);
                boolean ambient = GsonHelper.m_13855_((JsonObject)effect, (String)"ambient", (boolean)false);
                boolean visible = GsonHelper.m_13855_((JsonObject)effect, (String)"visible", (boolean)true);
                boolean showIcon = GsonHelper.m_13855_((JsonObject)effect, (String)"show_icon", (boolean)true);
                float probability = GsonHelper.m_13820_((JsonObject)effect, (String)"probability", (float)1.0f);
                properties.m_38762_(new MobEffectInstance(Objects.requireNonNull((MobEffect)BuiltInRegistries.f_256974_.m_7745_(mobEffect)), duration, amplifier, ambient, visible, showIcon), probability);
            });
            builder.food(properties.m_38767_());
        });
        return builder;
    }

    public static HTMLBuilder documentationBuilder() {
        return new HTMLBuilder(new ResourceLocation("palladium", "items"), "Items").add(HTMLBuilder.heading("Items")).add(HTMLBuilder.subHeading("Global Settings")).addDocumentation(ItemParser.getDefaultDocumentationBuilder()).addDocumentationSettings(new ArrayList<IDocumentedConfigurable>(TYPE_SERIALIZERS.values()));
    }

    public static Rarity getRarity(String name) {
        for (Rarity rarity : Rarity.values()) {
            if (!rarity.name().equalsIgnoreCase(name)) continue;
            return rarity;
        }
        return null;
    }

    public static void parseAttributeModifiers(ItemBuilder builder, JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject object = jsonElement.getAsJsonObject();
            for (String key : object.keySet()) {
                PlayerSlot slot = PlayerSlot.get(key);
                JsonElement mods = object.get(key);
                if (mods.isJsonArray()) {
                    JsonArray modsList = mods.getAsJsonArray();
                    for (JsonElement mod : modsList) {
                        builder.addAttributeModifier(slot, GsonUtil.getAsResourceLocation(mod.getAsJsonObject(), "attribute"), ItemParser.parseAttributeModifier(mod.getAsJsonObject()));
                    }
                    continue;
                }
                if (mods.isJsonObject()) {
                    builder.addAttributeModifier(slot, GsonUtil.getAsResourceLocation(mods.getAsJsonObject(), "attribute"), ItemParser.parseAttributeModifier(mods.getAsJsonObject()));
                    continue;
                }
                throw new JsonSyntaxException("Attribute modifiers definitions need to be either an object or an array");
            }
        } else {
            throw new JsonSyntaxException("The attribute modifier definition needs to be an object");
        }
    }

    public static AttributeModifier parseAttributeModifier(JsonObject json) {
        UUID uuid = GsonUtil.getAsUUID(json, "uuid");
        String name = GsonHelper.m_13851_((JsonObject)json, (String)"name", (String)"Addonpack Item Modifier");
        double amount = GsonHelper.m_144784_((JsonObject)json, (String)"amount");
        AttributeModifier.Operation operation = AttributeModifier.Operation.m_22236_((int)GsonUtil.getAsIntRanged(json, "operation", AttributeModifier.Operation.ADDITION.m_22235_(), AttributeModifier.Operation.MULTIPLY_TOTAL.m_22235_()));
        return new AttributeModifier(uuid, name, amount, operation);
    }

    public static void registerTypeSerializer(ItemTypeSerializer serializer) {
        TYPE_SERIALIZERS.put(serializer.getId(), serializer);
    }

    public static ItemTypeSerializer getTypeSerializer(ResourceLocation id) {
        return TYPE_SERIALIZERS.get(id);
    }

    public static JsonDocumentationBuilder getDefaultDocumentationBuilder() {
        JsonDocumentationBuilder builder = new JsonDocumentationBuilder();
        builder.setDescription("These settings apply to ALL item types. Keep in mind that if fields are not required, you do NOT need to write them into your json.");
        builder.addProperty("type", ResourceLocation.class).description("Item Type, each come with new different settings. Listed below on this page.").fallback(new ResourceLocation("palladium:default"));
        builder.addProperty("max_stack_size", Integer.class).description("Max stack size for an itemstack. Range: 1-64").fallback(64).exampleJson((JsonElement)new JsonPrimitive((Number)64));
        builder.addProperty("max_damage", Integer.class).description("Max damage for an item. Must be greater then or equal 0.").fallback(0);
        builder.addProperty("creative_mode_tab", ResourceLocation.class).description("ID of the creative mode tab the item is supposed to appear in. Fore more precise placements, check the \"Custom Items\" page on the wiki. Possible values: " + Arrays.toString(BuiltInRegistries.f_279662_.m_6566_().stream().sorted(Comparator.comparing(ResourceLocation::toString)).toArray())).fallback(null).exampleJson((JsonElement)new JsonPrimitive("minecraft:decorations"));
        builder.addProperty("rarity", String.class).description("Rarity of the item, influences the item name's color. Possible values: " + Arrays.toString(Arrays.stream(Rarity.values()).map(r -> r.toString().toLowerCase(Locale.ROOT)).toArray())).fallback(null).exampleJson((JsonElement)new JsonPrimitive("epic"));
        builder.addProperty("is_fire_resistant", Boolean.class).description("Whether or not the item will survive being thrown into fire/lava.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        builder.addProperty("should_render_model", Boolean.class).description("If false, the item model will be ignored (except in the inventory). In first person, the player's arm will render instead. This allows a render layer to be applied in place of a less-dynamic item model.").fallback(true).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        JsonArray tooltipExample = new JsonArray();
        tooltipExample.add("Line 1");
        JsonObject line2 = new JsonObject();
        line2.addProperty("translate", "example.line2.translation_key");
        line2.addProperty("color", "#BCD42A");
        line2.addProperty("underlined", Boolean.valueOf(true));
        tooltipExample.add((JsonElement)line2);
        builder.addProperty("tooltip", Component[].class).description("Tooltip lines. Can be array of primitive strings or more complex text component").fallback(null).exampleJson((JsonElement)tooltipExample);
        JsonObject attributeModifiers = (JsonObject)GsonHelper.m_13794_((Gson)GSON, (String)"{ \"all\": [ { \"attribute\": \"minecraft:generic.max_health\", \"amount\": 2, \"operation\": 0, \"uuid\": \"f98db25e-91cb-45ca-ba40-5526ff2cd180\" } ],\"chest\": [ { \"attribute\": \"minecraft:generic.movement_speed\", \"amount\": 4, \"operation\": 1, \"uuid\": \"3a4df804-2be2-4002-a829-eaf29a629cac\" } ] }", JsonObject.class);
        builder.addProperty("attribute_modifiers", AttributeModifier[].class).description("Attribute modifiers when having the item equipped. You first specify the slot (\"all\" for every slot, other options: " + Arrays.toString(Arrays.stream(EquipmentSlot.values()).map(EquipmentSlot::m_20751_).toArray()) + "), then an array for different modifiers. Possible attributes: " + AttributeModifierAbility.getAttributeList()).fallback(null).exampleJson((JsonElement)attributeModifiers);
        JsonObject foodExample = new JsonObject();
        foodExample.addProperty("nutrition", (Number)5);
        foodExample.addProperty("saturation_modifier", (Number)Float.valueOf(0.6f));
        foodExample.addProperty("meat", Boolean.valueOf(false));
        foodExample.addProperty("can_always_eat", Boolean.valueOf(false));
        foodExample.addProperty("fast", Boolean.valueOf(false));
        JsonArray effectsExample = new JsonArray();
        JsonObject effectExample = new JsonObject();
        effectExample.addProperty("mob_effect", Objects.requireNonNull(BuiltInRegistries.f_256974_.m_7981_((Object)MobEffects.f_19600_)).toString());
        effectExample.addProperty("duration", (Number)40);
        effectExample.addProperty("amplifier", (Number)1);
        effectExample.addProperty("ambient", Boolean.valueOf(false));
        effectExample.addProperty("visible", Boolean.valueOf(true));
        effectExample.addProperty("show_icon", Boolean.valueOf(true));
        effectExample.addProperty("probability", (Number)Float.valueOf(1.0f));
        effectsExample.add((JsonElement)effectExample);
        foodExample.add("effects", (JsonElement)effectsExample);
        builder.addProperty("food", FoodProperties.class).description("Settings to make this item edible. The only required field in this json part is the mob_effect IF you add any effect").fallback(null).exampleJson((JsonElement)foodExample);
        return builder;
    }

    static {
        ItemParser.registerTypeSerializer(new AddonItem.Parser());
        ItemParser.registerTypeSerializer(new AddonBlockItem.Parser());
        ItemParser.registerTypeSerializer(new AddonArmorItem.Parser());
        ItemParser.registerTypeSerializer(new AddonSwordItem.Parser());
        ItemParser.registerTypeSerializer(new AddonPickaxeItem.Parser());
        ItemParser.registerTypeSerializer(new AddonAxeItem.Parser());
        ItemParser.registerTypeSerializer(new AddonShovelItem.Parser());
        ItemParser.registerTypeSerializer(new AddonHoeItem.Parser());
        ItemParser.registerTypeSerializer(new AddonShieldItem.Parser());
        ItemParser.registerTypeSerializer(new AddonBowItem.Parser());
        ItemParser.registerTypeSerializer(new AddonCrossbowItem.Parser());
        ItemParser.registerTypeSerializer(new FluxCapacitorItem.Parser());
        ItemParser.registerTypeSerializer(new AddonProjectileItem.Parser());
    }

    public static class PlacedTabPlacement {
        private final int type;
        private final ResourceLocation referencedItem;
        private final ResourceLocation tab;

        private PlacedTabPlacement(int type, ResourceLocation referencedItem, ResourceLocation tab) {
            this.type = type;
            this.referencedItem = referencedItem;
            this.tab = tab;
        }

        public ResourceLocation getTab() {
            return this.tab;
        }

        public static PlacedTabPlacement add(ResourceLocation tab) {
            return new PlacedTabPlacement(0, null, tab);
        }

        public static PlacedTabPlacement addAfter(ResourceLocation afterItem, ResourceLocation tab) {
            return new PlacedTabPlacement(1, afterItem, tab);
        }

        public static PlacedTabPlacement addBefore(ResourceLocation beforeItem, ResourceLocation tab) {
            return new PlacedTabPlacement(2, beforeItem, tab);
        }

        public void addToTab(CreativeModeTabRegistry.ItemGroupEntries entries, Item item) {
            if (this.type == 0) {
                entries.add(new ItemLike[]{item});
            } else if (this.type == 1) {
                Item addAfter = (Item)BuiltInRegistries.f_257033_.m_7745_(this.referencedItem);
                if (addAfter == Items.f_41852_) {
                    AddonPackLog.warning("Tried to add '" + String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)item)) + "' after unknown item '" + String.valueOf(this.referencedItem) + "' in creative mode tab", new Object[0]);
                    entries.add(new ItemLike[]{item});
                } else {
                    entries.addAfter((ItemLike)addAfter, new ItemLike[]{item});
                }
            } else if (this.type == 2) {
                Item addBefore = (Item)BuiltInRegistries.f_257033_.m_7745_(this.referencedItem);
                if (addBefore == Items.f_41852_) {
                    AddonPackLog.warning("Tried to add '" + String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)item)) + "' before unknown item '" + String.valueOf(this.referencedItem) + "' in creative mode tab", new Object[0]);
                    entries.add(new ItemLike[]{item});
                } else {
                    entries.addBefore((ItemLike)addBefore, new ItemLike[]{item});
                }
            }
        }

        public static PlacedTabPlacement fromJson(JsonElement jsonElement) {
            if (jsonElement.isJsonPrimitive()) {
                return PlacedTabPlacement.add(GsonUtil.convertToResourceLocation(jsonElement, "creative_mode_tab"));
            }
            JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"creative_mode_tab");
            if (GsonHelper.m_13900_((JsonObject)json, (String)"after")) {
                return PlacedTabPlacement.addAfter(GsonUtil.convertToResourceLocation(json.get("after"), "creative_mode_tab.after"), GsonUtil.getAsResourceLocation(json, "tab"));
            }
            if (GsonHelper.m_13900_((JsonObject)json, (String)"before")) {
                return PlacedTabPlacement.addBefore(GsonUtil.convertToResourceLocation(json.get("before"), "creative_mode_tab.after"), GsonUtil.getAsResourceLocation(json, "tab"));
            }
            return PlacedTabPlacement.add(GsonUtil.getAsResourceLocation(json, "tab"));
        }

        public JsonElement toJson() {
            if (this.type == 0) {
                return new JsonPrimitive(this.tab.toString());
            }
            JsonObject json = new JsonObject();
            json.addProperty(this.type == 1 ? "after" : "before", this.referencedItem.toString());
            json.addProperty("tab", this.tab.toString());
            return json;
        }
    }

    public static interface ItemTypeSerializer
    extends IDocumentedConfigurable {
        public IAddonItem parse(JsonObject var1, Item.Properties var2);
    }
}

